/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class GUIUtilities {
    public static final String ACCELERATOR_KEY = "AcceleratorKey";
    public static final String MNEMONIC_KEY = "MnemonicKey";
    public static final String LARGE_ICON = "LargeIcon";
    public static final String ROLLOVER_ICON = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON = "rolloverSelectedIcon";
    public static final String SELECTED_ICON = "selectedIcon";

    public static void addHotKey(JComponent pane, Action action) {
        GUIUtilities.addHotKey(pane, action, null);
    }

    public static void addHotKey(JComponent pane, Action action, KeyStroke key) {
        String name = (String)action.getValue("Name");
        if (key == null) {
            key = (KeyStroke)action.getValue(ACCELERATOR_KEY);
        } else {
            action.putValue(ACCELERATOR_KEY, key);
        }
        if (key != null) {
            pane.registerKeyboardAction(action, name, key, 2);
        }
    }

    public static void addIcons(Action action, String[][] iconRoles) {
        int i = 0;
        while (i < iconRoles.length) {
            URL img = action.getClass().getResource(iconRoles[i][0]);
            if (img != null) {
                ImageIcon icon = new ImageIcon(img);
                action.putValue(iconRoles[i][1], icon);
            }
            ++i;
        }
    }

    public static JMenuItem addMenuItem(JMenu menu, Action action) {
        String label = (String)action.getValue("Name");
        int mnemonic = 0;
        Integer i = (Integer)action.getValue(MNEMONIC_KEY);
        if (i != null) {
            mnemonic = i;
        }
        return GUIUtilities.addMenuItem(menu, label, action, mnemonic, null, true);
    }

    public static JMenuItem addMenuItem(JMenu menu, Action action, int mnemonic, String tooltip) {
        String label = (String)action.getValue("Name");
        return GUIUtilities.addMenuItem(menu, label, action, mnemonic, tooltip, true);
    }

    public static JMenuItem addMenuItem(JMenu menu, String label, Action action, int mnemonic, String tooltip, boolean isEnabled) {
        if (tooltip == null) {
            tooltip = (String)action.getValue("tooltip");
        } else {
            action.putValue("tooltip", tooltip);
        }
        action.putValue("tooltip", tooltip);
        JMenuItem item = menu.add(action);
        item.setText(label);
        item.setEnabled(isEnabled);
        item.setMnemonic(mnemonic);
        item.setToolTipText(tooltip);
        KeyStroke key = (KeyStroke)action.getValue(ACCELERATOR_KEY);
        item.setAccelerator(key);
        action.putValue("menuItem", item);
        return item;
    }

    public static JButton addToolBarButton(JToolBar toolbar, Action action) {
        Icon icon = (Icon)action.getValue(LARGE_ICON);
        String label = null;
        if (icon == null) {
            label = (String)action.getValue("Name");
        }
        return GUIUtilities.addToolBarButton(toolbar, action, null, icon, label, true);
    }

    public static JButton addToolBarButton(JToolBar toolbar, Action action, String tooltip, Icon icon) {
        return GUIUtilities.addToolBarButton(toolbar, action, tooltip, icon, null, true);
    }

    public static JButton addToolBarButton(JToolBar toolbar, Action action, String tooltip, Icon icon, boolean isEnabled) {
        return GUIUtilities.addToolBarButton(toolbar, action, tooltip, icon, null, isEnabled);
    }

    public static JButton addToolBarButton(JToolBar toolbar, Action action, String tooltip, String lbl) {
        return GUIUtilities.addToolBarButton(toolbar, action, tooltip, null, lbl, true);
    }

    public static JButton addToolBarButton(JToolBar toolbar, Action action, String tooltip, Icon icon, String lbl) {
        return GUIUtilities.addToolBarButton(toolbar, action, tooltip, icon, lbl, true);
    }

    public static JButton addToolBarButton(JToolBar toolbar, Action action, String tooltip, Icon icon, String lbl, boolean isEnabled) {
        Icon selectedIcon;
        Icon rolloverSelectedIcon;
        Icon rolloverIcon;
        if (tooltip == null) {
            tooltip = (String)action.getValue("tooltip");
        } else {
            action.putValue("tooltip", tooltip);
        }
        JButton button = toolbar.add(action);
        button.setToolTipText(tooltip);
        button.setText(null);
        button.setRequestFocusEnabled(false);
        if (icon != null) {
            button.setIcon(icon);
        }
        if (lbl != null) {
            button.setText(lbl);
        }
        if ((rolloverIcon = (Icon)action.getValue(ROLLOVER_ICON)) != null) {
            button.setRolloverIcon(rolloverIcon);
        }
        if ((rolloverSelectedIcon = (Icon)action.getValue(ROLLOVER_SELECTED_ICON)) != null) {
            button.setRolloverSelectedIcon(rolloverSelectedIcon);
        }
        if ((selectedIcon = (Icon)action.getValue(SELECTED_ICON)) != null) {
            button.setSelectedIcon(selectedIcon);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(true);
        button.setEnabled(isEnabled);
        action.putValue("toolBarButton", button);
        return button;
    }

    public static String ellipsis(String string, int length) {
        if (string.length() > length) {
            return String.valueOf(string.substring(0, length - 3)) + "...";
        }
        return string;
    }

    public static String getFileExtension(File file) {
        String str = file.getName();
        int i = str.lastIndexOf(46);
        if (i > 0) {
            return str.substring(i + 1);
        }
        return "";
    }

    public static String keyStrokeToString(KeyStroke key) {
        int modifiers = key.getModifiers();
        StringBuffer buffer = new StringBuffer();
        if ((modifiers & 1) == 1) {
            buffer.append("(Shift-");
            buffer.append(KeyEvent.getKeyText(key.getKeyCode()));
            buffer.append(")");
        }
        if ((modifiers & 2) == 2) {
            buffer.append("(Ctrl-");
            buffer.append(KeyEvent.getKeyText(key.getKeyCode()));
            buffer.append(")");
        }
        if ((modifiers & 4) == 4) {
            buffer.append("(Meta-");
            buffer.append(KeyEvent.getKeyText(key.getKeyCode()));
            buffer.append(")");
        }
        if ((modifiers & 8) == 8) {
            buffer.append("(Alt-");
            buffer.append(KeyEvent.getKeyText(key.getKeyCode()));
            buffer.append(")");
        }
        if (modifiers == 0) {
            buffer.append("(");
            buffer.append(KeyEvent.getKeyText(key.getKeyCode()));
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static void showException(Component parent, Exception e, String info) {
        Object[] message = new Object[1];
        String string = info != null ? String.valueOf(info) + "\n" + e.getMessage() : e.getMessage();
        message[0] = GUIUtilities.ellipsis(string, 400);
        Object[] options = new Object[]{"Dismiss", "Display Stack Trace"};
        int selected = JOptionPane.showOptionDialog(parent, message, "Exception Caught", 0, 2, null, options, options[0]);
        if (selected == 1) {
            GUIUtilities.showStackTrace(parent, e, info);
        }
    }

    public static void showStackTrace(Component parent, Exception e) {
        GUIUtilities.showStackTrace(parent, e, null);
    }

    public static void showStackTrace(Component parent, Exception e, String info) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        JTextArea text = new JTextArea(sw.toString(), 60, 80);
        JScrollPane stext = new JScrollPane(text);
        stext.setPreferredSize(new Dimension(400, 200));
        text.setCaretPosition(0);
        text.setEditable(false);
        Object[] message = new Object[2];
        String string = info != null ? String.valueOf(info) + "\n" + e.getMessage() : e.getMessage();
        message[0] = GUIUtilities.ellipsis(string, 400);
        message[1] = stext;
        JOptionPane.showMessageDialog(parent, message, "Exception Caught", 2);
    }
}

