/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import diva.gui.AbstractStoragePolicy;
import diva.gui.AppContext;
import diva.gui.Application;
import diva.gui.Document;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class DefaultStoragePolicy
extends AbstractStoragePolicy {
    private JFileChooser _openFileChooser = new JFileChooser();
    private JFileChooser _saveFileChooser = new JFileChooser();

    public boolean close(Document d) {
        block9: {
            if (d != null) {
                block7: {
                    int val;
                    block8: {
                        try {
                            String title;
                            String message;
                            d.close();
                            if (!d.isDirty()) break block7;
                            Component parent = d.getApplication().getAppContext().makeComponent();
                            val = JOptionPane.showConfirmDialog(parent, message = "Do you want to save your changes to " + d.getTitle(), title = "Closing Document", 1, 2);
                            if (val != 0) break block8;
                            if (this.save(d)) {
                                d.getApplication().removeDocument(d);
                                break block9;
                            }
                            return false;
                        }
                        catch (Exception e) {
                            d.getApplication().showError("Close document failed.", e);
                            return false;
                        }
                    }
                    if (val == 1) {
                        d.getApplication().removeDocument(d);
                        break block9;
                    }
                    return false;
                }
                d.getApplication().removeDocument(d);
            }
        }
        return true;
    }

    public JFileChooser getOpenFileChooser() {
        return this._openFileChooser;
    }

    public JFileChooser getFileChooser() {
        return this._openFileChooser;
    }

    public JFileChooser getSaveFileChooser() {
        return this._saveFileChooser;
    }

    public Document open(Application app) {
        this._openFileChooser.setCurrentDirectory(new File(this.getDirectory()));
        int result = this._openFileChooser.showOpenDialog(app.getAppContext().makeComponent());
        if (result == 0) {
            Document doc;
            try {
                File file = this._openFileChooser.getSelectedFile();
                doc = this.open(file, app);
            }
            catch (Exception e) {
                app.showError("File open failed.", e);
                return null;
            }
            return doc;
        }
        return null;
    }

    public Document open(File file, Application app) {
        Document doc;
        try {
            File canonical = file.getCanonicalFile();
            this.setDirectory(canonical);
            doc = app.getDocumentFactory().createDocument(app, canonical);
            doc.open();
        }
        catch (Exception e) {
            app.showError("File open failed.", e);
            return null;
        }
        return doc;
    }

    public Document open(URL url, Application app) {
        Document doc;
        try {
            doc = app.getDocumentFactory().createDocument(app, url);
            doc.open();
        }
        catch (Exception e) {
            app.showError("URL open failed.", e);
            return null;
        }
        return doc;
    }

    public boolean save(Document d) {
        if (d != null) {
            if (d.getFile() == null) {
                return this.saveAs(d);
            }
            try {
                d.save();
            }
            catch (Exception e) {
                d.getApplication().showError("Save document failed.", e);
                return false;
            }
            d.getApplication().getAppContext().showStatus("Saved " + d.getTitle());
            d.setDirty(false);
        }
        return true;
    }

    public boolean saveAs(Document d) {
        if (d != null) {
            Application app = d.getApplication();
            AppContext context = app.getAppContext();
            this._saveFileChooser.setCurrentDirectory(new File(this.getDirectory()));
            int result = this._saveFileChooser.showSaveDialog(context.makeComponent());
            if (result == 0) {
                int opt;
                File chosenFile = this._saveFileChooser.getSelectedFile();
                this.setDirectory(chosenFile);
                if (chosenFile.exists() && (opt = JOptionPane.showConfirmDialog(context.makeComponent(), "File \"" + chosenFile.getName() + "\" exists. Overwrite?", "Overwrite file?", 0)) != 0) {
                    context.showStatus("File not saved");
                    return false;
                }
                try {
                    d.saveAs(chosenFile);
                }
                catch (Exception e) {
                    app.showError("Save document failed.", e);
                    return false;
                }
                d.setFile(chosenFile);
                context.showStatus("Saved " + d.getTitle());
                d.setDirty(false);
                return true;
            }
            return false;
        }
        return true;
    }
}

