/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import diva.gui.Application;
import diva.gui.Document;
import diva.gui.View;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DefaultActions {
    public static final String COPY = "Copy";
    public static final String CLOSE = "Close";
    public static final String CUT = "Cut";
    public static final String EXIT = "Exit";
    public static final String NEW = "New";
    public static final String OPEN = "Open";
    public static final String PASTE = "Paste";
    public static final String PRINT = "Print";
    public static final String QUIT = "Quit";
    public static final String SAVE = "Save";
    public static final String SAVE_AS = "Save As";

    public static Action copyAction(final Application app) {
        return new AbstractAction(COPY){

            public void actionPerformed(ActionEvent e) {
                View view = app.getCurrentView();
                Clipboard c = app.getClipboard();
                if (view != null && c != null) {
                    view.copy(c);
                }
            }
        };
    }

    public static Action closeAction(final Application app) {
        return new AbstractAction(CLOSE){

            public void actionPerformed(ActionEvent e) {
                app.closeDocument(app.getCurrentView().getDocument());
            }
        };
    }

    public static Action cutAction(final Application app) {
        return new AbstractAction(CUT){

            public void actionPerformed(ActionEvent e) {
                View view = app.getCurrentView();
                Clipboard c = app.getClipboard();
                if (view != null && c != null) {
                    view.cut(c);
                }
            }
        };
    }

    public static Action exitAction(final Application app) {
        return new AbstractAction(EXIT){

            public void actionPerformed(ActionEvent e) {
                Iterator docs = app.documentList().iterator();
                boolean succeeded = true;
                while (docs.hasNext() && succeeded) {
                    Document d = (Document)docs.next();
                    succeeded &= app.closeDocument(d);
                }
                if (succeeded) {
                    System.exit(0);
                }
            }
        };
    }

    public static Action newAction(final Application app) {
        return new AbstractAction(NEW){

            public void actionPerformed(ActionEvent e) {
                Document doc = app.getDocumentFactory().createDocument(app);
                app.addDocument(doc);
                View v = app.createView(doc);
                app.addView(v);
                app.setCurrentView(v);
            }
        };
    }

    public static Action openAction(final Application app) {
        return new AbstractAction(OPEN){

            public void actionPerformed(ActionEvent e) {
                Document doc = app.getStoragePolicy().open(app);
                if (doc != null) {
                    app.addDocument(doc);
                    View v = app.createView(doc);
                    app.addView(v);
                    app.setCurrentView(v);
                }
            }
        };
    }

    public static Action printAction(final Application app) {
        return new AbstractAction(PRINT){

            public void actionPerformed(ActionEvent e) {
                View view = app.getCurrentView();
                if (view != null && view instanceof Printable) {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    PageFormat format = job.pageDialog(job.defaultPage());
                    job.setPrintable((Printable)((Object)view), format);
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (Exception ex) {
                            app.showError("PrintingFailed", ex);
                        }
                    }
                } else if (view != null && view instanceof Pageable) {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.pageDialog(job.defaultPage());
                    job.setPageable((Pageable)((Object)view));
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (Exception ex) {
                            app.showError("PrintingFailed", ex);
                        }
                    }
                }
            }
        };
    }

    public static Action pasteAction(final Application app) {
        return new AbstractAction(PASTE){

            public void actionPerformed(ActionEvent e) {
                View view = app.getCurrentView();
                Clipboard c = app.getClipboard();
                if (view != null && c != null) {
                    view.paste(c);
                }
            }
        };
    }

    public static Action quitAction(Application app) {
        return DefaultActions.exitAction(app);
    }

    public static Action saveAction(final Application app) {
        return new AbstractAction(SAVE){

            public void actionPerformed(ActionEvent e) {
                app.getStoragePolicy().save(app.getCurrentView().getDocument());
            }
        };
    }

    public static Action saveAsAction(final Application app) {
        return new AbstractAction(SAVE_AS){

            public void actionPerformed(ActionEvent e) {
                app.getStoragePolicy().saveAs(app.getCurrentView().getDocument());
            }
        };
    }
}

