/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.GraphModel;
import diva.graph.layout.AbstractGlobalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class GridAnnealingLayout
extends AbstractGlobalLayout {
    private static final double HEIGHT_FACTOR = 1.0;
    private static final double WIDTH_FACTOR = 1.0;
    private static final double ELBOW_PENALTY = 10.0;
    private static final double EDGE_OVERLAP_PENALTY = 30.0;
    private static final double TEE_PENALTY = 30.0;
    private static final double CROSSING_PENALTY = 10.0;
    protected Random _random = new Random(System.currentTimeMillis());
    protected Object _graph;
    protected int _gw;
    protected int _gh;
    protected Object[][] _grid;
    protected Object[][] _minGrid;
    protected double _minCost;
    protected HashMap _map;
    protected double _sparseness = 1.0;
    protected int _numIters = 5;
    protected int _numMoves = 10;
    protected double _cool = 0.95;

    public GridAnnealingLayout(LayoutTarget target) {
        super(target);
    }

    private void anneal() {
        this._minCost = 0.0;
        double curCost = 0.0;
        double prob = 1.0;
        this.snapMin();
        int i = 0;
        while (i < this._numIters) {
            int j = 0;
            while (j < this._numMoves) {
                int y2;
                int x2;
                Object node2;
                int y1;
                prob *= this._cool;
                int x1 = (int)(this._random.nextDouble() * (double)this._gw);
                Object node1 = this._grid[x1][y1 = (int)(this._random.nextDouble() * (double)this._gh)];
                if (node1 != (node2 = this._grid[x2 = (int)(this._random.nextDouble() * (double)this._gw)][y2 = (int)(this._random.nextDouble() * (double)this._gh)])) {
                    double startCost = this.nodeCost(node1) + this.nodeCost(node2);
                    if (node1 == null) {
                        this.setXY(node2, x1, y1);
                    } else if (node2 == null) {
                        this.setXY(node1, x2, y2);
                    } else {
                        this.swap(node1, node2);
                    }
                    double endCost = this.nodeCost(node1) + this.nodeCost(node2);
                    double deltaCost = endCost - startCost;
                    curCost += deltaCost;
                    if (curCost < this._minCost) {
                        this._minCost = curCost;
                        this.snapMin();
                    }
                    if (deltaCost > 0.0 && this._random.nextDouble() > prob) {
                        curCost -= deltaCost;
                        if (node1 == null) {
                            this.setXY(node2, x2, y2);
                        } else if (node2 == null) {
                            this.setXY(node1, x1, y1);
                        } else {
                            this.swap(node1, node2);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private final void ASSERT(boolean b, String err) throws RuntimeException {
        if (!b) {
            throw new RuntimeException(err);
        }
    }

    private void assignLayout() {
        Rectangle2D dim = this.getLayoutTarget().getViewport(this._graph);
        double[] placeX = new double[this._gw];
        int x = 0;
        while (x < this._gw) {
            placeX[x] = (0.5 + (double)x) * dim.getWidth() / (double)this._gw + dim.getX();
            ++x;
        }
        double[] placeY = new double[this._gh];
        int y = 0;
        while (y < this._gh) {
            placeY[y] = (0.5 + (double)y) * dim.getHeight() / (double)this._gh + dim.getY();
            ++y;
        }
        int i = 0;
        while (i < this._gw) {
            int j = 0;
            while (j < this._gh) {
                this.ASSERT(this._minGrid != null, "Null min grid!");
                Object node = this._minGrid[i][j];
                if (node != null) {
                    double x2 = placeX[i];
                    double y2 = placeY[j];
                    LayoutUtilities.placeNoReroute(this.getLayoutTarget(), node, x2, y2);
                }
                ++j;
            }
            ++i;
        }
        LayoutUtilities.routeVisibleEdges(this._graph, this.getLayoutTarget());
    }

    private void cleanupStructures() {
        this._map = null;
        this._grid = null;
        this._minGrid = null;
        this._minCost = Double.MAX_VALUE;
        this._gw = -1;
        this._gh = -1;
    }

    protected double edgeCost(Object edge) {
        GraphModel model = this.getLayoutTarget().getGraphModel();
        Object tail = model.getTail(edge);
        Object head = model.getHead(edge);
        head = this._getParentInGraph(head);
        tail = this._getParentInGraph(tail);
        if (head == null || tail == null) {
            return 0.0;
        }
        int[] ptail = this.getXY(tail);
        int[] phead = this.getXY(head);
        double heightCost = 1.0 * (double)Math.abs(phead[1] - ptail[1]);
        double widthCost = 1.0 * (double)Math.abs(phead[0] - ptail[0]);
        double elbowCost = heightCost == 0.0 || widthCost == 0.0 ? 0.0 : 10.0;
        double overlapCost = (double)this.numOverlaps(edge, this._graph) * 30.0;
        double crossingCost = (double)this.numCrossings(edge, this._graph) * 10.0;
        return heightCost + widthCost + elbowCost + overlapCost + crossingCost;
    }

    public double getCoolingFactor() {
        return this._cool;
    }

    public int getIterationCount(int cnt) {
        return this._numIters;
    }

    public int getMoveCount(int cnt) {
        return this._numIters;
    }

    public double getSparseness() {
        return this._sparseness;
    }

    protected int[] getXY(Object node) {
        return (int[])this._map.get(node);
    }

    protected void initGrid() {
        GraphModel model = this.getLayoutTarget().getGraphModel();
        int nodeCount = model.getNodeCount(this._graph);
        if (nodeCount > 0) {
            Rectangle2D dim = this.getLayoutTarget().getViewport(this._graph);
            double aspect = dim.getHeight() / dim.getWidth();
            double gh = Math.sqrt((double)nodeCount * aspect) * this._sparseness;
            this._gh = (int)Math.ceil(gh);
            this._gw = nodeCount / this._gh;
            while (this._gh * this._gw < nodeCount) {
                ++this._gw;
            }
            this._grid = new Object[this._gw][this._gh];
            Iterator nodes = model.nodes(this._graph);
            int x = 0;
            while (x < this._gw) {
                int y = 0;
                while (y < this._gh) {
                    if (!nodes.hasNext()) break;
                    this.setXY(nodes.next(), x, y);
                    ++y;
                }
                ++x;
            }
        }
    }

    public void layout(Object composite) {
        LayoutTarget target = this.getLayoutTarget();
        this._graph = composite;
        this._map = new HashMap();
        if (target.getGraphModel().getNodeCount(this._graph) > 0) {
            this.initGrid();
            if (this._gh == 0 || this._gw == 0) {
                return;
            }
            this.anneal();
            this.assignLayout();
            this.cleanupStructures();
        }
    }

    protected double nodeCost(Object node) {
        LayoutTarget target = this.getLayoutTarget();
        GraphModel model = target.getGraphModel();
        if (node == null) {
            return 0.0;
        }
        int cost = 0;
        Iterator i = model.inEdges(node);
        while (i.hasNext()) {
            cost = (int)((double)cost + this.edgeCost(i.next()));
        }
        i = model.outEdges(node);
        while (i.hasNext()) {
            cost = (int)((double)cost + this.edgeCost(i.next()));
        }
        double teeCost = (double)this.numTees(this._graph) * 30.0;
        cost = (int)((double)cost + teeCost);
        return cost;
    }

    protected final int numCrossings(Object inEdge, Object composite) {
        int num = 0;
        GraphModel model = this.getLayoutTarget().getGraphModel();
        Object inTail = model.getTail(inEdge);
        Object inHead = model.getHead(inEdge);
        inHead = this._getParentInGraph(inHead);
        inTail = this._getParentInGraph(inTail);
        if (inHead == null || inTail == null) {
            return 0;
        }
        int[] inTailPt = this.getXY(inTail);
        int[] inHeadPt = this.getXY(inHead);
        Iterator i = model.nodes(composite);
        while (i.hasNext()) {
            Object node = i.next();
            Iterator j = model.outEdges(node);
            while (j.hasNext()) {
                int[] headPt;
                int[] tailPt;
                Object edge = j.next();
                Object tail = model.getTail(edge);
                Object head = model.getHead(edge);
                if (tail == null || head == null || tail == inTail || tail == inHead || head == inTail || head == inHead || !Line2D.linesIntersect(inTailPt[0], inTailPt[1], inHeadPt[0], inHeadPt[1], (tailPt = this.getXY(tail))[0], tailPt[1], (headPt = this.getXY(head))[0], headPt[1])) continue;
                ++num;
            }
        }
        return num;
    }

    protected final int numTees(Object composite) {
        return 0;
    }

    protected final int numOverlaps(Object inEdge, Object composite) {
        int num = 0;
        GraphModel model = this.getLayoutTarget().getGraphModel();
        Object inTail = model.getTail(inEdge);
        Object inHead = model.getHead(inEdge);
        inHead = this._getParentInGraph(inHead);
        inTail = this._getParentInGraph(inTail);
        if (inHead == null || inTail == null) {
            return 0;
        }
        int[] inTailPt = this.getXY(inTail);
        int[] inHeadPt = this.getXY(inHead);
        int which = 0;
        while (which < 2) {
            if (inTailPt[which] == inHeadPt[which]) {
                Iterator i = model.nodes(composite);
                while (i.hasNext()) {
                    Object node = i.next();
                    Iterator j = model.outEdges(node);
                    while (j.hasNext()) {
                        int[] headPt;
                        int[] tailPt;
                        Object edge = j.next();
                        Object tail = model.getTail(edge);
                        Object head = model.getHead(edge);
                        head = this._getParentInGraph(head);
                        tail = this._getParentInGraph(tail);
                        if (head == null || tail == null || (tailPt = this.getXY(tail))[which] != (headPt = this.getXY(head))[which] || tailPt[which] != inTailPt[which]) continue;
                        ++num;
                    }
                }
                break;
            }
            ++which;
        }
        return num;
    }

    public void setCoolingFactor(double val) {
        if (val <= 0.0 || val > 1.0) {
            String err = "Cooling factor must be greater than 0 and less or equal to 1: " + val;
            throw new IllegalArgumentException(err);
        }
        this._cool = val;
    }

    public void setIterationCount(int cnt) {
        this._numIters = cnt;
    }

    public void setMoveCount(int cnt) {
        this._numIters = cnt;
    }

    public void setSparseness(double val) {
        if (val < 1.0) {
            String err = "Illegal sparseness value: " + val;
            throw new IllegalArgumentException(err);
        }
        this._sparseness = val;
    }

    protected void setXY(Object node, int x, int y) {
        int[] pos = (int[])this._map.get(node);
        if (pos == null) {
            pos = new int[2];
            this._map.put(node, pos);
        }
        this._grid[x][y] = node;
        pos[0] = x;
        pos[1] = y;
    }

    private void snapMin() {
        if (this._minGrid == null) {
            this._minGrid = new Object[this._gw][this._gh];
        }
        int x = 0;
        while (x < this._gw) {
            int y = 0;
            while (y < this._gh) {
                this._minGrid[x][y] = this._grid[x][y];
                ++y;
            }
            ++x;
        }
    }

    private void swap(Object node1, Object node2) {
        int[] xy1 = this.getXY(node1);
        int[] xy2 = this.getXY(node2);
        int xtmp = xy1[0];
        int ytmp = xy1[1];
        this.setXY(node1, xy2[0], xy2[1]);
        this.setXY(node2, xtmp, ytmp);
    }

    private Object _getParentInGraph(Object node) {
        GraphModel model = this.getLayoutTarget().getGraphModel();
        while (node != null && !model.containsNode(this._graph, node)) {
            Object parent = model.getParent(node);
            node = model.isNode(parent) ? parent : null;
        }
        return node;
    }
}

