/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import diva.util.java2d.Polygon2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PerimeterSite
extends AbstractSite {
    private int _id;
    private Figure _parentFigure;

    public PerimeterSite(Figure figure, int id) {
        this._parentFigure = figure;
        this._id = id;
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public int getID() {
        return this._id;
    }

    public Point2D getPoint(double normal) {
        Shape shape = this._parentFigure.getShape();
        Rectangle2D bounds = shape.getBounds2D();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double pi2 = 1.5707963267948966;
        double alpha = normal;
        double beta = pi2 - alpha;
        if (shape instanceof Ellipse2D) {
            double dy;
            double dx;
            double rx = width / 2.0;
            double ry = height / 2.0;
            if (Math.abs(width - height) < 0.001) {
                dx = rx * Math.cos(alpha);
                dy = ry * Math.sin(alpha);
            } else if (Math.abs(alpha - pi2) < 0.001) {
                dx = 0.0;
                dy = ry;
            } else if (Math.abs(alpha + pi2) < 0.001) {
                dx = 0.0;
                dy = -ry;
            } else {
                double m = Math.tan(alpha);
                dx = rx * ry / Math.sqrt(ry * ry + rx * rx * m * m);
                if (alpha > pi2 || alpha < -pi2) {
                    dx = -dx;
                }
                dy = m * dx;
            }
            xout = x + rx + dx;
            yout = y + ry + dy;
        } else if (shape instanceof Polygon2D) {
            Polygon2D polygon = (Polygon2D)shape;
            double pointx = xCenter;
            double pointy = yCenter;
            double max_r = 0.0;
            int vertexes = polygon.getVertexCount();
            if (vertexes > 1) {
                double px = xCenter + Math.cos(alpha);
                double py = yCenter + Math.sin(alpha);
                double x1 = polygon.getX(vertexes - 1);
                double y1 = polygon.getY(vertexes - 1);
                int vertexPair = 0;
                while (vertexPair < vertexes) {
                    double x0 = x1;
                    double y0 = y1;
                    x1 = polygon.getX(vertexPair);
                    double A = (x0 - xCenter) * (py - yCenter) - (y0 - yCenter) * (px - xCenter);
                    y1 = polygon.getY(vertexPair);
                    double B = (y1 - y0) * (px - xCenter) - (x1 - x0) * (py - yCenter);
                    double t = A / B;
                    if (0.0 <= t && t <= 1.0) {
                        double r;
                        boolean yGood;
                        double tx = x0 + (x1 - x0) * t;
                        double ty = y0 + (y1 - y0) * t;
                        boolean xGood = tx >= xCenter && px >= xCenter || tx < xCenter && px < xCenter;
                        boolean bl = yGood = ty >= yCenter && py >= yCenter || ty < yCenter && py < yCenter;
                        if (xGood && yGood && (r = (tx - xCenter) * (tx - xCenter) + (ty - yCenter) * (ty - yCenter)) > max_r) {
                            pointx = tx;
                            pointy = ty;
                            max_r = r;
                        }
                    }
                    ++vertexPair;
                }
                xout = pointx;
                yout = pointy;
            } else {
                xout = x;
                yout = y;
            }
        } else {
            double t = Math.atan2(height, width);
            if (alpha < -pi + t || alpha > pi - t) {
                xout = x;
                yout = y + height / 2.0 - width / 2.0 * Math.tan(alpha);
            } else if (alpha < -t) {
                yout = y;
                xout = x + width / 2.0 - height / 2.0 * Math.tan(beta);
            } else if (alpha < t) {
                xout = x + width;
                yout = y + height / 2.0 + width / 2.0 * Math.tan(alpha);
            } else {
                yout = y + height;
                xout = x + width / 2.0 + height / 2.0 * Math.tan(beta);
            }
        }
        return new Point2D.Double(xout, yout);
    }

    public double getX() {
        return this.getPoint().getX();
    }

    public double getY() {
        return this.getPoint().getY();
    }
}

