/*
 * Decompiled with CFR 0.152.
 */
package gda.doe;

import gda.doe.TestBean;
import gda.doe.TestContainer;
import gda.doe.TestContainerContainer;
import gda.doe.TestContainerList;
import gda.doe.TestList;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.doe.RangeInfo;

public class DOEInfoTest {
    @Test
    public void testNested1() throws Throwable {
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        TestContainer testContainer = new TestContainer();
        testContainer.setTestBean(testBean);
        List<RangeInfo> list = DOEUtils.getInfo(testContainer);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
        System.out.println(RangeInfo.format(list));
    }

    @Test
    public void testNested2() throws Throwable {
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        TestContainer testContainer = new TestContainer();
        testContainer.setTestBean(testBean);
        TestContainerContainer testContainerContainer = new TestContainerContainer();
        testContainerContainer.setTestContainer(testContainer);
        List<RangeInfo> list = DOEUtils.getInfo(testContainerContainer);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList1() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<RangeInfo> list = DOEUtils.getInfo(testList);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList2() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0");
        testBean.setJ("4.0");
        testBean.setK("4.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<RangeInfo> list = DOEUtils.getInfo(testList);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList3() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0;4.5;1.0");
        testBean.setJ("4.0;4.5;1.0");
        testBean.setK("4.0;4.5;1.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<RangeInfo> list = DOEUtils.getInfo(testList);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList4() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0;5;1.0");
        testBean.setJ("4.0;5;1.0");
        testBean.setK("4.0;5;1.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<RangeInfo> list = DOEUtils.getInfo(testList);
        if (list.size() != 216) {
            throw new Exception("Three parameters, each with three values should give 216 experiments!");
        }
    }

    @Test
    public void testNestedList5() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0");
        testBean.setJ("4.0");
        testBean.setK("4.0");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("5.0");
        testBean.setJ("5.0");
        testBean.setK("5.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<RangeInfo> list = DOEUtils.getInfo(testList);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedListContainer() throws Throwable {
        ArrayList<TestContainer> arrayList = new ArrayList<TestContainer>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        TestContainer testContainer = new TestContainer();
        testContainer.setTestBean(testBean);
        arrayList.add(testContainer);
        TestContainerList testContainerList = new TestContainerList();
        testContainerList.setTestContainers(arrayList);
        List<RangeInfo> list = DOEUtils.getInfo(testContainerList);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }
}

