/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.utils;

import gda.analysis.io.ScanFileHolderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.RawBinaryLoader;

public class ImageThumbnailLoader {
    private static final Logger logger = LoggerFactory.getLogger(ImageThumbnailLoader.class);
    private static final int DOWNSAMPLE_SIZE_IN_PIXELS = 96;

    public static AbstractDataset loadImage(String string, boolean bl) {
        DataHolder dataHolder = null;
        if (!string.toLowerCase().endsWith(".raw")) {
            try {
                dataHolder = LoaderFactory.getData(string, null);
            }
            catch (Exception exception) {
                logger.error("Cannot load " + string, (Throwable)exception);
            }
        } else {
            RawBinaryLoader rawBinaryLoader = new RawBinaryLoader(string);
            try {
                dataHolder = rawBinaryLoader.loadFile();
            }
            catch (ScanFileHolderException scanFileHolderException) {
                logger.error("Cannot load " + string, (Throwable)scanFileHolderException);
            }
        }
        return ImageThumbnailLoader.getSingle(string, bl, dataHolder);
    }

    public static AbstractDataset getSingle(String string, boolean bl, DataHolder dataHolder) {
        if (dataHolder != null && dataHolder.size() > 0) {
            AbstractDataset abstractDataset = dataHolder.getDataset(0);
            int n = abstractDataset.getShape()[1];
            int n2 = abstractDataset.getShape()[0];
            if (abstractDataset.getName() == null || abstractDataset.getName().length() == 0) {
                int n3 = Math.max(0, string.lastIndexOf(System.getProperty("file.separator")));
                abstractDataset.setName(string.substring(n3));
            }
            if (bl) {
                int[] nArray = new int[2];
                nArray[1] = Math.max(1, n / 96);
                nArray[0] = Math.max(1, n2 / 96);
                Downsample downsample = new Downsample(DownsampleMode.POINT, nArray);
                AbstractDataset abstractDataset2 = downsample.value(abstractDataset).get(0);
                abstractDataset2.setName(new String(string));
                return abstractDataset2;
            }
            return abstractDataset;
        }
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{96, 96}, 0);
        abstractDataset.setName("Invalid Image");
        return abstractDataset;
    }
}

