/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;
import uk.ac.diamond.scisoft.analysis.dataset.function.Integrate2D;
import uk.ac.diamond.scisoft.analysis.dataset.function.LineSample;
import uk.ac.diamond.scisoft.analysis.dataset.function.MapToPolarAndIntegrate;
import uk.ac.diamond.scisoft.analysis.dataset.function.MapToRotatedCartesianAndIntegrate;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;

public class ROIProfileIDataset {
    public static AbstractDataset[] line(IDataset iDataset, LinearROI linearROI, double d) {
        int[] nArray = linearROI.getIntPoint();
        int[] nArray2 = linearROI.getIntEndPoint();
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
        LineSample lineSample = new LineSample(nArray[0], nArray[1], nArray2[0], nArray2[1], d);
        List<AbstractDataset> list = lineSample.value(iDataset);
        if (list == null) {
            return null;
        }
        abstractDatasetArray[0] = list.get(0);
        if (linearROI.isCrossHair()) {
            nArray = linearROI.getPerpendicularBisectorIntPoint(0.0);
            nArray2 = linearROI.getPerpendicularBisectorIntPoint(1.0);
            LineSample lineSample2 = new LineSample(nArray[0], nArray[1], nArray2[0], nArray2[1], d);
            list = lineSample2.value(iDataset);
            if (list != null) {
                abstractDatasetArray[1] = list.get(0);
            }
        }
        return abstractDatasetArray;
    }

    private static void clippingCompensate(IDataset iDataset, IDataset iDataset2, AbstractDataset[] abstractDatasetArray, DatasetToDatasetFunction datasetToDatasetFunction) {
        if (iDataset2 == null) {
            iDataset2 = AbstractDataset.ones(iDataset.getShape(), 0);
        }
        List<AbstractDataset> list = datasetToDatasetFunction.value(iDataset2);
        AbstractDataset abstractDataset = list.get(1);
        AbstractDataset abstractDataset2 = list.get(0);
        abstractDataset = Maths.dividez(abstractDataset, list.get(3));
        abstractDataset2 = Maths.dividez(abstractDataset2, list.get(2));
        abstractDatasetArray[0] = Maths.dividez(abstractDatasetArray[0], abstractDataset);
        abstractDatasetArray[1] = Maths.dividez(abstractDatasetArray[1], abstractDataset2);
    }

    public static AbstractDataset[] box(IDataset iDataset, RectangularROI rectangularROI) {
        return ROIProfileIDataset.box(iDataset, null, rectangularROI);
    }

    public static AbstractDataset[] box(IDataset iDataset, IDataset iDataset2, RectangularROI rectangularROI) {
        int[] nArray = rectangularROI.getIntPoint();
        int[] nArray2 = rectangularROI.getIntLengths();
        double d = rectangularROI.getAngle();
        boolean bl = rectangularROI.isClippingCompensation();
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
        if (iDataset2 != null) {
            AbstractDataset.checkCompatibility(iDataset, iDataset2);
        }
        if (nArray2[0] == 0) {
            nArray2[0] = 1;
        }
        if (nArray2[1] == 0) {
            nArray2[1] = 1;
        }
        if (d == 0.0) {
            Integrate2D integrate2D = new Integrate2D(nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
            List<AbstractDataset> list = integrate2D.value(iDataset);
            if (list == null) {
                return null;
            }
            abstractDatasetArray[0] = list.get(1);
            abstractDatasetArray[1] = list.get(0);
        } else {
            MapToRotatedCartesianAndIntegrate mapToRotatedCartesianAndIntegrate = new MapToRotatedCartesianAndIntegrate(nArray[0], nArray[1], nArray2[0], nArray2[1], d, false);
            List<AbstractDataset> list = mapToRotatedCartesianAndIntegrate.value(iDataset);
            if (list == null) {
                return null;
            }
            abstractDatasetArray[0] = list.get(1);
            abstractDatasetArray[1] = list.get(0);
            if (bl) {
                ROIProfileIDataset.clippingCompensate(iDataset, iDataset2, abstractDatasetArray, mapToRotatedCartesianAndIntegrate);
            }
        }
        return abstractDatasetArray;
    }

    public static AbstractDataset[] sector(IDataset iDataset, SectorROI sectorROI) {
        return ROIProfileIDataset.sector(iDataset, null, sectorROI);
    }

    public static AbstractDataset[] sector(IDataset iDataset, IDataset iDataset2, SectorROI sectorROI) {
        double[] dArray = sectorROI.getPoint();
        double[] dArray2 = sectorROI.getRadii();
        double[] dArray3 = sectorROI.getAngles();
        boolean bl = sectorROI.isClippingCompensation();
        int n = sectorROI.getSymmetry();
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[4];
        if (Math.abs(dArray2[0] - dArray2[1]) < 1.0 || Math.abs(dArray3[0] - dArray3[1]) < 0.01) {
            return null;
        }
        if (iDataset2 != null) {
            AbstractDataset.checkCompatibility(iDataset, iDataset2);
        }
        if (n == 1) {
            MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(dArray[0], dArray[1], dArray2[0], dArray3[0], dArray2[1], dArray3[0] + Math.PI * 2, false);
            List<AbstractDataset> list = mapToPolarAndIntegrate.value(iDataset);
            if (list == null) {
                return null;
            }
            abstractDatasetArray[0] = list.get(1);
            abstractDatasetArray[1] = list.get(0);
            if (bl) {
                ROIProfileIDataset.clippingCompensate(iDataset, iDataset2, abstractDatasetArray, mapToPolarAndIntegrate);
            }
            return abstractDatasetArray;
        }
        MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(dArray[0], dArray[1], dArray2[0], dArray3[0], dArray2[1], dArray3[1], false);
        List<AbstractDataset> list = mapToPolarAndIntegrate.value(iDataset);
        if (list == null) {
            return null;
        }
        abstractDatasetArray[0] = list.get(1);
        abstractDatasetArray[1] = list.get(0);
        if (bl) {
            ROIProfileIDataset.clippingCompensate(iDataset, iDataset2, abstractDatasetArray, mapToPolarAndIntegrate);
        }
        if (n != 0) {
            double[] dArray4 = sectorROI.getSymmetryAngles();
            AbstractDataset[] abstractDatasetArray2 = new AbstractDataset[2];
            MapToPolarAndIntegrate mapToPolarAndIntegrate2 = new MapToPolarAndIntegrate(dArray[0], dArray[1], dArray2[0], dArray4[0], dArray2[1], dArray4[1], false);
            List<AbstractDataset> list2 = mapToPolarAndIntegrate2.value(iDataset);
            if (list2 != null) {
                abstractDatasetArray2[0] = list2.get(1);
                abstractDatasetArray2[1] = list2.get(0);
                if (bl) {
                    ROIProfileIDataset.clippingCompensate(iDataset, iDataset2, abstractDatasetArray2, mapToPolarAndIntegrate2);
                }
                if (sectorROI.isCombineSymmetry()) {
                    abstractDatasetArray[0] = Maths.add(abstractDatasetArray[0], abstractDatasetArray2[0]);
                    abstractDatasetArray[1] = Maths.add(abstractDatasetArray[1], abstractDatasetArray2[1]);
                } else {
                    abstractDatasetArray[2] = abstractDatasetArray2[0];
                    abstractDatasetArray[3] = abstractDatasetArray2[1];
                }
            }
        }
        return abstractDatasetArray;
    }
}

