/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.Utils;

public class UtilsTest {
    static int answer = -559038737;
    static int sLeAnswer = 48879;
    static int sBeAnswer = 57005;
    static byte[] leAnswer = new byte[]{-17, -66, -83, -34};
    static byte[] beAnswer = new byte[]{-34, -83, -66, -17};

    @Test
    public void testLeInt() {
        int n = Utils.leInt(239, 190, 173, 222);
        Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testBeInt() {
        int n = Utils.beInt(222, 173, 190, 239);
        Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
    }

    @Test
    public void testReadLeInt() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(leAnswer);
        try {
            int n = Utils.readLeInt(byteArrayInputStream);
            Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Test
    public void testReadBeInt() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(beAnswer);
        try {
            int n = Utils.readBeInt(byteArrayInputStream);
            Assert.assertEquals((double)answer, (double)n, (double)1.0E-8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Test
    public void testReadLeShort() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(leAnswer);
        try {
            int n = Utils.readLeShort(byteArrayInputStream);
            Assert.assertEquals((double)sLeAnswer, (double)n, (double)1.0E-8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Test
    public void testReadBeShort() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(beAnswer);
        try {
            int n = Utils.readBeShort(byteArrayInputStream);
            Assert.assertEquals((double)sBeAnswer, (double)n, (double)1.0E-8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Test
    public void testWriteLeInt() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Utils.writeLeInt(byteArrayOutputStream, answer);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Assert.assertArrayEquals((byte[])leAnswer, (byte[])byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Test
    public void testWriteBeInt() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Utils.writeBeInt(byteArrayOutputStream, answer);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Assert.assertArrayEquals((byte[])beAnswer, (byte[])byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

