/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;

public class SRSLoaderTest {
    @Test
    public void testSS49() {
        try {
            String string = "testfiles/gda/analysis/io/SRSLoaderTest/96356.dat";
            DataHolder dataHolder = new SRSLoader(string).loadFile();
            Assert.assertEquals((String)"There is not the correct number of axis in the file", (long)7L, (long)dataHolder.size());
            Assert.assertEquals((String)"The file does not contain NANs", (double)Double.NaN, (double)dataHolder.getDataset(1).getDouble(0), (double)10.0);
            Assert.assertEquals((String)"The file does not contain data as well", (double)0.1, (double)dataHolder.getDataset(0).getDouble(1), (double)1.0);
        }
        catch (ScanFileHolderException scanFileHolderException) {
            Assert.fail((String)"Couldn't load the file");
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData("testfiles/gda/analysis/io/SRSLoaderTest/96356.dat", null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        Assert.assertEquals((String)"There is not the correct number of axis in the file", (long)7L, (long)dataHolder.size());
        Assert.assertEquals((String)"The file does not contain NANs", (double)Double.NaN, (double)dataHolder.getDataSet(1).getDouble(0), (double)10.0);
        Assert.assertEquals((String)"The file does not contain data as well", (double)0.1, (double)dataHolder.getDataSet(0).getDouble(1), (double)1.0);
    }
}

