/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileLoader;
import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.gda.monitor.IMonitor;

public class SRSLoader
extends AbstractFileLoader
implements IFileLoader,
IFileSaver,
IMetaLoader {
    protected static final transient Logger logger = LoggerFactory.getLogger(SRSLoader.class);
    protected String fileName;
    protected List<String> dataNames = new ArrayList<String>();
    protected Map<String, String> textMetadata = new HashMap<String, String>();
    protected List<String> extraHeaders = new ArrayList<String>();

    public SRSLoader() {
    }

    public SRSLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        BufferedReader bufferedReader = null;
        try {
            try {
                String string;
                String string2;
                bufferedReader = new BufferedReader(new FileReader(this.fileName));
                int n = 0;
                try {
                    while (!(string2 = bufferedReader.readLine()).contains("&END")) {
                    }
                    string2 = bufferedReader.readLine();
                    while ((string = bufferedReader.readLine()) != null) {
                        ++n;
                    }
                }
                finally {
                    bufferedReader.close();
                }
                bufferedReader = new BufferedReader(new FileReader(this.fileName));
                this.readMetadata(bufferedReader, iMonitor);
                if (this.textMetadata.size() > 0) {
                    dataHolder.addMetadata(this.textMetadata);
                }
                string2 = bufferedReader.readLine();
                String[] stringArray = string2.split("\t");
                this.dataNames.clear();
                this.dataNames.addAll(Arrays.asList(stringArray));
                int n2 = 0;
                while (n2 < stringArray.length) {
                    DoubleDataset doubleDataset = new DoubleDataset(n);
                    doubleDataset.setName(stringArray[n2]);
                    dataHolder.addDataset(stringArray[n2], doubleDataset);
                    ++n2;
                }
                n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray2;
                    int n3;
                    if (iMonitor != null) {
                        iMonitor.worked(1);
                        if (iMonitor.isCancelled()) {
                            throw new ScanFileHolderException("Load cancelled!");
                        }
                    }
                    if ((n3 = (stringArray2 = string.split("\t")).length) > stringArray.length) {
                        logger.warn("Number of columns on data line {} exceeds number of headers - ignoring excess columns", (Object)n);
                        n3 = stringArray.length;
                    }
                    int n4 = 0;
                    while (n4 < n3) {
                        DoubleDataset doubleDataset = (DoubleDataset)dataHolder.getDataset(n4);
                        try {
                            doubleDataset.setAbs(Double.parseDouble(stringArray2[n4]), n);
                        }
                        catch (Exception exception) {
                            doubleDataset.setAbs(Double.NaN, n);
                        }
                        ++n4;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("SRSLoader.loadFile exception loading  " + this.fileName, exception);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Cannot read file", iOException);
            }
        }
        return dataHolder;
    }

    protected void readMetadata(BufferedReader bufferedReader, IMonitor iMonitor) throws ScanFileHolderException {
        this.textMetadata.clear();
        try {
            while (true) {
                String string;
                if (iMonitor != null) {
                    iMonitor.worked(1);
                    if (iMonitor.isCancelled()) {
                        throw new ScanFileHolderException("Load cancelled!");
                    }
                }
                if ((string = bufferedReader.readLine()).contains("&END")) {
                    return;
                }
                if (string.contains("MetaDataAtStart")) continue;
                if (string.contains("=")) {
                    String[] stringArray = string.split("=");
                    if (stringArray.length == 1) {
                        this.textMetadata.put(stringArray[0], "");
                        continue;
                    }
                    this.textMetadata.put(stringArray[0], stringArray[1].trim());
                    continue;
                }
                this.extraHeaders.add(string);
            }
        }
        catch (IOException iOException) {
            logger.error("Problem parsing header of SRS file {}", (Object)this.fileName);
            throw new ScanFileHolderException("There was a problem parsing header information", iOException);
        }
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.fileName));
            bufferedWriter.write("&SRS\n");
            if (dataHolder.getNexusTree() != null) {
                bufferedWriter.write(dataHolder.getNexusTree().toXML(true, true));
                bufferedWriter.write(dataHolder.getNexusTree().toText("", ":", "/", "|"));
            }
            this.writeMetadata(bufferedWriter);
            bufferedWriter.write("&END\n");
            int n = dataHolder.namesSize();
            int n2 = 0;
            while (n2 < n) {
                bufferedWriter.write(String.valueOf(dataHolder.getName(n2)) + "\t");
                ++n2;
            }
            bufferedWriter.write("\n");
            n2 = dataHolder.getDataset(0).getShape()[0];
            IDataset[] iDatasetArray = new IDataset[n];
            int n3 = 0;
            while (n3 < n) {
                iDatasetArray[n3] = dataHolder.getDataSet(n3);
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    bufferedWriter.write(String.valueOf(iDatasetArray[n4].getDouble(n3)) + "\t");
                    ++n4;
                }
                bufferedWriter.write("\n");
                ++n3;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            logger.error("Problem saving SRS file {}", (Object)this.fileName);
            throw new ScanFileHolderException("SRSLoader.saveFile exception saving to " + this.fileName, exception);
        }
    }

    protected void writeMetadata(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = this.getKeysToSave();
        if (!this.textMetadata.isEmpty() && stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                String string2 = this.textMetadata.get(string);
                if (string2 == null) {
                    if (this.textMetadata.containsKey(string)) {
                        logger.warn("Metadata item (key {}) was null", (Object)string);
                    } else {
                        logger.warn("Metadata key {} is not contained in list", (Object)string);
                    }
                } else {
                    bufferedWriter.write(String.valueOf(string) + "=" + string2.toString() + "\n");
                }
                ++n2;
            }
        }
        if (!this.extraHeaders.isEmpty()) {
            for (String string : this.extraHeaders) {
                bufferedWriter.write(String.valueOf(string) + "\n");
            }
        }
    }

    protected String[] getKeysToSave() {
        return null;
    }

    @Override
    public IMetaData getMetaData() {
        return new MetaDataAdapter(){

            @Override
            public Collection<String> getDataNames() {
                return SRSLoader.this.dataNames;
            }

            @Override
            public String getMetaValue(String string) {
                return SRSLoader.this.textMetadata.get(string);
            }
        };
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(this.fileName));
                this.readMetadata(bufferedReader, iMonitor);
                String string = bufferedReader.readLine();
                String[] stringArray = string.split("\t");
                this.dataNames.clear();
                this.dataNames.addAll(Arrays.asList(stringArray));
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("SRSLoader.loadFile exception loading  " + this.fileName, exception);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Cannot read file", iOException);
            }
        }
    }
}

