/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.JavaImageSaver;

public class JavaImageScaledSaver
extends JavaImageSaver {
    double gmin = Double.NaN;
    double gmax = Double.NaN;

    public JavaImageScaledSaver(String string, String string2, int n, boolean bl) {
        super(string, string2, n, bl);
    }

    public JavaImageScaledSaver(String string, String string2, int n, boolean bl, double d, double d2) {
        super(string, string2, n, bl);
        if (d >= d2) {
            throw new IllegalArgumentException("Minimum value supplied was not greater than maximum value");
        }
        this.gmin = d;
        this.gmax = d2;
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        DataHolder dataHolder2 = new DataHolder();
        int n = 0;
        int n2 = dataHolder.size();
        while (n < n2) {
            AbstractDataset abstractDataset = dataHolder.getDataset(n);
            if (Double.isNaN(this.gmin)) {
                double d;
                double d2 = abstractDataset.min().doubleValue();
                if (d2 == (d = abstractDataset.max().doubleValue())) {
                    abstractDataset = AbstractDataset.zeros(abstractDataset);
                } else if (this.unsigned && d2 >= -this.maxVal / 2.0) {
                    abstractDataset = Maths.multiply(abstractDataset, this.maxVal / d);
                    abstractDataset = Maths.clip(abstractDataset, 0, this.maxVal);
                } else {
                    abstractDataset = DatasetUtils.norm(abstractDataset);
                    abstractDataset.imultiply(this.maxVal);
                }
            } else {
                abstractDataset = Maths.clip(abstractDataset, this.gmin, this.gmax);
                abstractDataset.isubtract(this.gmin);
                abstractDataset.imultiply(this.maxVal / (this.gmax - this.gmin));
            }
            dataHolder2.addDataset(dataHolder.getName(n), abstractDataset);
            ++n;
        }
        super.saveFile(dataHolder2);
    }
}

