/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import uk.ac.diamond.scisoft.analysis.dataset.AWTImageUtils;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class JavaImageSaver
implements IFileSaver {
    private String fileName = "";
    private String fileType = "";
    protected double maxVal;
    protected boolean unsigned = false;
    private int numBits;

    public JavaImageSaver(String string, String string2, int n, boolean bl) {
        this.fileName = string;
        this.fileType = string2;
        this.numBits = n;
        this.maxVal = this.numBits <= 32 ? (double)(1L << n) - 1.0 : 1.0;
        this.unsigned = bl;
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        File file = null;
        if (this.numBits <= 0) {
            throw new ScanFileHolderException("Number of bits specified must be greater than 0");
        }
        int n = 0;
        int n2 = dataHolder.size();
        while (n < n2) {
            try {
                Object object;
                Object object2;
                Object object3;
                String string = null;
                if (n2 == 1) {
                    string = this.fileName;
                } else {
                    try {
                        string = this.fileName.substring(0, this.fileName.lastIndexOf("."));
                    }
                    catch (Exception exception) {
                        string = this.fileName;
                    }
                    object3 = new DecimalFormat("00000");
                    string = String.valueOf(string) + ((NumberFormat)object3).format(n + 1);
                }
                object3 = ImageIO.getReaderFileSuffixes();
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                if (string2 != this.fileName) {
                    Object object4 = object3;
                    int n3 = ((String[])object4).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        object2 = object4[n4];
                        if (!string2.equalsIgnoreCase((String)object2)) {
                            ++n4;
                            continue;
                        }
                        break;
                    }
                } else {
                    string = String.valueOf(string) + "." + this.fileType;
                }
                file = new File(string);
                object2 = dataHolder.getDataset(n);
                if (this.numBits <= 16) {
                    if (this.maxVal > 0.0 && ((AbstractDataset)object2).max().doubleValue() > this.maxVal) {
                        throw new ScanFileHolderException("The value of a pixel exceeds the maximum value that  " + this.fileType + "  is capable of handling. To save a  " + this.fileType + "  it is recommended to use a ScaledSaver class. File " + this.fileName + " not written");
                    }
                    if (!this.unsigned && ((AbstractDataset)object2).min().doubleValue() < 0.0) {
                        throw new ScanFileHolderException("The value of a pixel is less than 0. Recommended using a ScaledSaver class.");
                    }
                    object = AWTImageUtils.makeBufferedImage((AbstractDataset)object2, this.numBits);
                    if (object == null) {
                        throw new ScanFileHolderException("Unable to create a buffered image to save file type");
                    }
                    ImageIO.write((RenderedImage)object, this.fileType, file);
                } else {
                    object = AWTImageUtils.makeTiledImage((AbstractDataset)object2, this.numBits);
                    if (object == null) {
                        throw new ScanFileHolderException("Unable to create a tiled image to save file type");
                    }
                    ImageIO.write((RenderedImage)object, this.fileType, file);
                }
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.fileName + "'", exception);
            }
            ++n;
        }
    }
}

