/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import java.io.FileNotFoundException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.JPEGLoader;
import uk.ac.diamond.scisoft.analysis.io.JPEGSaver;
import uk.ac.diamond.scisoft.analysis.io.JPEGScaledSaver;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class JPEGTest {
    static String testScratchDirectoryName = null;
    AbstractDataset data;
    DataHolder dh = new DataHolder();
    DataHolder dhLoad = new DataHolder();
    int sizex = 500;
    int sizey = 500;
    int range = this.sizex * this.sizey;
    double abserr = 2.0;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)JPEGTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void testSaveFile() throws Exception {
        String string = "testSaveFile.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        Assert.assertEquals((long)this.data.getSize(), (long)abstractDataset.getSize());
        int n = 0;
        while (n < this.data.getSize()) {
            byte by = (byte)this.data.getElementLongAbs(n);
            byte by2 = (byte)abstractDataset.getElementLongAbs(n);
            if (by < 0 && by2 > 0) {
                by2 = (byte)(by2 - 255);
            }
            Assert.assertEquals((String)("" + n), (double)by, (double)by2, (double)this.abserr);
            ++n;
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        String string = "testLoaderFactory.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = LoaderFactory.getData(String.valueOf(testScratchDirectoryName) + string, null);
        if (dataHolder2 == null || dataHolder2.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void manyImages() throws ScanFileHolderException {
        String string = "manyImages.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + "ManyImages" + string).saveFile(dataHolder);
    }

    @Test
    public void manyImagesScaled() throws ScanFileHolderException {
        String string = "manyImagesScaled.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 3);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "ManyImagesScaled" + string).saveFile(dataHolder);
    }

    @Test
    public void compareDataset() throws ScanFileHolderException {
        String string = "compareDataset.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        int[] nArray = this.data.getShape();
        int n = nArray[0];
        int n2 = nArray[1];
        int[] nArray2 = abstractDataset.getShape();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        Assert.assertEquals((long)n, (long)n3);
        Assert.assertEquals((long)n2, (long)n4);
        int n5 = 0;
        while (n5 < n * n2) {
            byte by = (byte)this.data.getElementLongAbs(n5);
            byte by2 = (byte)abstractDataset.getElementLongAbs(n5);
            if (by < 0 && by2 > 0) {
                by2 = (byte)(by2 - 255);
            }
            Assert.assertEquals((String)("" + n5), (double)by, (double)by2, (double)this.abserr);
            ++n5;
        }
    }

    @Test
    public void compareScaledDataset() throws ScanFileHolderException {
        String string = "compareScaledDataset.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 5);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        AbstractDataset abstractDataset = DatasetUtils.norm(this.data);
        abstractDataset.imultiply(255);
        AbstractDataset abstractDataset2 = dataHolder2.getDataset(0);
        int[] nArray = abstractDataset.getShape();
        int n = nArray[0];
        int n2 = nArray[1];
        int[] nArray2 = abstractDataset2.getShape();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        Assert.assertEquals((long)n, (long)n3);
        Assert.assertEquals((long)n2, (long)n4);
        int n5 = 0;
        while (n5 < n * n2) {
            byte by = (byte)abstractDataset.getElementLongAbs(n5);
            byte by2 = (byte)abstractDataset2.getElementLongAbs(n5);
            if (by < 0 && by2 > 0) {
                by2 = (byte)(by2 - 255);
            }
            Assert.assertEquals((String)("" + n5), (double)by, (double)by2, (double)this.abserr);
            ++n5;
        }
    }

    @Test
    public void noEnding() throws Exception {
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 5);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding.jpg").saveFile(dataHolder);
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + "noEnding").loadFile();
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding1").saveFile(this.dh);
    }

    @Test
    public void incorrectEnding() throws Exception {
        String string = "incorrectEnding.txt";
        String string2 = "incorrectEnding1.txt";
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 1);
        this.data.setShape(this.sizex, this.sizey);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + string2).saveFile(dataHolder);
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string2).loadFile();
    }

    @Test
    public void testNoFile() throws ScanFileHolderException {
        block2: {
            try {
                this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + "NoFile.jpeg").loadFile();
            }
            catch (ScanFileHolderException scanFileHolderException) {
                if (scanFileHolderException.getCause() instanceof FileNotFoundException) break block2;
                throw scanFileHolderException;
            }
        }
    }
}

