/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IDataSetLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.gda.monitor.IMonitor;

public class DatLoader
extends AbstractFileLoader
implements IMetaLoader,
IDataSetLoader {
    protected static final transient Logger logger = LoggerFactory.getLogger(DatLoader.class);
    private static final transient String FLOAT = "[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?";
    private static final transient Pattern DATA = Pattern.compile("^(([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)\\s+)+([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)$");
    protected String fileName;
    protected List<String> header;
    protected Map<String, String> metaData;
    protected List<String> footer;
    protected Map<String, List<Double>> vals;
    protected int columnIndex;

    public DatLoader() {
    }

    public DatLoader(String string) {
        this.setFile(string);
    }

    public void setFile(String string) {
        this.fileName = string;
        this.header = new ArrayList<String>(31);
        this.metaData = new HashMap<String, String>(7);
        this.footer = new ArrayList<String>(7);
        this.vals = new LinkedHashMap<String, List<Double>>();
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = this.loadFile(null, iMonitor);
        return dataHolder;
    }

    private DataHolder loadFile(String string, IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        BufferedReader bufferedReader = null;
        try {
            Object object;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), "UTF-8"));
            boolean bl = false;
            String string2 = this.parseHeaders(bufferedReader, string, iMonitor);
            while (string2 != null) {
                if (iMonitor != null) {
                    iMonitor.worked(1);
                }
                if (iMonitor != null && iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loader cancelled during reading!");
                }
                if (!bl && DATA.matcher(string2.trim()).matches()) {
                    Iterator<String> iterator;
                    if (string2.startsWith("#")) {
                        bl = true;
                        break;
                    }
                    if (this.vals.isEmpty()) {
                        throw new ScanFileHolderException("Cannot read header for data set names!");
                    }
                    String[] stringArray = string2.trim().split("\\s+");
                    if (this.columnIndex > -1 && string != null) {
                        iterator = stringArray[this.columnIndex];
                        this.vals.get(string).add(Double.parseDouble(((String)((Object)iterator)).trim()));
                    } else {
                        if (stringArray.length != this.vals.size()) {
                            throw new ScanFileHolderException("Data and header must be the same size!");
                        }
                        iterator = this.vals.keySet().iterator();
                        String[] stringArray2 = stringArray;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            object = stringArray2[n2];
                            this.vals.get(iterator.next()).add(Double.parseDouble(((String)object).trim()));
                            ++n2;
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
            this.footer.clear();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!bl) continue;
                if (string2.startsWith("#")) {
                    this.footer.add(string2);
                    continue;
                }
                throw new ScanFileHolderException("Every line in the footer must start with #");
            }
            for (String string3 : this.vals.keySet()) {
                object = AbstractDataset.createFromList(this.vals.get(string3));
                object.setName(string3);
                dataHolder.addDataset(string3, (IDataset)object);
            }
            DataHolder dataHolder2 = dataHolder;
            return dataHolder2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("DatLoader.loadFile exception loading  " + this.fileName, exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Cannot close stream from file  " + this.fileName, iOException);
            }
        }
    }

    @Override
    public IDataset loadSet(String string, String string2, IMonitor iMonitor) throws Exception {
        this.setFile(string);
        DataHolder dataHolder = this.loadFile(string2, iMonitor);
        return dataHolder.getDataset(string2);
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.fileName)));
        this.parseHeaders(bufferedReader, null, iMonitor);
    }

    @Override
    public IMetaData getMetaData() {
        return new MetaDataAdapter(){

            @Override
            public String getMetaValue(String string) {
                return DatLoader.this.metaData.get(string);
            }

            @Override
            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(DatLoader.this.vals.keySet());
            }
        };
    }

    private String parseHeaders(BufferedReader bufferedReader, String string, IMonitor iMonitor) throws Exception {
        String string2;
        block11: {
            String[] stringArray;
            String string3;
            block12: {
                int n;
                string2 = bufferedReader.readLine();
                this.metaData.clear();
                this.header.clear();
                this.vals.clear();
                while (string2.startsWith("#")) {
                    if (iMonitor != null) {
                        iMonitor.worked(1);
                    }
                    if (iMonitor != null && iMonitor.isCancelled()) {
                        throw new ScanFileHolderException("Loader cancelled during reading!");
                    }
                    this.header.add(string2);
                    if (string2.indexOf("=") > -1) {
                        this.metaData.put(string2.substring(0, string2.indexOf("=") - 1), string2.substring(0, string2.indexOf("=") + 1));
                    } else if (string2.indexOf(":") > -1) {
                        this.metaData.put(string2.substring(0, string2.indexOf(":") - 1), string2.substring(0, string2.indexOf(":") + 1));
                    }
                    string2 = bufferedReader.readLine();
                }
                string3 = this.header.get(this.header.size() - 1);
                stringArray = string2.trim().split("\\s+");
                if (string == null) break block12;
                this.columnIndex = -1;
                this.vals.put(string, new ArrayList(89));
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string3.substring(1).trim().split("\\s{2,}|\\,\\s+|\\t")));
                if (stringArray.length > arrayList.size()) {
                    n = arrayList.size();
                    while (n < stringArray.length) {
                        arrayList.add("Unknown" + n);
                        ++n;
                    }
                }
                n = 0;
                while (n < arrayList.size()) {
                    if (((String)arrayList.get(n)).equals(string)) {
                        this.columnIndex = n;
                        break block11;
                    }
                    ++n;
                }
                break block11;
            }
            this.createValues(this.vals, string3);
            if (stringArray.length <= this.vals.size()) break block11;
            int n = this.vals.size();
            while (n < stringArray.length) {
                this.vals.put("Unknown" + n, new ArrayList(89));
                ++n;
            }
        }
        return string2;
    }

    private void createValues(Map<String, List<Double>> map, String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = string.substring(1).trim().split("\\s{2,}|\\,\\s+|\\t");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            map.put(string2, new ArrayList(89));
            ++n2;
        }
    }
}

