/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import org.iucr.cbflib.cbfConstants;

public class CBFError {
    public static boolean errorChecker(int n) throws ScanFileHolderException {
        String string = "";
        if ((n & cbfConstants.CBF_FORMAT) != 0) {
            string = String.valueOf(string) + "cbfLib: The file format is invalid.\n";
        }
        if ((n & cbfConstants.CBF_ALLOC) != 0) {
            string = String.valueOf(string) + "cbfLib: Memory allocation failed.\n";
        }
        if ((n & cbfConstants.CBF_ARGUMENT) != 0) {
            string = String.valueOf(string) + "cbfLib: Invalid function argument.\n";
        }
        if ((n & cbfConstants.CBF_ASCII) != 0) {
            string = String.valueOf(string) + "cbfLib: The value is ACSII not binary\n";
        }
        if ((n & cbfConstants.CBF_BINARY) != 0) {
            string = String.valueOf(string) + "cbfLib: The value is binary not ASCII\n";
        }
        if ((n & cbfConstants.CBF_BITCOUNT) != 0) {
            string = String.valueOf(string) + "cbfLib: The expected number of bits does not match the actual number of written.\n";
        }
        if ((n & cbfConstants.CBF_ENDOFDATA) != 0) {
            string = String.valueOf(string) + "cbfLib: The end of file was reached before the end of the array.\n";
        }
        if ((n & cbfConstants.CBF_FILECLOSE) != 0) {
            string = String.valueOf(string) + "cbfLib: File close error.\n";
        }
        if ((n & cbfConstants.CBF_FILEOPEN) != 0) {
            string = String.valueOf(string) + "cbfLib: File open error.\n";
        }
        if ((n & cbfConstants.CBF_FILEREAD) != 0) {
            string = String.valueOf(string) + "cbfLib: File read error.\n";
        }
        if ((n & cbfConstants.CBF_FILESEEK) != 0) {
            string = String.valueOf(string) + "cbfLib: File seek error.\n";
        }
        if ((n & cbfConstants.CBF_FILETELL) != 0) {
            string = String.valueOf(string) + " cbfLib: File tell error.\n";
        }
        if ((n & cbfConstants.CBF_FILEWRITE) != 0) {
            string = String.valueOf(string) + "cbfLib: File write error.\n";
        }
        if ((n & cbfConstants.CBF_IDENTICAL) != 0) {
            string = String.valueOf(string) + "cbfLib: A data block with the new name already exists.\n";
        }
        if ((n & cbfConstants.CBF_OVERFLOW) != 0) {
            string = String.valueOf(string) + "cbfLib: The number cannot be fit into the destination argument.\n" + "The destination has been set to the nearest value.\n";
        }
        if ((n & cbfConstants.CBF_UNDEFINED) != 0) {
            string = String.valueOf(string) + "cbfLib: The requested number is not defined.\n";
        }
        if ((n & cbfConstants.CBF_NOTIMPLEMENTED) != 0) {
            string = String.valueOf(string) + "cbflib: The requested functionality has not been implemented.\n";
        }
        if ((n & cbfConstants.CBF_NOTFOUND) != 0) {
            string = String.valueOf(string) + "cbfLib: The data block, category, column or row does not exist.\n";
            return false;
        }
        if (n != 0) {
            throw new ScanFileHolderException(string);
        }
        return true;
    }
}

