/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

import gda.analysis.io.IFileLoader;
import gda.analysis.io.ScanFileHolderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.io.ADSCImageLoader;
import uk.ac.diamond.scisoft.analysis.io.CBFLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.MARLoader;
import uk.ac.diamond.scisoft.analysis.utils.ClassLoaderUtils;

public class DiffractionImage {
    private static Class<?>[] loaders = new Class[]{ADSCImageLoader.class, CBFLoader.class, MARLoader.class};

    public static AbstractDataset[] loadImages(String string) {
        DataHolder dataHolder = null;
        Class<?>[] classArray = loaders;
        int n = loaders.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            try {
                Constructor<?> constructor = ClassLoaderUtils.getSingleStringConstructor(clazz);
                IFileLoader iFileLoader = (IFileLoader)constructor.newInstance(string);
                dataHolder = iFileLoader.loadFile();
                break;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (ScanFileHolderException scanFileHolderException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            ++n2;
        }
        if (dataHolder == null) {
            return null;
        }
        int n3 = dataHolder.size();
        if (n3 < 1) {
            return null;
        }
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[n3];
        n = 0;
        while (n < n3) {
            abstractDatasetArray[n] = dataHolder.getDataset(n);
            ++n;
        }
        return abstractDatasetArray;
    }

    public static DetectorProperties createDetectorProperties(AbstractDataset abstractDataset) throws Exception {
        Map<String, ? extends Object> map = abstractDataset.getMetadataMap();
        try {
            double[] dArray = (double[])map.get("NXdetector:NXgeometery:NXtranslation");
            Vector3d vector3d = new Vector3d(dArray);
            double d = (Double)map.get("NXdetector:x_pixel_size");
            double d2 = (Double)map.get("NXdetector:y_pixel_size");
            double[] dArray2 = (double[])map.get("NXdetector:NXgeometery:NXshape");
            int n = (int)(dArray2[0] / d);
            int n2 = (int)(dArray2[1] / d2);
            double[] dArray3 = (double[])map.get("NXdetector:NXgeometery:NXorientation");
            Vector3d vector3d2 = new Vector3d();
            vector3d2.cross(new Vector3d(dArray3[0], dArray3[1], dArray3[2]), new Vector3d(dArray3[3], dArray3[4], dArray3[5]));
            Matrix3d matrix3d = new Matrix3d(dArray3[0], dArray3[1], dArray3[2], dArray3[3], dArray3[4], dArray3[5], vector3d2.dot(new Vector3d(1.0, 0.0, 0.0)), vector3d2.dot(new Vector3d(0.0, 1.0, 0.0)), vector3d2.dot(new Vector3d(0.0, 0.0, 1.0)));
            DetectorProperties detectorProperties = new DetectorProperties(vector3d, n, n2, d, d2, matrix3d);
            return detectorProperties;
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static DiffractionCrystalEnvironment createDiffractionCrystalEnvironment(AbstractDataset abstractDataset) throws Exception {
        Map<String, ? extends Object> map = abstractDataset.getMetadataMap();
        try {
            double d = Double.parseDouble(map.get("NXmonochromator:wavelength").toString());
            DiffractionCrystalEnvironment diffractionCrystalEnvironment = new DiffractionCrystalEnvironment(d);
            return diffractionCrystalEnvironment;
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }
}

