/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

import java.util.ArrayList;
import java.util.Collections;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class DetectorProperties {
    private Vector3d origin;
    private Vector3d beamVector;
    private Vector3d normal;
    private int px;
    private int py;
    private double vPxSize;
    private double hPxSize;
    private Matrix3d orientation;
    private Matrix3d invOrientation;
    private Matrix3d ta = new Matrix3d();
    private Matrix3d tb = new Matrix3d();

    public DetectorProperties(Vector3d vector3d, Vector3d vector3d2, int n, int n2, double d, double d2, Matrix3d matrix3d) {
        this();
        this.origin = vector3d;
        this.beamVector = vector3d2;
        vector3d2.normalize();
        this.px = n;
        this.py = n2;
        this.vPxSize = d;
        this.hPxSize = d2;
        this.orientation = matrix3d;
        if (this.orientation == null) {
            this.orientation = new Matrix3d();
            this.orientation.setIdentity();
        }
        this.calcInverse();
    }

    public DetectorProperties(Vector3d vector3d, int n, int n2, double d, double d2, Matrix3d matrix3d) {
        this(vector3d, new Vector3d(0.0, 0.0, 1.0), n, n2, d, d2, matrix3d);
    }

    public DetectorProperties() {
    }

    private void calcInverse() {
        if (this.normal == null) {
            this.normal = new Vector3d(0.0, 0.0, 1.0);
        } else {
            this.normal.set(0.0, 0.0, 1.0);
        }
        this.orientation.transform((Tuple3d)this.normal);
        if (this.invOrientation == null) {
            this.invOrientation = new Matrix3d(this.orientation);
        } else {
            this.invOrientation.set(this.orientation);
        }
        this.invOrientation.transpose();
    }

    public Vector3d getHorizontalVector() {
        Vector3d vector3d = new Vector3d(-this.hPxSize, 0.0, 0.0);
        this.orientation.transform((Tuple3d)vector3d);
        return vector3d;
    }

    public Vector3d getVerticalVector() {
        Vector3d vector3d = new Vector3d(0.0, -this.vPxSize, 0.0);
        this.orientation.transform((Tuple3d)vector3d);
        return vector3d;
    }

    public Vector3d getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector3d vector3d) {
        this.origin = vector3d;
    }

    public int getPx() {
        return this.px;
    }

    public void setPx(int n) {
        this.px = n;
    }

    public int getPy() {
        return this.py;
    }

    public void setPy(int n) {
        this.py = n;
    }

    public double getVPxSize() {
        return this.vPxSize;
    }

    public void setVPxSize(double d) {
        this.vPxSize = d;
    }

    public double getHPxSize() {
        return this.hPxSize;
    }

    public void setHPxSize(double d) {
        this.hPxSize = d;
    }

    public double getDetectorSizeV() {
        return this.vPxSize * (double)this.py;
    }

    public double getDetectorSizeH() {
        return this.hPxSize * (double)this.px;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public void setOrientation(Matrix3d matrix3d) {
        this.orientation = matrix3d;
        this.calcInverse();
    }

    public void setOrientationEulerZXZ(double d, double d2, double d3) {
        if (this.orientation == null) {
            this.orientation = new Matrix3d();
        }
        this.ta.rotZ(d);
        this.tb.rotX(d2);
        this.tb.mul(this.ta);
        this.orientation.rotZ(d3);
        this.orientation.mul(this.tb);
        this.calcInverse();
    }

    public void setOrientationEulerZYZ(double d, double d2, double d3) {
        if (this.orientation == null) {
            this.orientation = new Matrix3d();
        }
        this.ta.rotZ(d);
        this.tb.rotY(d2);
        this.tb.mul(this.ta);
        this.orientation.rotZ(d3);
        this.orientation.mul(this.tb);
        this.calcInverse();
    }

    public Matrix3d getOrientation() {
        return this.orientation;
    }

    public void setBeamVector(Vector3d vector3d) {
        this.beamVector = vector3d;
        vector3d.normalize();
    }

    public Vector3d getBeamVector() {
        return this.beamVector;
    }

    public void pixelPosition(double d, double d2, Vector3d vector3d) {
        vector3d.set(-this.hPxSize * d, -this.vPxSize * d2, 0.0);
        this.orientation.transform((Tuple3d)vector3d);
        vector3d.add((Tuple3d)this.origin);
    }

    public void pixelPosition(int n, int n2, Vector3d vector3d) {
        this.pixelPosition((double)n, (double)n2, vector3d);
    }

    public Vector3d pixelPosition(double d, double d2) {
        Vector3d vector3d = new Vector3d();
        this.pixelPosition(d, d2, vector3d);
        return vector3d;
    }

    public Vector3d pixelPosition(int n, int n2) {
        return this.pixelPosition((double)n, (double)n2);
    }

    public void pixelCoords(Vector3d vector3d, Vector3d vector3d2) {
        vector3d2.set((Tuple3d)vector3d);
        vector3d2.sub((Tuple3d)this.origin);
        this.invOrientation.transform((Tuple3d)vector3d2);
        vector3d2.x /= -this.hPxSize;
        vector3d2.y /= -this.vPxSize;
    }

    public void pixelCoords(Vector3d vector3d, Vector3d vector3d2, int[] nArray) {
        this.pixelCoords(vector3d, vector3d2);
        nArray[0] = (int)Math.floor(vector3d2.x);
        nArray[1] = (int)Math.floor(vector3d2.y);
    }

    public void pixelCoords(Vector3d vector3d, int[] nArray) {
        Vector3d vector3d2 = new Vector3d();
        this.pixelCoords(vector3d, vector3d2, nArray);
    }

    public int[] pixelCoords(Vector3d vector3d) {
        int[] nArray = new int[2];
        this.pixelCoords(vector3d, nArray);
        return nArray;
    }

    public double pixelScatteringAngle(double d, double d2) {
        Vector3d vector3d = this.pixelPosition(d, d2);
        vector3d.normalize();
        return Math.acos(vector3d.dot(this.beamVector));
    }

    public double pixelScatteringAngle(int n, int n2) {
        return this.pixelScatteringAngle((double)n, (double)n2);
    }

    public Vector3d getBeamPosition() {
        try {
            return this.intersect(this.beamVector);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("No intersection when beam is parallel to detector");
        }
    }

    public Vector3d intersect(Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        this.intersect(vector3d, vector3d2);
        return vector3d2;
    }

    public void intersect(Vector3d vector3d, Vector3d vector3d2) {
        vector3d2.set((Tuple3d)vector3d);
        double d = this.normal.dot(vector3d);
        if (d == 0.0) {
            throw new IllegalArgumentException("No intersection possible as direction vector is parallel to detector");
        }
        d = this.normal.dot(this.origin) / d;
        vector3d2.scale(d);
    }

    private Vector3d[] cornerPositions() {
        Vector3d[] vector3dArray = new Vector3d[]{(Vector3d)this.origin.clone(), this.pixelPosition(this.px, 0), this.pixelPosition(0, this.py), this.pixelPosition(this.px, this.py)};
        return vector3dArray;
    }

    public int[] pixelClosestToBeamCentre() {
        if (!this.inImage(this.getBeamPosition())) {
            throw new IllegalArgumentException("The beam does not intersect the detector. There is no complete resolution ring");
        }
        int[] nArray = this.pixelCoords(this.getBeamPosition());
        double d = Double.MAX_VALUE;
        int[] nArray2 = new int[2];
        if (this.distBetweenPix(nArray[0], nArray[1], nArray[0], 0) < d) {
            nArray2[0] = nArray[0];
            nArray2[1] = 0;
            d = this.distBetweenPix(nArray[0], nArray[1], nArray[0], 0);
        }
        if (this.distBetweenPix(nArray[0], nArray[1], 0, nArray[1]) < d) {
            nArray2[0] = 0;
            nArray2[1] = nArray[1];
            d = this.distBetweenPix(nArray[0], nArray[1], 0, nArray[1]);
        }
        if (this.distBetweenPix(nArray[0], nArray[1], nArray[0] - this.px, this.py) < d) {
            nArray2[0] = this.px - nArray[0];
            nArray2[1] = this.py;
            d = this.distBetweenPix(nArray[0], nArray[1], nArray[0] - this.px, this.py);
        }
        if (this.distBetweenPix(nArray[0], nArray[1], this.px, nArray[1] - this.py) < d) {
            nArray2[0] = this.px;
            nArray2[1] = this.py - nArray[1];
            d = this.distBetweenPix(nArray[0], nArray[1], this.px, nArray[1] - this.py);
        }
        return nArray2;
    }

    private double distBetweenPix(int n, int n2, int n3, int n4) {
        return Math.sqrt((n - n3) * (n - n3) + (n2 - n4) * (n2 - n4));
    }

    public Vector3d vectorToClocestPiont() {
        int[] nArray = this.pixelClosestToBeamCentre();
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)this.pixelPosition(nArray[0], nArray[1]), (Tuple3d)this.getBeamPosition());
        return vector3d;
    }

    public int distToCloestEdgeInPx() {
        int[] nArray = this.pixelClosestToBeamCentre();
        int[] nArray2 = this.pixelCoords(this.getBeamPosition());
        return (int)this.distBetweenPix(nArray[0], nArray[1], nArray2[0], nArray2[1]);
    }

    public Vector3d getLongestVector() {
        Vector3d[] vector3dArray = this.cornerPositions();
        Vector3d vector3d = new Vector3d();
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < 4) {
            Vector3d vector3d2 = new Vector3d();
            vector3d2.sub((Tuple3d)vector3dArray[n], (Tuple3d)this.getBeamPosition());
            double d2 = vector3d2.length();
            if (d2 > d) {
                vector3d = vector3d2;
                d = vector3d.length();
            }
            ++n;
        }
        return vector3d;
    }

    public double getMaxScatteringAngle() {
        Vector3d[] vector3dArray = this.cornerPositions();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < 4) {
            vector3dArray[n].normalize();
            arrayList.add(vector3dArray[n].dot(this.beamVector));
            ++n;
        }
        Collections.sort(arrayList);
        return Math.acos((Double)arrayList.get(0));
    }

    public boolean inImage(int n, int n2) {
        return n >= 0 && n2 < this.px && n2 >= 0 && n2 < this.py;
    }

    public boolean inImage(int[] nArray) {
        return this.inImage(nArray[0], nArray[1]);
    }

    public boolean inImage(Vector3d vector3d) {
        return this.inImage(this.pixelCoords(vector3d));
    }
}

