/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class Centroid
implements DatasetToDatasetFunction {
    private AbstractDataset[] bases = null;

    public Centroid(AbstractDataset ... abstractDatasetArray) {
        this.bases = abstractDatasetArray;
    }

    private void checkCompatibility(IDataset iDataset) {
        int n = iDataset.getRank();
        int[] nArray = iDataset.getShape();
        if (n == this.bases.length) {
            int n2 = 0;
            while (n2 < n) {
                if (nArray[n2] != this.bases[n2].getSize()) break;
                ++n2;
            }
            if (n2 == n) {
                return;
            }
        }
        throw new IllegalArgumentException("Dataset shape does not match given or default coordinate base");
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            int n3 = iDataset.getRank();
            int[] nArray = iDataset.getShape();
            if (this.bases == null || this.bases.length == 0) {
                this.bases = new AbstractDataset[n3];
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = nArray[n4];
                    DoubleDataset doubleDataset = new DoubleDataset(n5);
                    this.bases[n4] = doubleDataset;
                    int n6 = 0;
                    while (n6 < n5) {
                        doubleDataset.setAbs((double)n6 + 0.5, n6);
                        ++n6;
                    }
                    ++n4;
                }
            } else {
                this.checkCompatibility(iDataset);
            }
            PositionIterator positionIterator = new PositionIterator(iDataset.getShape());
            int[] nArray2 = positionIterator.getPos();
            double d = 0.0;
            double[] dArray = new double[n3];
            while (positionIterator.hasNext()) {
                double d2 = iDataset.getDouble(nArray2);
                d += d2;
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = n7;
                    dArray[n8] = dArray[n8] + this.bases[n7].getElementDoubleAbs(nArray2[n7]) * d2;
                    ++n7;
                }
            }
            int n9 = 0;
            while (n9 < n3) {
                int n10 = n9++;
                dArray[n10] = dArray[n10] / d;
            }
            DoubleDataset doubleDataset = new DoubleDataset(dArray, new int[0]);
            arrayList.add(doubleDataset);
            ++n2;
        }
        return arrayList;
    }
}

