/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.Random;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;

public class StatsTest {
    private static final String msg = "This test is statistical in nature and can fail. Try re-running.";

    @Test
    public void TestRand() {
        Random.seed(103);
        DoubleDataset doubleDataset = Random.rand(100000);
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)doubleDataset.mean()).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(0.5 / Math.sqrt(3.0)), (double)doubleDataset.stdDeviation().doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.skewness(doubleDataset)).doubleValue(), (double)0.015);
        Assert.assertEquals((String)msg, (double)-1.2, (double)((Number)Stats.kurtosis(doubleDataset)).doubleValue(), (double)0.001);
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)Stats.median(doubleDataset)).doubleValue(), (double)0.004);
        DoubleDataset doubleDataset2 = Random.rand(100000);
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)doubleDataset2.mean()).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(0.5 / Math.sqrt(3.0)), (double)doubleDataset2.stdDeviation().doubleValue(), (double)0.04);
        double d = 0.0;
        long l = -System.nanoTime();
        int n = 0;
        while (n < 5) {
            d = Stats.residual(doubleDataset, doubleDataset2);
            ++n;
        }
        System.out.printf("New residual takes %.3fms\n", (double)(l += System.nanoTime()) * 1.0E-6);
        Number number = null;
        l = -System.nanoTime();
        int n2 = 0;
        while (n2 < 5) {
            number = (Number)Maths.square(Maths.subtract(doubleDataset, doubleDataset2)).sum();
            ++n2;
        }
        System.out.printf("Old residual takes %.3fms\n", (double)(l += System.nanoTime()) * 1.0E-6);
        Assert.assertEquals((String)msg, (double)d, (double)number.doubleValue(), (double)(1.0E-14 * d));
    }

    @Test
    public void TestRandn() {
        Random.seed(103);
        DoubleDataset doubleDataset = Random.randn(100000);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)doubleDataset.mean()).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)1.0, (double)doubleDataset.stdDeviation().doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.skewness(doubleDataset)).doubleValue(), (double)0.015);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.kurtosis(doubleDataset)).doubleValue(), (double)0.06);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.median(doubleDataset)).doubleValue(), (double)0.04);
    }

    @Test
    public void TestRandExp() {
        Random.seed(103);
        double d = 0.3;
        DoubleDataset doubleDataset = Random.exponential(d, 100000);
        Assert.assertEquals((String)msg, (double)d, (double)((Number)doubleDataset.mean()).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)d, (double)doubleDataset.stdDeviation().doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)2.0, (double)((Number)Stats.skewness(doubleDataset)).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)6.0, (double)((Number)Stats.kurtosis(doubleDataset)).doubleValue(), (double)0.3);
        Assert.assertEquals((String)msg, (double)(Math.log(2.0) * d), (double)((Number)Stats.median(doubleDataset)).doubleValue(), (double)0.004);
    }

    @Test
    public void TestRandPois() {
        Random.seed(103);
        double d = 0.3;
        IntegerDataset integerDataset = Random.poisson(d, 100000);
        Assert.assertEquals((String)msg, (double)d, (double)((Number)integerDataset.mean()).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)Math.sqrt(d), (double)integerDataset.stdDeviation().doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(1.0 / Math.sqrt(d)), (double)((Number)Stats.skewness(integerDataset)).doubleValue(), (double)0.05);
        Assert.assertEquals((String)msg, (double)(1.0 / d), (double)((Number)Stats.kurtosis(integerDataset)).doubleValue(), (double)0.35);
        Assert.assertEquals((String)msg, (double)Math.floor(d + 0.3333333333333333 - 0.02 / d), (double)((Number)Stats.median(integerDataset)).doubleValue(), (double)0.004);
    }
}

