/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.moment.FourthMoment;
import org.apache.commons.math.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math.stat.descriptive.moment.Skewness;
import org.apache.commons.math.stat.descriptive.moment.ThirdMoment;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;

public class Stats {
    private static AbstractDataset calcQuartileStats(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2 = null;
        int n = abstractDataset.getElementsPerItem();
        if (n == 1) {
            abstractDataset2 = DatasetUtils.sort(abstractDataset, null);
            abstractDataset.setStoredValue("median", new Double(Stats.pQuantile(abstractDataset2, 0.5)));
            abstractDataset.setStoredValue("quartile1", new Double(Stats.pQuantile(abstractDataset2, 0.25)));
            abstractDataset.setStoredValue("quartile3", new Double(Stats.pQuantile(abstractDataset2, 0.75)));
        } else {
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(abstractDataset.shape, abstractDataset.getDtype());
            abstractDataset.setStoredValue("median", new double[n]);
            abstractDataset.setStoredValue("quartile1", new double[n]);
            abstractDataset.setStoredValue("quartile3", new double[n]);
            int n2 = 0;
            while (n2 < n) {
                ((AbstractCompoundDataset)abstractDataset).copyElements(abstractDataset3, n2);
                abstractDataset3.sort(null);
                double[] dArray = (double[])abstractDataset.getStoredValue("median");
                dArray[n2] = Stats.pQuantile(abstractDataset3, 0.5);
                dArray = (double[])abstractDataset.getStoredValue("quartile1");
                dArray[n2] = Stats.pQuantile(abstractDataset3, 0.25);
                dArray = (double[])abstractDataset.getStoredValue("quartile3");
                dArray[n2] = Stats.pQuantile(abstractDataset3, 0.75);
                if (n2 == 0) {
                    abstractDataset2 = abstractDataset3.clone();
                }
                ++n2;
            }
        }
        return abstractDataset2;
    }

    private static Object getQStatistics(AbstractDataset abstractDataset, String string) {
        Object object = abstractDataset.getStoredValue(string);
        if (object == null) {
            Stats.calcQuartileStats(abstractDataset);
            object = abstractDataset.getStoredValue(string);
        }
        return object;
    }

    private static AbstractDataset getQStatistics(AbstractDataset abstractDataset, int n, String string) {
        n = abstractDataset.checkAxis(n);
        Object object = abstractDataset.getStoredValue(string);
        int n2 = abstractDataset.getElementsPerItem();
        if (object == null) {
            if (n2 == 1) {
                AbstractDataset abstractDataset2 = DatasetUtils.sort(abstractDataset, n);
                abstractDataset.setStoredValue("median-" + n, Stats.pQuantile(abstractDataset2, n, 0.5));
                abstractDataset.setStoredValue("quartile1-" + n, Stats.pQuantile(abstractDataset2, n, 0.25));
                abstractDataset.setStoredValue("quartile3-" + n, Stats.pQuantile(abstractDataset2, n, 0.75));
            } else {
                AbstractDataset abstractDataset3 = AbstractDataset.zeros(abstractDataset.shape, abstractDataset.getDtype());
                int n3 = 0;
                while (n3 < n2) {
                    CompoundDoubleDataset compoundDoubleDataset;
                    ((AbstractCompoundDataset)abstractDataset).copyElements(abstractDataset3, n3);
                    abstractDataset3.sort(n);
                    AbstractDataset abstractDataset4 = Stats.pQuantile(abstractDataset3, n, 0.5);
                    if (n3 == 0) {
                        compoundDoubleDataset = (CompoundDoubleDataset)AbstractDataset.zeros(n2, abstractDataset4.shape, abstractDataset4.getDtype());
                        abstractDataset.setStoredValue("median-" + n, abstractDataset4);
                        compoundDoubleDataset = (CompoundDoubleDataset)AbstractDataset.zeros(n2, abstractDataset4.shape, abstractDataset4.getDtype());
                        abstractDataset.setStoredValue("quartile1-" + n, abstractDataset4);
                        compoundDoubleDataset = (CompoundDoubleDataset)AbstractDataset.zeros(n2, abstractDataset4.shape, abstractDataset4.getDtype());
                        abstractDataset.setStoredValue("quartile3-" + n, abstractDataset4);
                    }
                    compoundDoubleDataset = (CompoundDoubleDataset)abstractDataset.getStoredValue("median-" + n);
                    compoundDoubleDataset.setElements(abstractDataset4, n3);
                    abstractDataset4 = Stats.pQuantile(abstractDataset3, n, 0.25);
                    compoundDoubleDataset = (CompoundDoubleDataset)abstractDataset.getStoredValue("quartile1-" + n);
                    compoundDoubleDataset.setElements(abstractDataset4, n3);
                    abstractDataset4 = Stats.pQuantile(abstractDataset3, n, 0.75);
                    compoundDoubleDataset = (CompoundDoubleDataset)abstractDataset.getStoredValue("quartile3-" + n);
                    compoundDoubleDataset.setElements(abstractDataset4, n3);
                    ++n3;
                }
            }
            object = abstractDataset.getStoredValue(string);
        }
        return (AbstractDataset)object;
    }

    private static double pQuantile(AbstractDataset abstractDataset, double d) {
        double d2 = (double)(abstractDataset.size - 1) * d;
        int n = (int)Math.floor(d2);
        d2 -= (double)n;
        double d3 = abstractDataset.getElementDoubleAbs(n);
        if (d2 > 0.0) {
            d3 = (1.0 - d2) * d3 + d2 * abstractDataset.getElementDoubleAbs(n + 1);
        }
        return d3;
    }

    private static AbstractDataset pQuantile(AbstractDataset abstractDataset, int n, double d) {
        int n2 = abstractDataset.getRank();
        int n3 = abstractDataset.getElementsPerItem();
        int[] nArray = abstractDataset.getShape();
        double d2 = (double)(nArray[n] - 1) * d;
        int n4 = (int)Math.floor(d2);
        d2 -= (double)n4;
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(n3, nArray2, 6);
        IndexIterator indexIterator = abstractDataset2.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n5 = 0;
            while (n5 < n) {
                nArray4[n5] = nArray3[n5];
                ++n5;
            }
            nArray4[n5++] = n4;
            while (n5 < n2) {
                nArray4[n5] = nArray3[n5 - 1];
                ++n5;
            }
            Object object = abstractDataset.getObject(nArray4);
            abstractDataset2.set(object, nArray3);
        }
        if (d2 > 0.0) {
            indexIterator = abstractDataset2.getIterator(true);
            nArray3 = indexIterator.getPos();
            ++n4;
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(n3, nArray2, 6);
            while (indexIterator.hasNext()) {
                int n6 = 0;
                while (n6 < n) {
                    nArray4[n6] = nArray3[n6];
                    ++n6;
                }
                nArray4[n6++] = n4;
                while (n6 < n2) {
                    nArray4[n6] = nArray3[n6 - 1];
                    ++n6;
                }
                Object object = abstractDataset.getObject(nArray4);
                abstractDataset3.set(object, nArray3);
            }
            abstractDataset3.imultiply(d2);
            abstractDataset2.imultiply(1.0 - d2);
            abstractDataset2.iadd(abstractDataset3);
        }
        return abstractDataset2;
    }

    public static double quantile(AbstractDataset abstractDataset, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Quantile requested is outside [0,1]");
        }
        AbstractDataset abstractDataset2 = Stats.calcQuartileStats(abstractDataset);
        return Stats.pQuantile(abstractDataset2, d);
    }

    public static AbstractDataset median(AbstractDataset abstractDataset, int n) {
        return Stats.getQStatistics(abstractDataset, n, "median-" + n);
    }

    public static Object median(AbstractDataset abstractDataset) {
        return Stats.getQStatistics(abstractDataset, "median");
    }

    public static Object iqr(AbstractDataset abstractDataset) {
        int n = abstractDataset.getElementsPerItem();
        if (n == 1) {
            double d = (Double)Stats.getQStatistics(abstractDataset, "quartile3");
            return new Double(d - (Double)abstractDataset.getStoredValue("quartile1"));
        }
        double[] dArray = (double[])Stats.getQStatistics(abstractDataset, "quartile1");
        double[] dArray2 = (double[])Stats.getQStatistics(abstractDataset, "quartile3");
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            dArray2[n3] = dArray2[n3] - dArray[n2];
            ++n2;
        }
        return dArray2;
    }

    public static AbstractDataset iqr(AbstractDataset abstractDataset, int n) {
        AbstractDataset abstractDataset2 = Stats.getQStatistics(abstractDataset, n, "quartile3-" + n);
        return Maths.subtract((Object)abstractDataset2, abstractDataset.getStoredValue("quartile1-" + n));
    }

    private static Object getFourthMoment(AbstractDataset abstractDataset) {
        Object object = abstractDataset.getStoredValue("moment4");
        if (object == null) {
            int n = abstractDataset.getElementsPerItem();
            IndexIterator indexIterator = abstractDataset.getIterator();
            if (n == 1) {
                FourthMoment fourthMoment = new FourthMoment();
                while (indexIterator.hasNext()) {
                    fourthMoment.increment(abstractDataset.getElementDoubleAbs(indexIterator.index));
                }
                abstractDataset.setStoredValue("moment4", fourthMoment);
            } else {
                FourthMoment[] fourthMomentArray = new FourthMoment[n];
                int n2 = 0;
                while (n2 < n) {
                    fourthMomentArray[n2] = new FourthMoment();
                    ++n2;
                }
                while (indexIterator.hasNext()) {
                    n2 = 0;
                    while (n2 < n) {
                        fourthMomentArray[n2].increment(abstractDataset.getElementDoubleAbs(indexIterator.index + n2));
                        ++n2;
                    }
                }
                abstractDataset.setStoredValue("moment4", fourthMomentArray);
            }
            object = abstractDataset.getStoredValue("moment4");
        }
        return object;
    }

    public static Object skewness(AbstractDataset abstractDataset) {
        Object object = Stats.getFourthMoment(abstractDataset);
        if (object instanceof FourthMoment) {
            return new Double(new Skewness((ThirdMoment)((FourthMoment)object)).getResult());
        }
        FourthMoment[] fourthMomentArray = (FourthMoment[])object;
        int n = fourthMomentArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = new Skewness((ThirdMoment)fourthMomentArray[n2]).getResult();
            ++n2;
        }
        return dArray;
    }

    public static Object kurtosis(AbstractDataset abstractDataset) {
        Object object = Stats.getFourthMoment(abstractDataset);
        if (object instanceof FourthMoment) {
            return new Double(new Kurtosis((FourthMoment)object).getResult());
        }
        FourthMoment[] fourthMomentArray = (FourthMoment[])object;
        int n = fourthMomentArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = new Kurtosis(fourthMomentArray[n2]).getResult();
            ++n2;
        }
        return dArray;
    }

    private static void calculateHigherMoments(AbstractDataset abstractDataset, int n) {
        int n2 = abstractDataset.getRank();
        int[] nArray = abstractDataset.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        DoubleDataset doubleDataset = new DoubleDataset(nArray2);
        DoubleDataset doubleDataset2 = new DoubleDataset(nArray2);
        IndexIterator indexIterator = doubleDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n4 = 0;
            while (n4 < n) {
                nArray4[n4] = nArray3[n4];
                ++n4;
            }
            nArray4[n4++] = 0;
            while (n4 < n2) {
                nArray4[n4] = nArray3[n4 - 1];
                ++n4;
            }
            FourthMoment fourthMoment = new FourthMoment();
            int n5 = 0;
            while (n5 < n3) {
                nArray4[n] = n5;
                double d = abstractDataset.getDouble(nArray4);
                if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                    fourthMoment.increment(d);
                }
                ++n5;
            }
            doubleDataset.set(new Skewness((ThirdMoment)fourthMoment).getResult(), nArray4);
            doubleDataset2.set(new Kurtosis(fourthMoment).getResult(), nArray4);
        }
        abstractDataset.setStoredValue("skewness-" + n, doubleDataset);
        abstractDataset.setStoredValue("kurtosis-" + n, doubleDataset2);
    }

    private static DoubleDataset getHigherStatistic(AbstractDataset abstractDataset, int n, String string) {
        n = abstractDataset.checkAxis(n);
        DoubleDataset doubleDataset = (DoubleDataset)abstractDataset.getStoredValue(string);
        if (doubleDataset == null) {
            Stats.calculateHigherMoments(abstractDataset, n);
            doubleDataset = (DoubleDataset)abstractDataset.getStoredValue(string);
        }
        return doubleDataset;
    }

    public static AbstractDataset skewness(AbstractDataset abstractDataset, int n) {
        return Stats.getHigherStatistic(abstractDataset, n, "skewness-" + n);
    }

    public static AbstractDataset kurtosis(AbstractDataset abstractDataset, int n) {
        return Stats.getHigherStatistic(abstractDataset, n, "kurtosis-" + n);
    }

    public static Object product(AbstractDataset abstractDataset) {
        int n = abstractDataset.getDtype();
        if (abstractDataset.isComplex()) {
            IndexIterator indexIterator = abstractDataset.getIterator();
            double d = 1.0;
            double d2 = 0.0;
            while (indexIterator.hasNext()) {
                double d3 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                double d4 = abstractDataset.getElementDoubleAbs(indexIterator.index + 1);
                double d5 = d3 * d - d4 * d2;
                d2 = d3 * d2 + d4 * d;
                d = d5;
            }
            return new Complex(d, d2);
        }
        IndexIterator indexIterator = abstractDataset.getIterator();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                long l = 1L;
                while (indexIterator.hasNext()) {
                    l *= abstractDataset.getElementLongAbs(indexIterator.index);
                }
                return new Long(l);
            }
            case 100: 
            case 200: 
            case 300: 
            case 400: {
                long l = 1L;
                int n2 = abstractDataset.getElementsPerItem();
                long[] lArray = new long[n2];
                int n3 = 0;
                while (n3 < n2) {
                    lArray[n3] = 1L;
                    ++n3;
                }
                while (indexIterator.hasNext()) {
                    n3 = 0;
                    while (n3 < n2) {
                        int n4 = n3;
                        lArray[n4] = lArray[n4] * abstractDataset.getElementLongAbs(indexIterator.index + n3);
                        ++n3;
                    }
                }
                return lArray;
            }
            case 5: 
            case 6: {
                double d = 1.0;
                while (indexIterator.hasNext()) {
                    d *= abstractDataset.getElementDoubleAbs(indexIterator.index);
                }
                return new Double(d);
            }
            case 500: 
            case 600: {
                int n5 = abstractDataset.getElementsPerItem();
                double[] dArray = new double[n5];
                int n6 = 0;
                while (n6 < n5) {
                    dArray[n6] = 1.0;
                    ++n6;
                }
                while (indexIterator.hasNext()) {
                    n6 = 0;
                    while (n6 < n5) {
                        int n7 = n6;
                        dArray[n7] = dArray[n7] * abstractDataset.getElementDoubleAbs(indexIterator.index + n6);
                        ++n6;
                    }
                }
                return dArray;
            }
        }
        return null;
    }

    public static AbstractDataset product(AbstractDataset abstractDataset, int n) {
        n = abstractDataset.checkAxis(n);
        int n2 = abstractDataset.getDtype();
        int n3 = abstractDataset.getRank();
        int[] nArray = abstractDataset.getShape();
        int n4 = abstractDataset.getElementsPerItem();
        int n5 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(n4, nArray2, n2);
        IndexIterator indexIterator = abstractDataset2.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n6 = 0;
            while (n6 < n) {
                nArray4[n6] = nArray3[n6];
                ++n6;
            }
            nArray4[n6++] = 0;
            while (n6 < n3) {
                nArray4[n6] = nArray3[n6 - 1];
                ++n6;
            }
            if (abstractDataset.isComplex()) {
                double d = 1.0;
                double d2 = 0.0;
                switch (n2) {
                    case 7: {
                        ComplexFloatDataset complexFloatDataset = (ComplexFloatDataset)abstractDataset;
                        int n7 = 0;
                        while (n7 < n5) {
                            nArray4[n] = n7++;
                            float f = complexFloatDataset.getReal(nArray4);
                            float f2 = complexFloatDataset.getImag(nArray4);
                            double d3 = (double)f * d - (double)f2 * d2;
                            d2 = (double)f * d2 + (double)f2 * d;
                            d = d3;
                        }
                        break;
                    }
                    case 8: {
                        ComplexDoubleDataset complexDoubleDataset = (ComplexDoubleDataset)abstractDataset;
                        int n8 = 0;
                        while (n8 < n5) {
                            nArray4[n] = n8++;
                            double d4 = complexDoubleDataset.getReal(nArray4);
                            double d5 = complexDoubleDataset.getImag(nArray4);
                            double d6 = d4 * d - d5 * d2;
                            d2 = d4 * d2 + d5 * d;
                            d = d6;
                        }
                        break;
                    }
                }
                abstractDataset2.set(new Complex(d, d2), nArray3);
                continue;
            }
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long l = 1L;
                    int n9 = 0;
                    while (n9 < n5) {
                        nArray4[n] = n9++;
                        l *= (long)abstractDataset.getInt(nArray4);
                    }
                    abstractDataset2.set(l, nArray3);
                    break;
                }
                case 100: {
                    long[] lArray = new long[n4];
                    int n10 = 0;
                    while (n10 < n4) {
                        lArray[n10] = 1L;
                        ++n10;
                    }
                    n10 = 0;
                    while (n10 < n5) {
                        nArray4[n] = n10;
                        byte[] byArray = (byte[])abstractDataset.getObject(nArray4);
                        int n11 = 0;
                        while (n11 < n4) {
                            int n12 = n11;
                            lArray[n12] = lArray[n12] * (long)byArray[n11];
                            ++n11;
                        }
                        ++n10;
                    }
                    abstractDataset2.set(lArray, nArray3);
                    break;
                }
                case 200: {
                    long[] lArray = new long[n4];
                    int n13 = 0;
                    while (n13 < n4) {
                        lArray[n13] = 1L;
                        ++n13;
                    }
                    n13 = 0;
                    while (n13 < n5) {
                        nArray4[n] = n13;
                        short[] sArray = (short[])abstractDataset.getObject(nArray4);
                        int n14 = 0;
                        while (n14 < n4) {
                            int n15 = n14;
                            lArray[n15] = lArray[n15] * (long)sArray[n14];
                            ++n14;
                        }
                        ++n13;
                    }
                    abstractDataset2.set(lArray, nArray3);
                    break;
                }
                case 300: {
                    long[] lArray = new long[n4];
                    int n16 = 0;
                    while (n16 < n4) {
                        lArray[n16] = 1L;
                        ++n16;
                    }
                    n16 = 0;
                    while (n16 < n5) {
                        nArray4[n] = n16;
                        int[] nArray5 = (int[])abstractDataset.getObject(nArray4);
                        int n17 = 0;
                        while (n17 < n4) {
                            int n18 = n17;
                            lArray[n18] = lArray[n18] * (long)nArray5[n17];
                            ++n17;
                        }
                        ++n16;
                    }
                    abstractDataset2.set(lArray, nArray3);
                    break;
                }
                case 400: {
                    long[] lArray = new long[n4];
                    int n19 = 0;
                    while (n19 < n4) {
                        lArray[n19] = 1L;
                        ++n19;
                    }
                    n19 = 0;
                    while (n19 < n5) {
                        nArray4[n] = n19;
                        long[] lArray2 = (long[])abstractDataset.getObject(nArray4);
                        int n20 = 0;
                        while (n20 < n4) {
                            int n21 = n20;
                            lArray[n21] = lArray[n21] * lArray2[n20];
                            ++n20;
                        }
                        ++n19;
                    }
                    abstractDataset2.set(lArray, nArray3);
                    break;
                }
                case 5: 
                case 6: {
                    double d = 1.0;
                    int n22 = 0;
                    while (n22 < n5) {
                        nArray4[n] = n22++;
                        d *= abstractDataset.getDouble(nArray4);
                    }
                    abstractDataset2.set(d, nArray3);
                    break;
                }
                case 500: {
                    double[] dArray = new double[n4];
                    int n23 = 0;
                    while (n23 < n4) {
                        dArray[n23] = 1.0;
                        ++n23;
                    }
                    n23 = 0;
                    while (n23 < n5) {
                        nArray4[n] = n23;
                        float[] fArray = (float[])abstractDataset.getObject(nArray4);
                        int n24 = 0;
                        while (n24 < n4) {
                            int n25 = n24;
                            dArray[n25] = dArray[n25] * (double)fArray[n24];
                            ++n24;
                        }
                        ++n23;
                    }
                    abstractDataset2.set(dArray, nArray3);
                    break;
                }
                case 600: {
                    double[] dArray = new double[n4];
                    int n26 = 0;
                    while (n26 < n4) {
                        dArray[n26] = 1.0;
                        ++n26;
                    }
                    n26 = 0;
                    while (n26 < n5) {
                        nArray4[n] = n26;
                        double[] dArray2 = (double[])abstractDataset.getObject(nArray4);
                        int n27 = 0;
                        while (n27 < n4) {
                            int n28 = n27;
                            dArray[n28] = dArray[n28] * dArray2[n27];
                            ++n27;
                        }
                        ++n26;
                    }
                    abstractDataset2.set(dArray, nArray3);
                }
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset cumulativeProduct(AbstractDataset abstractDataset) {
        return Stats.cumulativeProduct(abstractDataset.flatten(), 0);
    }

    public static AbstractDataset cumulativeProduct(AbstractDataset abstractDataset, int n) {
        n = abstractDataset.checkAxis(n);
        int n2 = abstractDataset.getDtype();
        int[] nArray = abstractDataset.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset);
        PositionIterator positionIterator = abstractDataset2.getPositionIterator(n);
        int[] nArray2 = positionIterator.getPos();
        block14: while (positionIterator.hasNext()) {
            if (abstractDataset.isComplex()) {
                double d = 1.0;
                double d2 = 0.0;
                switch (n2) {
                    case 7: {
                        ComplexFloatDataset complexFloatDataset = (ComplexFloatDataset)abstractDataset;
                        int n4 = 0;
                        while (n4 < n3) {
                            nArray2[n] = n4++;
                            float f = complexFloatDataset.getReal(nArray2);
                            float f2 = complexFloatDataset.getImag(nArray2);
                            double d3 = (double)f * d - (double)f2 * d2;
                            d2 = (double)f * d2 + (double)f2 * d;
                            d = d3;
                            complexFloatDataset.set((float)d, (float)d2, nArray2);
                        }
                        break;
                    }
                    case 8: {
                        ComplexDoubleDataset complexDoubleDataset = (ComplexDoubleDataset)abstractDataset;
                        int n5 = 0;
                        while (n5 < n3) {
                            nArray2[n] = n5++;
                            double d4 = complexDoubleDataset.getReal(nArray2);
                            double d5 = complexDoubleDataset.getImag(nArray2);
                            double d6 = d4 * d - d5 * d2;
                            d2 = d4 * d2 + d5 * d;
                            d = d6;
                            complexDoubleDataset.set(d, d2, nArray2);
                        }
                        break;
                    }
                }
                abstractDataset2.set(new Complex(d, d2), nArray2);
                continue;
            }
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long l = 1L;
                    int n6 = 0;
                    while (n6 < n3) {
                        nArray2[n] = n6++;
                        abstractDataset2.set(l *= (long)abstractDataset.getInt(nArray2), nArray2);
                    }
                    continue block14;
                }
                case 100: {
                    int n7 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n7];
                    int n8 = 0;
                    while (n8 < n7) {
                        lArray[n8] = 1L;
                        ++n8;
                    }
                    n8 = 0;
                    while (n8 < n3) {
                        nArray2[n] = n8;
                        byte[] byArray = (byte[])abstractDataset.getObject(nArray2);
                        int n9 = 0;
                        while (n9 < n7) {
                            int n10 = n9;
                            lArray[n10] = lArray[n10] * (long)byArray[n9];
                            ++n9;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n8;
                    }
                    continue block14;
                }
                case 200: {
                    int n11 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n11];
                    int n12 = 0;
                    while (n12 < n11) {
                        lArray[n12] = 1L;
                        ++n12;
                    }
                    n12 = 0;
                    while (n12 < n3) {
                        nArray2[n] = n12;
                        short[] sArray = (short[])abstractDataset.getObject(nArray2);
                        int n13 = 0;
                        while (n13 < n11) {
                            int n14 = n13;
                            lArray[n14] = lArray[n14] * (long)sArray[n13];
                            ++n13;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n12;
                    }
                    continue block14;
                }
                case 300: {
                    int n15 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n15];
                    int n16 = 0;
                    while (n16 < n15) {
                        lArray[n16] = 1L;
                        ++n16;
                    }
                    n16 = 0;
                    while (n16 < n3) {
                        nArray2[n] = n16;
                        int[] nArray3 = (int[])abstractDataset.getObject(nArray2);
                        int n17 = 0;
                        while (n17 < n15) {
                            int n18 = n17;
                            lArray[n18] = lArray[n18] * (long)nArray3[n17];
                            ++n17;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n16;
                    }
                    continue block14;
                }
                case 400: {
                    int n19 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n19];
                    int n20 = 0;
                    while (n20 < n19) {
                        lArray[n20] = 1L;
                        ++n20;
                    }
                    n20 = 0;
                    while (n20 < n3) {
                        nArray2[n] = n20;
                        long[] lArray2 = (long[])abstractDataset.getObject(nArray2);
                        int n21 = 0;
                        while (n21 < n19) {
                            int n22 = n21;
                            lArray[n22] = lArray[n22] * lArray2[n21];
                            ++n21;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n20;
                    }
                    continue block14;
                }
                case 5: 
                case 6: {
                    double d = 1.0;
                    int n23 = 0;
                    while (n23 < n3) {
                        nArray2[n] = n23++;
                        abstractDataset2.set(d *= abstractDataset.getDouble(nArray2), nArray2);
                    }
                    continue block14;
                }
                case 500: {
                    int n24 = abstractDataset.getElementsPerItem();
                    double[] dArray = new double[n24];
                    int n25 = 0;
                    while (n25 < n24) {
                        dArray[n25] = 1.0;
                        ++n25;
                    }
                    n25 = 0;
                    while (n25 < n3) {
                        nArray2[n] = n25;
                        float[] fArray = (float[])abstractDataset.getObject(nArray2);
                        int n26 = 0;
                        while (n26 < n24) {
                            int n27 = n26;
                            dArray[n27] = dArray[n27] * (double)fArray[n26];
                            ++n26;
                        }
                        abstractDataset2.set(dArray, nArray2);
                        ++n25;
                    }
                    continue block14;
                }
                case 600: {
                    int n28 = abstractDataset.getElementsPerItem();
                    double[] dArray = new double[n28];
                    int n29 = 0;
                    while (n29 < n28) {
                        dArray[n29] = 1.0;
                        ++n29;
                    }
                    n29 = 0;
                    while (n29 < n3) {
                        nArray2[n] = n29;
                        double[] dArray2 = (double[])abstractDataset.getObject(nArray2);
                        int n30 = 0;
                        while (n30 < n28) {
                            int n31 = n30;
                            dArray[n31] = dArray[n31] * dArray2[n30];
                            ++n30;
                        }
                        abstractDataset2.set(dArray, nArray2);
                        ++n29;
                    }
                    continue block14;
                }
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset cumulativeSum(AbstractDataset abstractDataset) {
        return Stats.cumulativeSum(abstractDataset.flatten(), 0);
    }

    public static AbstractDataset cumulativeSum(AbstractDataset abstractDataset, int n) {
        n = abstractDataset.checkAxis(n);
        int n2 = abstractDataset.getDtype();
        int[] nArray = abstractDataset.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset);
        PositionIterator positionIterator = abstractDataset2.getPositionIterator(n);
        int[] nArray2 = positionIterator.getPos();
        block14: while (positionIterator.hasNext()) {
            if (abstractDataset.isComplex()) {
                double d = 0.0;
                double d2 = 0.0;
                switch (n2) {
                    case 7: {
                        ComplexFloatDataset complexFloatDataset = (ComplexFloatDataset)abstractDataset;
                        int n4 = 0;
                        while (n4 < n3) {
                            nArray2[n] = n4++;
                            complexFloatDataset.set((float)(d += (double)complexFloatDataset.getReal(nArray2)), (float)(d2 += (double)complexFloatDataset.getImag(nArray2)), nArray2);
                        }
                        break;
                    }
                    case 8: {
                        ComplexDoubleDataset complexDoubleDataset = (ComplexDoubleDataset)abstractDataset;
                        int n5 = 0;
                        while (n5 < n3) {
                            nArray2[n] = n5++;
                            complexDoubleDataset.set(d += complexDoubleDataset.getReal(nArray2), d2 += complexDoubleDataset.getImag(nArray2), nArray2);
                        }
                        break;
                    }
                }
                abstractDataset2.set(new Complex(d, d2), nArray2);
                continue;
            }
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long l = 0L;
                    int n6 = 0;
                    while (n6 < n3) {
                        nArray2[n] = n6++;
                        abstractDataset2.set(l += (long)abstractDataset.getInt(nArray2), nArray2);
                    }
                    continue block14;
                }
                case 100: {
                    int n7;
                    int n8 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n8];
                    int n9 = 0;
                    while (n9 < n3) {
                        nArray2[n] = n9;
                        byte[] byArray = (byte[])abstractDataset.getObject(nArray2);
                        n7 = 0;
                        while (n7 < n8) {
                            int n10 = n7;
                            lArray[n10] = lArray[n10] + (long)byArray[n7];
                            ++n7;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n9;
                    }
                    continue block14;
                }
                case 200: {
                    int n7;
                    int n11 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n11];
                    int n12 = 0;
                    while (n12 < n3) {
                        nArray2[n] = n12;
                        short[] sArray = (short[])abstractDataset.getObject(nArray2);
                        n7 = 0;
                        while (n7 < n11) {
                            int n13 = n7;
                            lArray[n13] = lArray[n13] + (long)sArray[n7];
                            ++n7;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n12;
                    }
                    continue block14;
                }
                case 300: {
                    int n7;
                    int n14 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n14];
                    int n15 = 0;
                    while (n15 < n3) {
                        nArray2[n] = n15;
                        int[] nArray3 = (int[])abstractDataset.getObject(nArray2);
                        n7 = 0;
                        while (n7 < n14) {
                            int n16 = n7;
                            lArray[n16] = lArray[n16] + (long)nArray3[n7];
                            ++n7;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n15;
                    }
                    continue block14;
                }
                case 400: {
                    int n7;
                    int n17 = abstractDataset.getElementsPerItem();
                    long[] lArray = new long[n17];
                    int n18 = 0;
                    while (n18 < n3) {
                        nArray2[n] = n18;
                        long[] lArray2 = (long[])abstractDataset.getObject(nArray2);
                        n7 = 0;
                        while (n7 < n17) {
                            int n19 = n7;
                            lArray[n19] = lArray[n19] + lArray2[n7];
                            ++n7;
                        }
                        abstractDataset2.set(lArray, nArray2);
                        ++n18;
                    }
                    continue block14;
                }
                case 5: 
                case 6: {
                    double d = 0.0;
                    int n7 = 0;
                    while (n7 < n3) {
                        nArray2[n] = n7++;
                        abstractDataset2.set(d += abstractDataset.getDouble(nArray2), nArray2);
                    }
                    continue block14;
                }
                case 500: {
                    int n20;
                    Object[] objectArray;
                    int n21 = abstractDataset.getElementsPerItem();
                    double[] dArray = new double[n21];
                    int n7 = 0;
                    while (n7 < n3) {
                        nArray2[n] = n7;
                        objectArray = (float[])abstractDataset.getObject(nArray2);
                        n20 = 0;
                        while (n20 < n21) {
                            int n22 = n20;
                            dArray[n22] = dArray[n22] + (double)objectArray[n20];
                            ++n20;
                        }
                        abstractDataset2.set(dArray, nArray2);
                        ++n7;
                    }
                    continue block14;
                }
                case 600: {
                    int n20;
                    Object[] objectArray;
                    int n23 = abstractDataset.getElementsPerItem();
                    double[] dArray = new double[n23];
                    int n7 = 0;
                    while (n7 < n3) {
                        nArray2[n] = n7;
                        objectArray = (double[])abstractDataset.getObject(nArray2);
                        n20 = 0;
                        while (n20 < n23) {
                            int n24 = n20;
                            dArray[n24] = dArray[n24] + objectArray[n20];
                            ++n20;
                        }
                        abstractDataset2.set(dArray, nArray2);
                        ++n7;
                    }
                    continue block14;
                }
            }
        }
        return abstractDataset2;
    }

    public static Object averageDeviation(AbstractDataset abstractDataset) {
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getElementsPerItem();
        if (n == 1) {
            double d = (Double)abstractDataset.mean();
            double d2 = 0.0;
            while (indexIterator.hasNext()) {
                d2 += Math.abs(abstractDataset.getElementDoubleAbs(indexIterator.index) - d);
            }
            return d2 / (double)abstractDataset.getSize();
        }
        double[] dArray = (double[])abstractDataset.mean();
        double[] dArray2 = new double[n];
        while (indexIterator.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + Math.abs(abstractDataset.getElementDoubleAbs(indexIterator.index + n2) - dArray[n2]);
                ++n2;
            }
        }
        double d = abstractDataset.getSize();
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4++;
            dArray2[n5] = dArray2[n5] / d;
        }
        return dArray2;
    }

    public static double residual(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        return abstractDataset.residual(abstractDataset2);
    }
}

