/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FFT;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;

public class Signal {
    private static int[] paddedShape(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = (int[])nArray.clone();
        if (nArray3 == null) {
            int n = 0;
            while (n < nArray4.length) {
                int n2 = n;
                nArray4[n2] = nArray4[n2] + (nArray2[n] - 1);
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray4.length) {
                int n3 = 0;
                while (n3 < nArray3.length) {
                    if (n == nArray3[n3]) break;
                    ++n3;
                }
                if (n3 < nArray3.length) {
                    int n4 = n;
                    nArray4[n4] = nArray4[n4] + (nArray2[n] - 1);
                }
                ++n;
            }
        }
        return nArray4;
    }

    public static AbstractDataset convolve(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int[] nArray) {
        abstractDataset.checkCompatibility(abstractDataset2);
        AbstractDataset abstractDataset3 = null;
        AbstractDataset abstractDataset4 = null;
        int[] nArray2 = Signal.paddedShape(abstractDataset.shape, abstractDataset2.shape, nArray);
        abstractDataset3 = FFT.fftn(abstractDataset, nArray2, nArray);
        abstractDataset4 = FFT.fftn(abstractDataset2, nArray2, nArray);
        abstractDataset3 = Maths.multiply(abstractDataset3, abstractDataset4);
        AbstractDataset abstractDataset5 = FFT.ifftn(abstractDataset3, nArray2, nArray);
        if (abstractDataset.isComplex() || abstractDataset2.isComplex()) {
            return abstractDataset5;
        }
        return abstractDataset5.real();
    }

    public static AbstractDataset correlate(AbstractDataset abstractDataset, int[] nArray) {
        AbstractDataset abstractDataset2 = null;
        int[] nArray2 = Signal.paddedShape(abstractDataset.shape, abstractDataset.shape, nArray);
        abstractDataset2 = FFT.fftn(abstractDataset, nArray2, nArray);
        abstractDataset2 = Maths.multiply(abstractDataset2, Maths.conjugate(abstractDataset2));
        AbstractDataset abstractDataset3 = FFT.ifftn(abstractDataset2, nArray2, nArray);
        if (abstractDataset.isComplex()) {
            return abstractDataset3;
        }
        return abstractDataset3.real();
    }

    public static AbstractDataset correlate(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int[] nArray) {
        AbstractDataset abstractDataset3 = null;
        AbstractDataset abstractDataset4 = null;
        int[] nArray2 = Signal.paddedShape(abstractDataset.shape, abstractDataset2.shape, nArray);
        abstractDataset3 = FFT.fftn(abstractDataset, nArray2, nArray);
        abstractDataset4 = FFT.fftn(abstractDataset2, nArray2, nArray);
        abstractDataset3 = Maths.multiply(abstractDataset3, Maths.conjugate(abstractDataset4));
        AbstractDataset abstractDataset5 = FFT.ifftn(abstractDataset3, nArray2, nArray);
        if (abstractDataset.isComplex() || abstractDataset2.isComplex()) {
            return abstractDataset5;
        }
        return abstractDataset5.real();
    }

    public static List<AbstractDataset> phaseCorrelate(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int[] nArray, boolean bl) {
        AbstractDataset abstractDataset3 = null;
        AbstractDataset abstractDataset4 = null;
        int[] nArray2 = Signal.paddedShape(abstractDataset.shape, abstractDataset2.shape, nArray);
        abstractDataset3 = FFT.fftn(abstractDataset, nArray2, nArray);
        abstractDataset4 = FFT.fftn(abstractDataset2, nArray2, nArray);
        abstractDataset3.idivide(abstractDataset4);
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        abstractDataset4 = Maths.phaseAsComplexNumber(abstractDataset3, true);
        AbstractDataset abstractDataset5 = FFT.ifftn(abstractDataset4, nArray2, nArray);
        if (abstractDataset.isComplex() || abstractDataset2.isComplex()) {
            arrayList.add(abstractDataset5);
        } else {
            arrayList.add(abstractDataset5.real());
        }
        if (bl) {
            abstractDataset5 = FFT.ifftn(abstractDataset3, nArray2, nArray);
            if (abstractDataset.isComplex() || abstractDataset2.isComplex()) {
                arrayList.add(abstractDataset5);
            } else {
                arrayList.add(abstractDataset5.real());
            }
        }
        return arrayList;
    }
}

