/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;

public class SWTImageUtils {
    public static ImageData createImageData(AbstractDataset abstractDataset) {
        return SWTImageUtils.createImageData(abstractDataset, abstractDataset.max());
    }

    public static ImageData createImageData(AbstractDataset abstractDataset, Number number) {
        ImageData imageData;
        int[] nArray = abstractDataset.getShape();
        int n = nArray[0];
        int n2 = nArray.length == 1 ? 1 : nArray[1];
        long l = number.longValue();
        IndexIterator indexIterator = abstractDataset.getIterator(true);
        int[] nArray2 = indexIterator.getPos();
        if (abstractDataset instanceof RGBDataset) {
            RGBDataset rGBDataset = (RGBDataset)abstractDataset;
            short[] sArray = rGBDataset.getData();
            if (l < 32L) {
                imageData = new ImageData(n2, n, 16, new PaletteData(31744, 992, 31));
                while (indexIterator.hasNext()) {
                    int n3 = indexIterator.index;
                    int n4 = (sArray[n3] & 0x1F) << 10 | (sArray[n3 + 1] & 0x1F) << 5 | sArray[n3 + 2] & 0x1F;
                    imageData.setPixel(nArray2[1], nArray2[0], n4);
                }
            } else if (l < 64L) {
                imageData = new ImageData(n2, n, 16, new PaletteData(63488, 2016, 31));
                while (indexIterator.hasNext()) {
                    int n5 = indexIterator.index;
                    int n6 = (sArray[n5] >> 1 & 0x1F) << 10 | (sArray[n5 + 1] & 0x3F) << 5 | sArray[n5 + 2] >> 1 & 0x1F;
                    imageData.setPixel(nArray2[1], nArray2[0], n6);
                }
            } else if (l < 256L) {
                imageData = new ImageData(n2, n, 24, new PaletteData(0xFF0000, 65280, 255));
                while (indexIterator.hasNext()) {
                    int n7 = indexIterator.index;
                    int n8 = (sArray[n7] & 0xFF) << 16 | (sArray[n7 + 1] & 0xFF) << 8 | sArray[n7 + 2] & 0xFF;
                    imageData.setPixel(nArray2[1], nArray2[0], n8);
                }
            } else {
                int n9 = 0;
                while (l >= 256L) {
                    ++n9;
                    l >>= 2;
                }
                imageData = new ImageData(n2, n, 24, new PaletteData(0xFF0000, 65280, 255));
                while (indexIterator.hasNext()) {
                    int n10 = indexIterator.index;
                    int n11 = (sArray[n10] >> n9 & 0xFF) << 16 | (sArray[n10 + 1] >> n9 & 0xFF) << 8 | sArray[n10 + 2] >> n9 & 0xFF;
                    imageData.setPixel(nArray2[1], nArray2[0], n11);
                }
            }
        } else {
            double d = 255.0 / (double)l;
            imageData = new ImageData(n2, n, 8, new PaletteData(255, 255, 255));
            while (indexIterator.hasNext()) {
                int n12 = (int)(d * abstractDataset.getElementDoubleAbs(indexIterator.index));
                imageData.setPixel(nArray2[1], nArray2[0], n12 > 255 ? 255 : n12);
            }
        }
        return imageData;
    }
}

