/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class PositionIterator
extends IndexIterator {
    final int[] shape;
    final int endrank;
    private boolean[] omit;
    private int[] pos;
    private boolean once;

    public PositionIterator(int[] nArray) {
        this(nArray, -1);
    }

    public PositionIterator(int[] nArray, int n) {
        this(nArray, new int[]{n});
    }

    public PositionIterator(int[] nArray, int[] nArray2) {
        int n;
        this.shape = nArray;
        this.endrank = nArray.length - 1;
        this.pos = new int[this.endrank + 1];
        this.omit = new boolean[this.endrank + 1];
        int[] nArray3 = nArray2;
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray3[n3];
            if (n >= 0 && n <= this.endrank) {
                this.omit[n] = true;
            } else if (n > this.endrank) {
                throw new IllegalArgumentException("Specified axis exceeds dataset rank");
            }
            ++n3;
        }
        n = 0;
        while (n <= this.endrank) {
            if (!this.omit[n]) break;
            ++n;
        }
        if (n > this.endrank) {
            this.once = true;
            return;
        }
        if (this.omit[this.endrank]) {
            this.pos[this.endrank] = 0;
            n3 = this.endrank - 1;
            while (n3 >= 0) {
                if (!this.omit[n3]) {
                    int n4 = n3;
                    this.pos[n4] = this.pos[n4] - 1;
                    break;
                }
                --n3;
            }
        } else {
            this.pos[this.endrank] = -1;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.once) {
            this.once = false;
            return true;
        }
        int n = this.endrank;
        while (n >= 0) {
            if (!this.omit[n]) {
                int n2 = n;
                this.pos[n2] = this.pos[n2] + 1;
                if (this.pos[n] >= this.shape[n]) {
                    this.pos[n] = 0;
                } else {
                    return true;
                }
            }
            --n;
        }
        return false;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    public boolean[] getOmit() {
        return this.omit;
    }
}

