/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.data.nexus.extractor.NexusGroupData;
import java.io.Serializable;
import java.util.Arrays;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;

public class Nexus {
    public static int getDType(int n) {
        switch (n) {
            case 6: {
                return 6;
            }
            case 5: {
                return 5;
            }
            case 26: 
            case 27: {
                return 4;
            }
            case 24: 
            case 25: {
                return 3;
            }
            case 22: 
            case 23: {
                return 2;
            }
            case 20: 
            case 21: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported NeXus data type");
    }

    public static int getGroupDataType(int n) {
        switch (n) {
            case 6: {
                return 6;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 26;
            }
            case 3: {
                return 24;
            }
            case 2: {
                return 22;
            }
            case 1: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported dataset type");
    }

    public static int getUnsignedGroupDataType(int n) {
        switch (n) {
            case 4: {
                return 27;
            }
            case 3: {
                return 25;
            }
            case 2: {
                return 23;
            }
            case 1: {
                return 21;
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported dataset type");
    }

    public static AbstractDataset createDataset(NexusGroupData nexusGroupData, boolean bl) {
        AbstractDataset abstractDataset = null;
        switch (nexusGroupData.type) {
            case 6: {
                double[] dArray = (double[])nexusGroupData.getBuffer();
                abstractDataset = new DoubleDataset(Arrays.copyOf(dArray, dArray.length), nexusGroupData.dimensions);
                break;
            }
            case 5: {
                float[] fArray = (float[])nexusGroupData.getBuffer();
                abstractDataset = new FloatDataset(Arrays.copyOf(fArray, fArray.length), nexusGroupData.dimensions);
                break;
            }
            case 26: 
            case 27: {
                long[] lArray = (long[])nexusGroupData.getBuffer();
                abstractDataset = new LongDataset(Arrays.copyOf(lArray, lArray.length), nexusGroupData.dimensions);
                break;
            }
            case 24: 
            case 25: {
                int[] nArray = (int[])nexusGroupData.getBuffer();
                abstractDataset = new IntegerDataset(Arrays.copyOf(nArray, nArray.length), nexusGroupData.dimensions);
                break;
            }
            case 22: 
            case 23: {
                short[] sArray = (short[])nexusGroupData.getBuffer();
                abstractDataset = new ShortDataset(Arrays.copyOf(sArray, sArray.length), nexusGroupData.dimensions);
                break;
            }
            case 20: 
            case 21: {
                byte[] byArray = (byte[])nexusGroupData.getBuffer();
                abstractDataset = new ByteDataset(Arrays.copyOf(byArray, byArray.length), nexusGroupData.dimensions);
            }
        }
        if (!bl) {
            switch (nexusGroupData.type) {
                case 25: {
                    abstractDataset = new LongDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 32);
                    break;
                }
                case 23: {
                    abstractDataset = new IntegerDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 16);
                    break;
                }
                case 21: {
                    abstractDataset = new ShortDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 8);
                }
            }
        }
        return abstractDataset;
    }

    public static NexusGroupData createNexusGroupData(IDataset iDataset) {
        AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDataset);
        return new NexusGroupData(abstractDataset.getShape(), Nexus.getGroupDataType(abstractDataset.getDtype()), (Serializable)abstractDataset.getBuffer());
    }
}

