/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class LongDataset
extends AbstractDataset {
    private static final transient Logger logger = LoggerFactory.getLogger(LongDataset.class);
    protected long[] data;

    @Override
    protected void setData() {
        this.data = (long[])this.odata;
    }

    private static long[] createArray(int n) {
        long[] lArray = null;
        try {
            lArray = new long[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return lArray;
    }

    @Override
    public int getDtype() {
        return 4;
    }

    public LongDataset() {
    }

    public LongDataset(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = LongDataset.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                logger.error("Negative component in shape is not allowed");
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = LongDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = LongDataset.createArray(this.size);
            this.odata = this.data;
        }
    }

    public LongDataset(long[] lArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{lArray.length};
        }
        this.size = LongDataset.calcSize(nArray);
        if (this.size != lArray.length) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = lArray;
        this.odata = lArray;
    }

    public LongDataset(LongDataset longDataset) {
        this(longDataset, false);
    }

    public LongDataset(LongDataset longDataset, boolean bl) {
        Object object;
        Object object2;
        this.size = longDataset.size;
        if (bl) {
            this.shape = longDataset.shape;
            this.dataSize = longDataset.dataSize;
            this.dataShape = longDataset.dataShape;
            this.name = longDataset.name;
            this.metadata = longDataset.metadata;
            this.data = longDataset.data;
            this.odata = longDataset.data;
            return;
        }
        this.shape = (int[])longDataset.shape.clone();
        this.name = new String(longDataset.name);
        if (longDataset.metadata != null) {
            this.metadata = new HashMap();
            object2 = longDataset.metadata.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.metadata.put(object, longDataset.metadata.get(object));
            }
        }
        object = longDataset.data;
        if (longDataset.isContiguous()) {
            this.data = (long[])object.clone();
            this.odata = this.data;
        } else {
            this.data = LongDataset.createArray(this.size);
            this.odata = this.data;
            object2 = longDataset.getIterator();
            int n = 0;
            while (((IndexIterator)object2).hasNext()) {
                this.data[n] = object[((IndexIterator)object2).index];
                ++n;
            }
        }
    }

    public LongDataset(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.metadata = abstractDataset.metadata;
        this.data = LongDataset.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = abstractDataset.getElementLongAbs(indexIterator.index);
            ++n;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        LongDataset longDataset = (LongDataset)object;
        return Arrays.equals(this.data, longDataset.data);
    }

    public static LongDataset createFromObject(Object object) {
        LongDataset longDataset = new LongDataset();
        longDataset.shape = LongDataset.getShapeFromObject(object);
        longDataset.size = LongDataset.calcSize(longDataset.shape);
        longDataset.data = LongDataset.createArray(longDataset.size);
        longDataset.odata = longDataset.data;
        int[] nArray = new int[longDataset.shape.length];
        longDataset.fillData(object, 0, nArray);
        return longDataset;
    }

    public static LongDataset arange(double d) {
        return LongDataset.arange(0.0, d, 1.0);
    }

    public static LongDataset arange(double d, double d2, double d3) {
        int n = LongDataset.calcSteps(d, d2, d3);
        LongDataset longDataset = new LongDataset(n);
        int n2 = 0;
        while (n2 < n) {
            longDataset.data[n2] = (long)(d + (double)n2 * d3);
            ++n2;
        }
        return longDataset;
    }

    public static LongDataset ones(int[] nArray) {
        return new LongDataset(nArray).fill(1);
    }

    @Override
    public LongDataset fill(Object object) {
        long l = LongDataset.toLong(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = l;
        }
        return this;
    }

    public long[] getData() {
        return this.data;
    }

    @Override
    public LongDataset getView() {
        LongDataset longDataset = new LongDataset();
        longDataset.name = new String(this.name);
        longDataset.size = LongDataset.calcSize(this.shape);
        longDataset.shape = (int[])this.shape.clone();
        longDataset.data = this.data;
        longDataset.odata = this.data;
        longDataset.metadata = this.metadata;
        return longDataset;
    }

    public long getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return this.data[n] != 0L;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        return this.data[n];
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        long[] lArray = (long[])object;
        this.data[n] = lArray[n2];
    }

    public void setAbs(long l, int n) {
        this.data[n] = l;
        this.setDirty();
    }

    public long get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        if (n < 0 || n > this.data.length) {
            logger.error("Index given is outside dataset");
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(LongDataset.toLong(object), n);
    }

    public void setItem(long l, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                try {
                    int[] nArray2 = (int[])this.shape.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] >= nArray2[n]) {
                            nArray2[n] = nArray[n] + 1;
                        }
                        ++n;
                    }
                    this.allocateArray(nArray2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            this.setAbs(l, this.get1DIndex(nArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Dimensionalities of requested position, {}, and dataset, {}, are incompatible", (Object)nArray.length, (Object)this.shape.length);
            throw new IllegalArgumentException("Dimensionalities of requested position, " + nArray.length + ", and dataset, " + this.shape.length + ", are incompatible");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error("Index out of bounds - need to make dataset extendible");
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(LongDataset.toLong(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            logger.error("Data buffer in dataset is null");
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = LongDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = LongDataset.calcSize(this.dataShape);
        long[] lArray = LongDataset.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = LongDataset.calcSize(nArray);
        Arrays.fill(lArray, Long.MIN_VALUE);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            lArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = lArray;
        this.odata = lArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = LongDataset.calcSize(nArray);
        long[] lArray = LongDataset.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            lArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = lArray;
        this.odata = lArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public Object getObject(int ... nArray) {
        return new Long(this.get(nArray));
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return (int)this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return (short)this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0L;
    }

    @Override
    public String getString(int ... nArray) {
        return String.format("%d", this.get(nArray));
    }

    @Override
    public LongDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        LongDataset longDataset = new LongDataset(sliceIterator.getSliceShape());
        long[] lArray = longDataset.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            lArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        return longDataset;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        long[] lArray = ((LongDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            lArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public LongDataset setByBoolean(BooleanDataset booleanDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                logger.error("Number of true items in selection does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            long l = LongDataset.toLong(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = l;
            }
        }
        return this;
    }

    @Override
    public LongDataset setByIndex(IntegerDataset integerDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                logger.error("Number of true items in index dataset does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            long l = LongDataset.toLong(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = l;
            }
        }
        return this;
    }

    @Override
    public LongDataset setSlice(int[] nArray, int[] nArray2, int[] nArray3, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            int[] nArray4 = LongDataset.squeezeShape(sliceIterator.getSliceShape(), false);
            if (nArray4 == null) {
                nArray4 = sliceIterator.getSliceShape();
            }
            if (!Arrays.equals(nArray4, abstractDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            try {
                long l = LongDataset.toLong(object);
                SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (long[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = LongDataset.squeezeShape(var5_5.getSliceShape(), false);
        if (var6_6 == null) {
            var6_6 = var5_5.getSliceShape();
        }
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= LongDataset.calcSize(var6_6)) ** GOTO lbl11
        LongDataset.logger.error("destination array is not large enough");
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl11:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl12:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        long[] lArray = (long[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (lArray.length < LongDataset.calcSize(sliceIterator.getSliceShape())) {
            logger.error("destination array is not large enough");
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = lArray[n];
            ++n;
        }
        this.setDirty();
    }

    protected ArrayList<Integer> findPositions(double d) {
        long l = (long)d;
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != l) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMax());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMin());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public LongDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] + abstractDataset.getElementLongAbs(indexIterator2.index);
            }
        } else {
            double d = LongDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (long)((double)this.data[n] + d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] - abstractDataset.getElementLongAbs(indexIterator2.index);
            }
        } else {
            double d = LongDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (long)((double)this.data[n] - d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] * abstractDataset.getElementLongAbs(indexIterator2.index);
            }
        } else {
            double d = LongDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (long)((double)this.data[n] * d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = this.data[n] / abstractDataset.getElementLongAbs(indexIterator2.index);
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0L;
                }
            }
        } else {
            double d = LongDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (long)((double)this.data[n] / d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset ifloor() {
        return this;
    }

    @Override
    public LongDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = this.data[n] % abstractDataset.getElementLongAbs(indexIterator2.index);
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0L;
                }
            }
        } else {
            double d = LongDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (long)((double)this.data[n] % d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d = Math.pow(this.data[indexIterator.index], abstractDataset.getElementDoubleAbs(indexIterator2.index));
                this.data[indexIterator.index] = Double.isInfinite(d) || Double.isNaN(d) ? 0L : (long)d;
            }
        } else {
            double d = LongDataset.toReal(object);
            double d2 = LongDataset.toImag(object);
            IndexIterator indexIterator = this.getIterator();
            if (d2 == 0.0) {
                while (indexIterator.hasNext()) {
                    double d3 = Math.pow(this.data[indexIterator.index], d);
                    this.data[indexIterator.index] = Double.isInfinite(d3) || Double.isNaN(d3) ? 0L : (long)d3;
                }
            } else {
                Complex complex = new Complex(d, d2);
                while (indexIterator.hasNext()) {
                    Complex complex2 = new Complex((double)this.data[indexIterator.index], 0.0);
                    double d4 = complex2.pow(complex).getReal();
                    this.data[indexIterator.index] = Double.isInfinite(d4) || Double.isNaN(d4) ? 0L : (long)d4;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d4 = d3 * d3 - d2;
                double d5 = d + d4;
                d2 = d5 - d - d4;
                d = d5;
            }
        } else {
            double d6 = LongDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            double d7 = 0.0;
            while (indexIterator.hasNext()) {
                double d8 = (double)this.data[indexIterator.index] - d6;
                double d9 = d8 * d8 - d7;
                double d10 = d + d9;
                d7 = d10 - d - d9;
                d = d10;
            }
        }
        return d;
    }
}

