/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import Jama.Matrix;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Test;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DataSet;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;

public class DataSetTest {
    static {
        PySystemState.initialize();
    }

    @Test
    public void testConstructor1() {
        try {
            new DataSet(100, 100, 100);
        }
        catch (Exception exception) {
            Assert.fail((String)"Basic dataset construction failed");
        }
        try {
            new DataSet(1000, 1000, 1000, 1000, 1000);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            new DataSet(1000, 1000, 1000);
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed, this should give an OutOfMemory error");
        }
        try {
            new DataSet(254, 457, 451, 0, 124, 124);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed, this should give an IllegalArgumentException for passing a zero size error");
        }
    }

    @Test
    public void testConstructor2() {
        DataSet dataSet = new DataSet(10000);
        dataSet = DataSet.convertToDataSet(Maths.add((AbstractDataset)dataSet, 5.0));
        Vector<DataSet> vector = new Vector<DataSet>();
        try {
            int n = 0;
            while (n < 1000) {
                vector.add(new DataSet(dataSet.doubleArray()));
                ++n;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong type of error caught");
        }
    }

    @Test
    public void testConstructor3() {
        DataSet dataSet = new DataSet(100, 100);
        dataSet = DataSet.convertToDataSet(Maths.add((AbstractDataset)dataSet, 5.0));
        try {
            new DataSet(1, 0, dataSet.doubleArray());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed, this should give an IllegalArgumentException for passing a zero size error");
        }
        try {
            new DataSet(0, -10, dataSet.doubleArray());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed, this should give an IllegalArgumentException for passing a zero size error");
        }
        try {
            new DataSet(-11, 0, dataSet.doubleArray());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed, this should give an IllegalArgumentException for passing a zero size error");
        }
        try {
            new DataSet(110, 110, dataSet.doubleArray());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed, this should give an IllegalArgumentException for passing a zero size error");
        }
        Vector<DataSet> vector = new Vector<DataSet>();
        try {
            int n = 0;
            while (n < 1000) {
                vector.add(new DataSet(100, 100, dataSet.doubleArray()));
                ++n;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong type of error caught");
        }
    }

    @Test
    public void testConstructor4() {
        DataSet dataSet = new DataSet(100, 100);
        dataSet = DataSet.convertToDataSet(Maths.add((AbstractDataset)dataSet, 1.524));
        Matrix matrix = null;
        Vector<DataSet> vector = new Vector<DataSet>();
        try {
            new DataSet(matrix);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong type of exception raised");
        }
        matrix = new Matrix(dataSet.doubleMatrix());
        try {
            int n = 0;
            while (n < 1000) {
                vector.add(new DataSet(matrix));
                ++n;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong type of error caught");
        }
    }

    @Test
    public void testConstructor5() {
        DataSet dataSet = null;
        try {
            new DataSet(dataSet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong type of exception raised");
        }
        dataSet = new DataSet(1000);
        dataSet.set(23.0, 55);
        dataSet.set(34.0, 105);
        dataSet.set(45.0, 564);
        dataSet.set(56.0, 999);
        DataSet dataSet2 = new DataSet(dataSet);
        int[] nArray = new int[]{23};
        int[] nArray2 = new int[]{23};
        if (Math.abs(dataSet.get(nArray) - dataSet2.get(nArray2)) > 1.0E-6) {
            Assert.fail((String)"content of the dataset is corrupt");
        }
        int[] nArray3 = new int[]{105};
        int[] nArray4 = new int[]{105};
        if (Math.abs(dataSet.get(nArray3) - dataSet2.get(nArray4)) > 1.0E-6) {
            Assert.fail((String)"content of the dataset is corrupt");
        }
        int[] nArray5 = new int[]{564};
        int[] nArray6 = new int[]{564};
        if (Math.abs(dataSet.get(nArray5) - dataSet2.get(nArray6)) > 1.0E-6) {
            Assert.fail((String)"content of the dataset is corrupt");
        }
        int[] nArray7 = new int[]{999};
        int[] nArray8 = new int[]{999};
        if (Math.abs(dataSet.get(nArray7) - dataSet2.get(nArray8)) > 1.0E-6) {
            Assert.fail((String)"content of the dataset is corrupt");
        }
        Vector<DataSet> vector = new Vector<DataSet>();
        try {
            int n = 0;
            while (n < 1000) {
                vector.add(new DataSet(dataSet));
                ++n;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong type of error caught");
        }
    }

    @Test
    public void testDataSize() {
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};
        Assert.assertEquals((long)5L, (long)new DataSet(dArray).getSize());
        AbstractDataset abstractDataset = null;
        try {
            abstractDataset = new DataSet(4, 4, dArray);
        }
        catch (Exception exception) {}
        try {
            abstractDataset.getSize();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception passed");
        }
    }

    @Test
    public void testFill() {
        double d = 123.0;
        int n = 5;
        DataSet dataSet = new DataSet(n);
        dataSet.fill(d);
        int n2 = 0;
        while (n2 < n) {
            Assert.assertEquals((double)d, (double)dataSet.get(n2++), (double)1.0E-8);
        }
    }

    @Test
    public void testArange() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        int n = dArray.length;
        DataSet dataSet = DataSet.arange(6.0);
        DataSet dataSet2 = DataSet.arange(1.0, 7.0);
        DataSet dataSet3 = DataSet.arange(0.0, 3.0, 0.5);
        int n2 = 0;
        while (n2 < n) {
            Assert.assertEquals((String)"DS arange 1", (double)dArray[n2], (double)dataSet.get(n2), (double)1.0E-8);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            Assert.assertEquals((String)"DS arange 2", (double)(dArray[n2] + 1.0), (double)dataSet2.get(n2), (double)1.0E-8);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            Assert.assertEquals((String)"DS arange 3", (double)(0.5 * dArray[n2]), (double)dataSet3.get(n2), (double)1.0E-8);
            ++n2;
        }
    }

    @Test
    public void testLinspace() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        int n = dArray.length;
        DataSet dataSet = DataSet.linspace(0.0, 5.0, 6);
        int n2 = 0;
        while (n2 < n) {
            Assert.assertEquals((String)"DS linspace 1", (double)dArray[n2], (double)dataSet.get(n2), (double)1.0E-8);
            ++n2;
        }
    }

    @Test
    public void testResize() {
        int n;
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DataSet dataSet = DataSet.arange(6.0);
        dataSet.resize(2, 3);
        int n2 = 0;
        while (n2 < 2) {
            n = 0;
            while (n < 3) {
                Assert.assertEquals((String)"DS reshape 1", (double)dArrayArray[n2][n], (double)dataSet.get(n2, n), (double)1.0E-8);
                ++n;
            }
            ++n2;
        }
        dataSet.resize(3, 1);
        n2 = 0;
        while (n2 < 3) {
            Assert.assertEquals((String)"DS reshape 2", (double)n2, (double)dataSet.get(n2, 0), (double)1.0E-8);
            ++n2;
        }
        dataSet.resize(1, 5);
        n2 = 0;
        while (n2 < 5) {
            Assert.assertEquals((String)"DS reshape 3", (double)(n2 < 3 ? n2 : 0), (double)dataSet.get(0, n2++), (double)1.0E-8);
        }
        dataSet.resize(3, 2);
        double[][] dArrayArray2 = new double[][]{{0.0, 1.0}, {2.0, 0.0}, {0.0, 0.0}};
        n = 0;
        while (n < 3) {
            int n3 = 0;
            while (n3 < 2) {
                Assert.assertEquals((String)"DS reshape 4", (double)dArrayArray2[n][n3], (double)dataSet.get(n, n3), (double)1.0E-8);
                ++n3;
            }
            ++n;
        }
    }

    @Test
    public void testReshape() {
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DataSet dataSet = DataSet.arange(6.0);
        DataSet dataSet2 = new DataSet(dArrayArray);
        dataSet.setShape(2, 3);
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < 3) {
                Assert.assertEquals((String)"DS resize 1", (double)dataSet2.get(n, n2), (double)dataSet.get(n, n2++), (double)1.0E-8);
            }
            ++n;
        }
    }

    @Test
    public void testAppend() {
        int n;
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        DataSet dataSet = DataSet.arange(3.0);
        DataSet dataSet2 = DataSet.arange(3.0, 6.0);
        DataSet dataSet3 = dataSet.append(dataSet2, 0);
        int n2 = 0;
        while (n2 < dArray.length) {
            Assert.assertEquals((String)"DS Append 1", (double)dArray[n2], (double)dataSet3.get(n2), (double)1.0E-8);
            ++n2;
        }
        dataSet.setShape(1, 3);
        dataSet2.setShape(1, 3);
        dataSet3 = dataSet.append(dataSet2, 0);
        DataSet dataSet4 = new DataSet(dArray);
        dataSet4.setShape(2, 3);
        int n3 = 0;
        while (n3 < 2) {
            n = 0;
            while (n < 3) {
                Assert.assertEquals((String)"DS Append 2", (double)dataSet4.get(n3, n), (double)dataSet3.get(n3, n++), (double)1.0E-8);
            }
            ++n3;
        }
        dataSet3 = dataSet.append(dataSet2, 1);
        dataSet4 = new DataSet(dArray);
        dataSet4.setShape(1, 6);
        n3 = 0;
        while (n3 < 1) {
            n = 0;
            while (n < 6) {
                Assert.assertEquals((String)"DS Append 3", (double)dataSet4.get(n3, n), (double)dataSet3.get(n3, n++), (double)1.0E-8);
            }
            ++n3;
        }
    }

    @Test
    public void testSlice2() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        DataSet dataSet = DataSet.arange(10.0);
        DataSet dataSet2 = dataSet.getSlice(new int[1], new int[]{3}, null);
        int n = 0;
        while (n < 3) {
            Assert.assertEquals((String)"DS Slice2 1", (double)dArray[n], (double)dataSet2.get(n), (double)1.0E-8);
            ++n;
        }
        double[] dArray2 = new double[]{5.0, 6.0};
        DataSet dataSet3 = dataSet.getSlice(new int[]{5}, new int[]{-3}, null);
        int n2 = 0;
        while (n2 < 2) {
            Assert.assertEquals((String)"DS Slice2 2", (double)dArray2[n2], (double)dataSet3.get(n2), (double)1.0E-8);
            ++n2;
        }
        DataSet dataSet4 = dataSet.getSlice(new int[]{-5}, new int[]{7}, null);
        int n3 = 0;
        while (n3 < 2) {
            Assert.assertEquals((String)"DS Slice2 3", (double)dArray2[n3], (double)dataSet4.get(n3), (double)1.0E-8);
            ++n3;
        }
    }

    @Test
    public void testSlice3() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        DataSet dataSet = DataSet.arange(10.0);
        DataSet dataSet2 = dataSet.getSlice(new int[1], new int[]{3}, new int[]{1});
        int n = 0;
        while (n < 3) {
            Assert.assertEquals((String)"DS Slice3 1", (double)dArray[n], (double)dataSet2.get(n), (double)1.0E-8);
            ++n;
        }
        DataSet dataSet3 = dataSet.getSlice(new int[1], new int[]{6}, new int[]{2});
        int n2 = 0;
        while (n2 < 3) {
            Assert.assertEquals((String)"DS Slice3 2", (double)(2.0 * dArray[n2]), (double)dataSet3.get(n2), (double)1.0E-8);
            ++n2;
        }
        double[] dArray2 = new double[]{3.0, 2.0, 1.0};
        DataSet dataSet4 = dataSet.getSlice(new int[]{3}, new int[1], new int[]{-1});
        int n3 = 0;
        while (n3 < 3) {
            Assert.assertEquals((String)"DS Slice3 3", (double)dArray2[n3], (double)dataSet4.get(n3), (double)1.0E-8);
            ++n3;
        }
        DataSet dataSet5 = dataSet.getSlice(new int[]{-4}, new int[1], new int[]{-2});
        int n4 = 0;
        while (n4 < 3) {
            Assert.assertEquals((String)"DS Slice3 4", (double)(2.0 * dArray2[n4]), (double)dataSet5.get(n4), (double)1.0E-8);
            ++n4;
        }
        double[] dArray3 = new double[]{5.0, 6.0};
        DataSet dataSet6 = dataSet.getSlice(new int[]{5}, new int[]{-3}, new int[]{1});
        int n5 = 0;
        while (n5 < 2) {
            Assert.assertEquals((String)"DS Slice3 5", (double)dArray3[n5], (double)dataSet6.get(n5), (double)1.0E-8);
            ++n5;
        }
        DataSet dataSet7 = dataSet.getSlice(new int[]{-5}, new int[]{7}, new int[]{1});
        int n6 = 0;
        while (n6 < 2) {
            Assert.assertEquals((String)"DS Slice3 6", (double)dArray3[n6], (double)dataSet7.get(n6), (double)1.0E-8);
            ++n6;
        }
    }

    @Test
    public void testGDA2258() {
        double[] dArray = new double[]{283.43, 17.72, 16.23, 16.37, 13.52};
        DataSet dataSet = new DataSet(dArray);
        Assert.assertEquals((double)283.43, (double)dataSet.max().doubleValue(), (double)0.001);
        Assert.assertEquals((long)0L, (long)dataSet.maxPos()[0]);
        Assert.assertEquals((long)4L, (long)dataSet.minPos()[0]);
        double[] dArray2 = new double[]{980.44, 968.79, 1387.0, 1387.0, 1387.0};
        DataSet dataSet2 = new DataSet(dArray2);
        Assert.assertEquals((double)1387.0, (double)dataSet2.max().doubleValue(), (double)0.001);
        Assert.assertEquals((long)2L, (long)dataSet2.maxPos()[0]);
        Assert.assertEquals((long)1L, (long)dataSet2.minPos()[0]);
    }

    @Test
    public void testGDA2257() {
        double[] dArray = new double[]{2.3};
        DataSet dataSet = new DataSet(dArray);
        Assert.assertEquals((double)2.3, (double)dataSet.max().doubleValue(), (double)0.01);
    }

    @Test
    public void testGDA2270() {
        DataSet dataSet = DataSet.arange(10.0);
        Object object = dataSet.getObject(-2);
        Assert.assertEquals((double)8.0, (double)((Double)object), (double)0.0);
        dataSet.set(0.0, -2);
        Assert.assertEquals((double)0.0, (double)dataSet.get(8), (double)0.0);
        dataSet = DataSet.arange(10.0);
        dataSet.setShape(2, 5);
        DataSet dataSet2 = DataSet.arange(5.0, 10.0, 1.0);
        object = dataSet.getSlice((PyObject)new PyInteger(-1));
        int n = 0;
        while (n < dataSet2.getDimensions()[0]) {
            Assert.assertEquals((double)dataSet2.get(n), (double)((DataSet)object).get(n++), (double)0.0);
        }
        dataSet.setSlice((PyObject)new PyInteger(-1), (Object)-2);
        n = 0;
        while (n < dataSet.getDimensions()[1]) {
            Assert.assertEquals((double)-2.0, (double)dataSet.get(-1, n++), (double)0.0);
        }
    }

    @Test
    public void testGDA2271() {
        DataSet dataSet = DataSet.arange(10.0);
        try {
            dataSet.getObject(10);
            throw new Exception("No exception encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong type of exception raised");
        }
        try {
            dataSet.getObject(-11);
            throw new Exception("No exception encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong type of exception raised");
        }
        dataSet.setExtendible(false);
        try {
            dataSet.set(0.0, 11);
            throw new Exception("No exception encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong type of exception raised");
        }
        try {
            dataSet.set(0.0, -11);
            throw new Exception("No exception encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong type of exception raised");
        }
    }

    @Test
    public void testSS492() {
        int n;
        DataSet dataSet = DataSet.arange(10.0);
        dataSet.set(23.0, 15);
        Assert.assertEquals((double)23.0, (double)dataSet.get(15), (double)0.0);
        Assert.assertEquals((long)16L, (long)dataSet.getDimensions()[0]);
        DataSet dataSet2 = DataSet.arange(100.0);
        int[] nArray = new int[]{10, 10};
        dataSet2.setShape(nArray);
        Assert.assertEquals((long)10L, (long)dataSet2.getDimensions()[0]);
        Assert.assertEquals((long)10L, (long)dataSet2.getDimensions()[1]);
        dataSet2.set(new Double(66.6), 20, 20);
        Assert.assertEquals((double)66.6, (double)dataSet2.get(20, 20), (double)0.0);
        int n2 = 0;
        while (n2 < nArray[0]) {
            int n3 = 0;
            while (n3 < nArray[1]) {
                Assert.assertEquals((double)(n2 * 10 + n3), (double)dataSet2.get(n2, n3), (double)0.0);
                ++n3;
            }
            ++n2;
        }
        DataSet dataSet3 = DataSet.arange(1000.0);
        int[] nArray2 = new int[]{10, 10, 10};
        dataSet3.setShape(nArray2);
        Assert.assertEquals((long)10L, (long)dataSet3.getDimensions()[0]);
        Assert.assertEquals((long)10L, (long)dataSet3.getDimensions()[1]);
        Assert.assertEquals((long)10L, (long)dataSet3.getDimensions()[2]);
        dataSet3.set(66.6, 20, 20, 20);
        Assert.assertEquals((double)66.6, (double)dataSet3.get(20, 20, 20), (double)0.0);
        int n4 = 0;
        while (n4 < nArray2[0]) {
            n = 0;
            while (n < nArray2[1]) {
                int n5 = 0;
                while (n5 < nArray2[2]) {
                    Assert.assertEquals((double)(n4 * 100 + n * 10 + n5), (double)dataSet3.get(n4, n, n5), (double)0.0);
                    ++n5;
                }
                ++n;
            }
            ++n4;
        }
        DataSet dataSet4 = DataSet.arange(1.0);
        n = 0;
        while (n < 100) {
            dataSet4.set(n, n);
            Assert.assertEquals((double)((double)n * 1.0), (double)dataSet4.get(n), (double)0.0);
            ++n;
        }
        DataSet dataSet5 = DataSet.arange(1000.0);
        int[] nArray3 = new int[]{10, 10, 10};
        dataSet5.setShape(nArray3);
        int n6 = 0;
        while (n6 < 100) {
            dataSet5.set(n6, 5, n6, 5);
            Assert.assertEquals((double)((double)n6 * 1.0), (double)dataSet5.get(5, n6, 5), (double)0.0);
            ++n6;
        }
    }

    @Test
    public void testSqueeze() {
        DataSet dataSet = DataSet.arange(10.0);
        dataSet.setShape(2, 1, 5);
        dataSet.squeeze();
        Assert.assertEquals((long)2L, (long)dataSet.getDimensions().length);
        Assert.assertEquals((long)2L, (long)dataSet.getDimensions()[0]);
        Assert.assertEquals((long)5L, (long)dataSet.getDimensions()[1]);
    }

    @Test
    public void testTile() {
        DataSet dataSet = DataSet.arange(3.0);
        DataSet dataSet2 = DataSet.convertToDataSet(DatasetUtils.tile(dataSet, 2));
        double[] dArray = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0};
        Assert.assertEquals((long)1L, (long)dataSet2.getDimensions().length);
        Assert.assertEquals((long)6L, (long)dataSet2.getDimensions()[0]);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertEquals((double)dArray[n], (double)((double[])dataSet2.getBuffer())[n], (double)1.0E-6);
            ++n;
        }
        DataSet dataSet3 = DataSet.convertToDataSet(DatasetUtils.tile(dataSet, 1, 2));
        Assert.assertEquals((long)2L, (long)dataSet3.getDimensions().length);
        Assert.assertEquals((long)1L, (long)dataSet3.getDimensions()[0]);
        Assert.assertEquals((long)6L, (long)dataSet3.getDimensions()[1]);
        int n2 = 0;
        while (n2 < dArray.length) {
            Assert.assertEquals((double)dArray[n2], (double)((double[])dataSet3.getBuffer())[n2], (double)1.0E-6);
            ++n2;
        }
        DataSet dataSet4 = DataSet.convertToDataSet(DatasetUtils.tile(dataSet, 2, 1));
        Assert.assertEquals((long)2L, (long)dataSet4.getDimensions().length);
        Assert.assertEquals((long)2L, (long)dataSet4.getDimensions()[0]);
        Assert.assertEquals((long)3L, (long)dataSet4.getDimensions()[1]);
        int n3 = 0;
        while (n3 < dArray.length) {
            Assert.assertEquals((double)dArray[n3], (double)((double[])dataSet4.getBuffer())[n3], (double)1.0E-6);
            ++n3;
        }
        dataSet = DataSet.arange(6.0);
        dataSet.setShape(2, 3);
        DataSet dataSet5 = DataSet.convertToDataSet(DatasetUtils.tile(dataSet, 2));
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)dataSet5.getDimensions().length);
        Assert.assertEquals((long)2L, (long)dataSet5.getDimensions()[0]);
        Assert.assertEquals((long)6L, (long)dataSet5.getDimensions()[1]);
        int n4 = 0;
        while (n4 < dArray2.length) {
            Assert.assertEquals((double)dArray2[n4], (double)((double[])dataSet5.getBuffer())[n4], (double)1.0E-6);
            ++n4;
        }
        DataSet dataSet6 = DataSet.convertToDataSet(DatasetUtils.tile(dataSet, 1, 2));
        Assert.assertEquals((long)2L, (long)dataSet6.getDimensions().length);
        Assert.assertEquals((long)2L, (long)dataSet6.getDimensions()[0]);
        Assert.assertEquals((long)6L, (long)dataSet6.getDimensions()[1]);
        int n5 = 0;
        while (n5 < dArray2.length) {
            Assert.assertEquals((double)dArray2[n5], (double)((double[])dataSet6.getBuffer())[n5], (double)1.0E-6);
            ++n5;
        }
        DataSet dataSet7 = DataSet.convertToDataSet(DatasetUtils.tile(dataSet, 2, 1));
        double[] dArray3 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)dataSet7.getDimensions().length);
        Assert.assertEquals((long)4L, (long)dataSet7.getDimensions()[0]);
        Assert.assertEquals((long)3L, (long)dataSet7.getDimensions()[1]);
        int n6 = 0;
        while (n6 < dArray3.length) {
            Assert.assertEquals((double)dArray3[n6], (double)((double[])dataSet7.getBuffer())[n6], (double)1.0E-6);
            ++n6;
        }
    }

    @Test
    public void testPermuteAxes() {
        int n;
        int n2;
        DataSet dataSet = DataSet.arange(6.0);
        dataSet.setShape(2, 3);
        DataSet dataSet2 = DataSet.convertToDataSet(DatasetUtils.transpose(dataSet, 1, 0));
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        Assert.assertEquals((long)2L, (long)dataSet2.getDimensions().length);
        Assert.assertEquals((long)3L, (long)dataSet2.getDimensions()[0]);
        Assert.assertEquals((long)2L, (long)dataSet2.getDimensions()[1]);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 3) {
                Assert.assertEquals((double)dArrayArray[n3][n4], (double)dataSet2.get(n4, n3), (double)1.0E-6);
                ++n4;
            }
            ++n3;
        }
        dataSet = DataSet.arange(24.0);
        dataSet.setShape(2, 3, 4);
        double[][][] dArrayArray2 = new double[][][]{new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0, 7.0}, {8.0, 9.0, 10.0, 11.0}}, new double[][]{{12.0, 13.0, 14.0, 15.0}, {16.0, 17.0, 18.0, 19.0}, {20.0, 21.0, 22.0, 23.0}}};
        try {
            DataSet dataSet3 = DataSet.convertToDataSet(DatasetUtils.transpose(dataSet, 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            DataSet dataSet4 = DataSet.convertToDataSet(DatasetUtils.transpose(dataSet, 0, -1, 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            DataSet dataSet5 = DataSet.convertToDataSet(DatasetUtils.transpose(dataSet, 0, 1, 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        DataSet dataSet6 = DataSet.convertToDataSet(DatasetUtils.transpose(dataSet, 0, 1, 2));
        Assert.assertEquals((long)3L, (long)dataSet6.getDimensions().length);
        Assert.assertEquals((long)2L, (long)dataSet6.getDimensions()[0]);
        Assert.assertEquals((long)3L, (long)dataSet6.getDimensions()[1]);
        Assert.assertEquals((long)4L, (long)dataSet6.getDimensions()[2]);
        int n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)dataSet6.get(n5, n2, n), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
        dataSet6 = DataSet.convertToDataSet(DatasetUtils.transpose(dataSet, 1, 0, 2));
        Assert.assertEquals((long)3L, (long)dataSet6.getDimensions().length);
        Assert.assertEquals((long)3L, (long)dataSet6.getDimensions()[0]);
        Assert.assertEquals((long)2L, (long)dataSet6.getDimensions()[1]);
        Assert.assertEquals((long)4L, (long)dataSet6.getDimensions()[2]);
        n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)dataSet6.get(n2, n5, n), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
        dataSet6 = DataSet.convertToDataSet(DatasetUtils.transpose(dataSet, 2, 0, 1));
        Assert.assertEquals((long)3L, (long)dataSet6.getDimensions().length);
        Assert.assertEquals((long)4L, (long)dataSet6.getDimensions()[0]);
        Assert.assertEquals((long)2L, (long)dataSet6.getDimensions()[1]);
        Assert.assertEquals((long)3L, (long)dataSet6.getDimensions()[2]);
        n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)dataSet6.get(n, n5, n2), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
    }

    @Test
    public void testRepeat() {
        int n;
        DataSet dataSet = DataSet.arange(6.0);
        dataSet.setShape(2, 3);
        double[] dArray = new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0};
        DataSet dataSet2 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[]{2}, -1));
        Assert.assertEquals((long)1L, (long)dataSet2.getDimensions().length);
        Assert.assertEquals((long)12L, (long)dataSet2.getDimensions()[0]);
        int n2 = 0;
        while (n2 < 12) {
            Assert.assertEquals((double)dArray[n2], (double)dataSet2.get(n2), (double)1.0E-6);
            ++n2;
        }
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 1.0, 1.0, 2.0, 2.0}, {3.0, 3.0, 4.0, 4.0, 5.0, 5.0}};
        DataSet dataSet3 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[]{2}, 1));
        Assert.assertEquals((long)2L, (long)dataSet3.getDimensions().length);
        Assert.assertEquals((long)2L, (long)dataSet3.getDimensions()[0]);
        Assert.assertEquals((long)6L, (long)dataSet3.getDimensions()[1]);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 6) {
                Assert.assertEquals((double)dArrayArray[n3][n4], (double)dataSet3.get(n3, n4), (double)1.0E-6);
                ++n4;
            }
            ++n3;
        }
        double[][] dArrayArray2 = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}, {3.0, 4.0, 5.0}};
        DataSet dataSet4 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[]{2}, 0));
        Assert.assertEquals((long)2L, (long)dataSet4.getDimensions().length);
        Assert.assertEquals((long)4L, (long)dataSet4.getDimensions()[0]);
        Assert.assertEquals((long)3L, (long)dataSet4.getDimensions()[1]);
        int n5 = 0;
        while (n5 < 4) {
            int n6 = 0;
            while (n6 < 3) {
                Assert.assertEquals((double)dArrayArray2[n5][n6], (double)dataSet4.get(n5, n6), (double)1.0E-6);
                ++n6;
            }
            ++n5;
        }
        double[][] dArrayArray3 = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DataSet dataSet5 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[]{2, 1}, 0));
        Assert.assertEquals((long)2L, (long)dataSet5.getDimensions().length);
        Assert.assertEquals((long)3L, (long)dataSet5.getDimensions()[0]);
        Assert.assertEquals((long)3L, (long)dataSet5.getDimensions()[1]);
        int n7 = 0;
        while (n7 < 3) {
            int n8 = 0;
            while (n8 < 3) {
                Assert.assertEquals((double)dArrayArray3[n7][n8], (double)dataSet5.get(n7, n8), (double)1.0E-6);
                ++n8;
            }
            ++n7;
        }
        double[][] dArrayArray4 = new double[][]{{0.0, 1.0, 1.0, 2.0, 2.0, 2.0}, {3.0, 4.0, 4.0, 5.0, 5.0, 5.0}};
        DataSet dataSet6 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[]{1, 2, 3}, 1));
        Assert.assertEquals((long)2L, (long)dataSet6.getDimensions().length);
        Assert.assertEquals((long)2L, (long)dataSet6.getDimensions()[0]);
        Assert.assertEquals((long)6L, (long)dataSet6.getDimensions()[1]);
        int n9 = 0;
        while (n9 < 2) {
            int n10 = 0;
            while (n10 < 6) {
                Assert.assertEquals((double)dArrayArray4[n9][n10], (double)dataSet6.get(n9, n10), (double)1.0E-6);
                ++n10;
            }
            ++n9;
        }
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 2.0, 5.0, 5.0, 5.0};
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[5] = 3;
        DataSet dataSet7 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, nArray, -1));
        Assert.assertEquals((long)1L, (long)dataSet7.getDimensions().length);
        Assert.assertEquals((long)7L, (long)dataSet7.getDimensions()[0]);
        int n11 = 0;
        while (n11 < 7) {
            Assert.assertEquals((double)dArray2[n11], (double)dataSet7.get(n11), (double)1.0E-6);
            ++n11;
        }
        DataSet dataSet8 = DataSet.arange(1024.0);
        dataSet8.set(0, 1024);
        DataSet dataSet9 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet8, new int[]{2}, -1));
        Assert.assertEquals((long)1L, (long)dataSet9.getDimensions().length);
        Assert.assertEquals((long)2050L, (long)dataSet9.getDimensions()[0]);
        int n12 = 0;
        while (n12 < 1024) {
            Assert.assertEquals((double)n12, (double)dataSet9.get(2 * n12), (double)1.0E-6);
            Assert.assertEquals((double)n12, (double)dataSet9.get(2 * n12 + 1), (double)1.0E-6);
            ++n12;
        }
        dataSet8 = DataSet.arange(1024.0);
        dataSet8.setShape(16, 64);
        dataSet8.set(0.0, 0, 64);
        dataSet9 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet8, new int[]{2}, 1));
        Assert.assertEquals((long)2L, (long)dataSet9.getDimensions().length);
        Assert.assertEquals((long)16L, (long)dataSet9.getDimensions()[0]);
        Assert.assertEquals((long)130L, (long)dataSet9.getDimensions()[1]);
        n12 = 0;
        while (n12 < 16) {
            n = 0;
            while (n < 64) {
                Assert.assertEquals((double)(n12 * 64 + n), (double)dataSet9.get(n12, 2 * n), (double)1.0E-6);
                Assert.assertEquals((double)(n12 * 64 + n), (double)dataSet9.get(n12, 2 * n + 1), (double)1.0E-6);
                ++n;
            }
            ++n12;
        }
        dataSet9 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet8, new int[]{2}, 0));
        Assert.assertEquals((long)2L, (long)dataSet9.getDimensions().length);
        Assert.assertEquals((long)32L, (long)dataSet9.getDimensions()[0]);
        Assert.assertEquals((long)65L, (long)dataSet9.getDimensions()[1]);
        n12 = 0;
        while (n12 < 16) {
            n = 0;
            while (n < 64) {
                Assert.assertEquals((double)(n12 * 64 + n), (double)dataSet9.get(2 * n12, n), (double)1.0E-6);
                Assert.assertEquals((double)(n12 * 64 + n), (double)dataSet9.get(2 * n12 + 1, n), (double)1.0E-6);
                ++n;
            }
            ++n12;
        }
        try {
            dataSet7 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[1], 3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            dataSet7 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[]{2, 1}, -1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            dataSet7 = DataSet.convertToDataSet(DatasetUtils.repeat(dataSet, new int[]{-1}, -1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
    }

    @Test
    public void testContents() {
        double[] dArray = new double[]{0.0, 2.0, -12.3};
        double[] dArray2 = new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] dArray3 = new double[]{1.0E14, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        DataSet dataSet = new DataSet(dArray);
        Assert.assertEquals((Object)false, (Object)dataSet.containsNans());
        Assert.assertEquals((Object)false, (Object)dataSet.containsInfs());
        DataSet dataSet2 = new DataSet(dArray2);
        Assert.assertEquals((Object)true, (Object)dataSet2.containsNans());
        Assert.assertEquals((Object)true, (Object)dataSet2.containsInfs());
        Assert.assertEquals((Object)true, (Object)Double.isNaN(dataSet2.min().doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet2.min().doubleValue()));
        Assert.assertEquals((Object)true, (Object)Double.isNaN(dataSet2.max().doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet2.max().doubleValue()));
        DataSet dataSet3 = new DataSet(dArray3);
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet3.min().doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet3.max().doubleValue()));
        dataSet = DataSet.arange(1024.0);
        dataSet.set(3.0, 1024);
        Assert.assertEquals((Object)false, (Object)dataSet.containsNans());
        Assert.assertEquals((Object)false, (Object)dataSet.containsInfs());
    }

    @Test
    public void testAutoAllocation() {
        DataSet dataSet = new DataSet(1);
        int n = 0;
        while (n < 1000) {
            dataSet.set(n, n);
            ++n;
        }
        IndexIterator indexIterator = dataSet.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            if (n2 < 1000) assert ((double)n2 == dataSet.get(indexIterator.index));
            ++n2;
        }
        assert (n2 == 1000);
    }

    @Test
    public void testDiff() {
        DataSet dataSet = DataSet.arange(10.0);
        DataSet dataSet2 = dataSet.diff();
        int n = 0;
        while (n < 9) {
            Assert.assertEquals((double)1.0, (double)dataSet2.get(n++), (double)1.0E-6);
        }
    }

    @Test
    public void testIAdd() {
        DataSet dataSet = DataSet.arange(8.0);
        dataSet.setShape(2, 2, 2);
        DataSet dataSet2 = DataSet.convertToDataSet(Maths.add((AbstractDataset)dataSet, 1));
        dataSet.iadd(dataSet2);
        IndexIterator indexIterator = dataSet.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)((double)indexIterator.index + ((double)indexIterator.index + 1.0)), (double)dataSet.getAbs(indexIterator.index), (double)1.0E-6);
        }
    }

    @Test
    public void testISubtract() {
        DataSet dataSet = DataSet.arange(8.0);
        dataSet.setShape(2, 2, 2);
        DataSet dataSet2 = DataSet.convertToDataSet(Maths.add((AbstractDataset)dataSet, 1));
        dataSet.isubtract(dataSet2);
        IndexIterator indexIterator = dataSet.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)((double)indexIterator.index - ((double)indexIterator.index + 1.0)), (double)dataSet.getAbs(indexIterator.index), (double)1.0E-6);
        }
    }

    @Test
    public void testIMultiply() {
        DataSet dataSet = DataSet.arange(8.0);
        dataSet.setShape(2, 2, 2);
        DataSet dataSet2 = DataSet.convertToDataSet(Maths.add((AbstractDataset)dataSet, 1));
        dataSet.imultiply(dataSet2);
        IndexIterator indexIterator = dataSet.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)((double)indexIterator.index * ((double)indexIterator.index + 1.0)), (double)dataSet.getAbs(indexIterator.index), (double)1.0E-6);
        }
    }

    @Test
    public void testIDivide() {
        DataSet dataSet = DataSet.arange(8.0);
        dataSet.setShape(2, 2, 2);
        DataSet dataSet2 = DataSet.convertToDataSet(Maths.add((AbstractDataset)dataSet, 1));
        dataSet.idivide(dataSet2);
        IndexIterator indexIterator = dataSet.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)((double)indexIterator.index / ((double)indexIterator.index + 1.0)), (double)dataSet.getAbs(indexIterator.index), (double)1.0E-6);
        }
    }
}

