/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class ByteDataset
extends AbstractDataset {
    private static final transient Logger logger = LoggerFactory.getLogger(ByteDataset.class);
    protected byte[] data;

    @Override
    protected void setData() {
        this.data = (byte[])this.odata;
    }

    private static byte[] createArray(int n) {
        byte[] byArray = null;
        try {
            byArray = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return byArray;
    }

    @Override
    public int getDtype() {
        return 1;
    }

    public ByteDataset() {
    }

    public ByteDataset(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = ByteDataset.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                logger.error("Negative component in shape is not allowed");
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = ByteDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = ByteDataset.createArray(this.size);
            this.odata = this.data;
        }
    }

    public ByteDataset(byte[] byArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{byArray.length};
        }
        this.size = ByteDataset.calcSize(nArray);
        if (this.size != byArray.length) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = byArray;
        this.odata = byArray;
    }

    public ByteDataset(ByteDataset byteDataset) {
        this(byteDataset, false);
    }

    public ByteDataset(ByteDataset byteDataset, boolean bl) {
        Object object;
        Object object2;
        this.size = byteDataset.size;
        if (bl) {
            this.shape = byteDataset.shape;
            this.dataSize = byteDataset.dataSize;
            this.dataShape = byteDataset.dataShape;
            this.name = byteDataset.name;
            this.metadata = byteDataset.metadata;
            this.data = byteDataset.data;
            this.odata = byteDataset.data;
            return;
        }
        this.shape = (int[])byteDataset.shape.clone();
        this.name = new String(byteDataset.name);
        if (byteDataset.metadata != null) {
            this.metadata = new HashMap();
            object2 = byteDataset.metadata.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.metadata.put(object, byteDataset.metadata.get(object));
            }
        }
        object = byteDataset.data;
        if (byteDataset.isContiguous()) {
            this.data = (byte[])object.clone();
            this.odata = this.data;
        } else {
            this.data = ByteDataset.createArray(this.size);
            this.odata = this.data;
            object2 = byteDataset.getIterator();
            int n = 0;
            while (((IndexIterator)object2).hasNext()) {
                this.data[n] = object[((IndexIterator)object2).index];
                ++n;
            }
        }
    }

    public ByteDataset(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.metadata = abstractDataset.metadata;
        this.data = ByteDataset.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = (byte)abstractDataset.getElementLongAbs(indexIterator.index);
            ++n;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ByteDataset byteDataset = (ByteDataset)object;
        return Arrays.equals(this.data, byteDataset.data);
    }

    public static ByteDataset createFromObject(Object object) {
        ByteDataset byteDataset = new ByteDataset();
        byteDataset.shape = ByteDataset.getShapeFromObject(object);
        byteDataset.size = ByteDataset.calcSize(byteDataset.shape);
        byteDataset.data = ByteDataset.createArray(byteDataset.size);
        byteDataset.odata = byteDataset.data;
        int[] nArray = new int[byteDataset.shape.length];
        byteDataset.fillData(object, 0, nArray);
        return byteDataset;
    }

    public static ByteDataset arange(double d) {
        return ByteDataset.arange(0.0, d, 1.0);
    }

    public static ByteDataset arange(double d, double d2, double d3) {
        int n = ByteDataset.calcSteps(d, d2, d3);
        ByteDataset byteDataset = new ByteDataset(n);
        int n2 = 0;
        while (n2 < n) {
            byteDataset.data[n2] = (byte)(d + (double)n2 * d3);
            ++n2;
        }
        return byteDataset;
    }

    public static ByteDataset ones(int[] nArray) {
        return new ByteDataset(nArray).fill(1);
    }

    @Override
    public ByteDataset fill(Object object) {
        byte by = (byte)ByteDataset.toLong(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = by;
        }
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public ByteDataset getView() {
        ByteDataset byteDataset = new ByteDataset();
        byteDataset.name = new String(this.name);
        byteDataset.size = ByteDataset.calcSize(this.shape);
        byteDataset.shape = (int[])this.shape.clone();
        byteDataset.data = this.data;
        byteDataset.odata = this.data;
        byteDataset.metadata = this.metadata;
        return byteDataset;
    }

    public byte getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return this.data[n] != 0;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        return this.data[n];
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        byte[] byArray = (byte[])object;
        this.data[n] = byArray[n2];
    }

    public void setAbs(byte by, int n) {
        this.data[n] = by;
        this.setDirty();
    }

    public byte get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        if (n < 0 || n > this.data.length) {
            logger.error("Index given is outside dataset");
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs((byte)ByteDataset.toLong(object), n);
    }

    public void setItem(byte by, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                try {
                    int[] nArray2 = (int[])this.shape.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] >= nArray2[n]) {
                            nArray2[n] = nArray[n] + 1;
                        }
                        ++n;
                    }
                    this.allocateArray(nArray2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            this.setAbs(by, this.get1DIndex(nArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Dimensionalities of requested position, {}, and dataset, {}, are incompatible", (Object)nArray.length, (Object)this.shape.length);
            throw new IllegalArgumentException("Dimensionalities of requested position, " + nArray.length + ", and dataset, " + this.shape.length + ", are incompatible");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error("Index out of bounds - need to make dataset extendible");
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem((byte)ByteDataset.toLong(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            logger.error("Data buffer in dataset is null");
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = ByteDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = ByteDataset.calcSize(this.dataShape);
        byte[] byArray = ByteDataset.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = ByteDataset.calcSize(nArray);
        Arrays.fill(byArray, (byte)-128);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            byArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = byArray;
        this.odata = byArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = ByteDataset.calcSize(nArray);
        byte[] byArray = ByteDataset.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            byArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = byArray;
        this.odata = byArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public Object getObject(int ... nArray) {
        return new Byte(this.get(nArray));
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0;
    }

    @Override
    public String getString(int ... nArray) {
        return String.format("%d", this.get(nArray));
    }

    @Override
    public ByteDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        ByteDataset byteDataset = new ByteDataset(sliceIterator.getSliceShape());
        byte[] byArray = byteDataset.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            byArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        return byteDataset;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        byte[] byArray = ((ByteDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            byArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public ByteDataset setByBoolean(BooleanDataset booleanDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                logger.error("Number of true items in selection does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = (byte)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            byte by = (byte)ByteDataset.toLong(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = by;
            }
        }
        return this;
    }

    @Override
    public ByteDataset setByIndex(IntegerDataset integerDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                logger.error("Number of true items in index dataset does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = (byte)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            byte by = (byte)ByteDataset.toLong(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = by;
            }
        }
        return this;
    }

    @Override
    public ByteDataset setSlice(int[] nArray, int[] nArray2, int[] nArray3, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            int[] nArray4 = ByteDataset.squeezeShape(sliceIterator.getSliceShape(), false);
            if (nArray4 == null) {
                nArray4 = sliceIterator.getSliceShape();
            }
            if (!Arrays.equals(nArray4, abstractDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = (byte)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            try {
                byte by = (byte)ByteDataset.toLong(object);
                SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = by;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (byte[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = ByteDataset.squeezeShape(var5_5.getSliceShape(), false);
        if (var6_6 == null) {
            var6_6 = var5_5.getSliceShape();
        }
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= ByteDataset.calcSize(var6_6)) ** GOTO lbl11
        ByteDataset.logger.error("destination array is not large enough");
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl11:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl12:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        byte[] byArray = (byte[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (byArray.length < ByteDataset.calcSize(sliceIterator.getSliceShape())) {
            logger.error("destination array is not large enough");
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = byArray[n];
            ++n;
        }
        this.setDirty();
    }

    protected ArrayList<Integer> findPositions(double d) {
        byte by = (byte)d;
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != by) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMax());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMin());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public ByteDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (byte)((long)this.data[n] + abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = ByteDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (byte)((double)this.data[n] + d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ByteDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (byte)((long)this.data[n] - abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = ByteDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (byte)((double)this.data[n] - d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ByteDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (byte)((long)this.data[n] * abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = ByteDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (byte)((double)this.data[n] * d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ByteDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = (byte)((long)this.data[n] / abstractDataset.getElementLongAbs(indexIterator2.index));
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0;
                }
            }
        } else {
            double d = ByteDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (byte)((double)this.data[n] / d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ByteDataset ifloor() {
        return this;
    }

    @Override
    public ByteDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = (byte)((long)this.data[n] % abstractDataset.getElementLongAbs(indexIterator2.index));
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0;
                }
            }
        } else {
            double d = ByteDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (byte)((double)this.data[n] % d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ByteDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d = Math.pow(this.data[indexIterator.index], abstractDataset.getElementDoubleAbs(indexIterator2.index));
                this.data[indexIterator.index] = Double.isInfinite(d) || Double.isNaN(d) ? (byte)0 : (byte)d;
            }
        } else {
            double d = ByteDataset.toReal(object);
            double d2 = ByteDataset.toImag(object);
            IndexIterator indexIterator = this.getIterator();
            if (d2 == 0.0) {
                while (indexIterator.hasNext()) {
                    double d3 = Math.pow(this.data[indexIterator.index], d);
                    this.data[indexIterator.index] = Double.isInfinite(d3) || Double.isNaN(d3) ? (byte)0 : (byte)d3;
                }
            } else {
                Complex complex = new Complex(d, d2);
                while (indexIterator.hasNext()) {
                    Complex complex2 = new Complex((double)this.data[indexIterator.index], 0.0);
                    double d4 = complex2.pow(complex).getReal();
                    this.data[indexIterator.index] = Double.isInfinite(d4) || Double.isNaN(d4) ? (byte)0 : (byte)d4;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d4 = d3 * d3 - d2;
                double d5 = d + d4;
                d2 = d5 - d - d4;
                d = d5;
            }
        } else {
            double d6 = ByteDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            double d7 = 0.0;
            while (indexIterator.hasNext()) {
                double d8 = (double)this.data[indexIterator.index] - d6;
                double d9 = d8 * d8 - d7;
                double d10 = d + d9;
                d7 = d10 - d - d9;
                d = d10;
            }
        }
        return d;
    }
}

