/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class BooleanDatasetBase
extends AbstractDataset {
    private static final transient Logger logger = LoggerFactory.getLogger(BooleanDatasetBase.class);
    protected boolean[] data;

    @Override
    protected void setData() {
        this.data = (boolean[])this.odata;
    }

    private static boolean[] createArray(int n) {
        boolean[] blArray = null;
        try {
            blArray = new boolean[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return blArray;
    }

    @Override
    public int getDtype() {
        return 0;
    }

    public BooleanDatasetBase() {
    }

    public BooleanDatasetBase(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = BooleanDatasetBase.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                logger.error("Negative component in shape is not allowed");
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = BooleanDatasetBase.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = BooleanDatasetBase.createArray(this.size);
            this.odata = this.data;
        }
    }

    public BooleanDatasetBase(boolean[] blArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{blArray.length};
        }
        this.size = BooleanDatasetBase.calcSize(nArray);
        if (this.size != blArray.length) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = blArray;
        this.odata = blArray;
    }

    public BooleanDatasetBase(BooleanDatasetBase booleanDatasetBase) {
        this(booleanDatasetBase, false);
    }

    public BooleanDatasetBase(BooleanDatasetBase booleanDatasetBase, boolean bl) {
        Object object;
        Object object2;
        this.size = booleanDatasetBase.size;
        if (bl) {
            this.shape = booleanDatasetBase.shape;
            this.dataSize = booleanDatasetBase.dataSize;
            this.dataShape = booleanDatasetBase.dataShape;
            this.name = booleanDatasetBase.name;
            this.metadata = booleanDatasetBase.metadata;
            this.data = booleanDatasetBase.data;
            this.odata = booleanDatasetBase.data;
            return;
        }
        this.shape = (int[])booleanDatasetBase.shape.clone();
        this.name = new String(booleanDatasetBase.name);
        if (booleanDatasetBase.metadata != null) {
            this.metadata = new HashMap();
            object2 = booleanDatasetBase.metadata.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.metadata.put(object, booleanDatasetBase.metadata.get(object));
            }
        }
        object = booleanDatasetBase.data;
        if (booleanDatasetBase.isContiguous()) {
            this.data = (boolean[])object.clone();
            this.odata = this.data;
        } else {
            this.data = BooleanDatasetBase.createArray(this.size);
            this.odata = this.data;
            object2 = booleanDatasetBase.getIterator();
            int n = 0;
            while (((IndexIterator)object2).hasNext()) {
                this.data[n] = object[((IndexIterator)object2).index];
                ++n;
            }
        }
    }

    public BooleanDatasetBase(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.metadata = abstractDataset.metadata;
        this.data = BooleanDatasetBase.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = abstractDataset.getElementBooleanAbs(indexIterator.index);
            ++n;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BooleanDatasetBase booleanDatasetBase = (BooleanDatasetBase)object;
        return Arrays.equals(this.data, booleanDatasetBase.data);
    }

    public static BooleanDatasetBase createFromObject(Object object) {
        BooleanDatasetBase booleanDatasetBase = new BooleanDatasetBase();
        booleanDatasetBase.shape = BooleanDatasetBase.getShapeFromObject(object);
        booleanDatasetBase.size = BooleanDatasetBase.calcSize(booleanDatasetBase.shape);
        booleanDatasetBase.data = BooleanDatasetBase.createArray(booleanDatasetBase.size);
        booleanDatasetBase.odata = booleanDatasetBase.data;
        int[] nArray = new int[booleanDatasetBase.shape.length];
        booleanDatasetBase.fillData(object, 0, nArray);
        return booleanDatasetBase;
    }

    public static BooleanDatasetBase ones(int[] nArray) {
        return new BooleanDatasetBase(nArray).fill(1);
    }

    @Override
    public BooleanDatasetBase fill(Object object) {
        boolean bl = BooleanDatasetBase.toBoolean(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = bl;
        }
        return this;
    }

    public boolean[] getData() {
        return this.data;
    }

    @Override
    public BooleanDatasetBase getView() {
        BooleanDatasetBase booleanDatasetBase = new BooleanDatasetBase();
        booleanDatasetBase.name = new String(this.name);
        booleanDatasetBase.size = BooleanDatasetBase.calcSize(this.shape);
        booleanDatasetBase.shape = (int[])this.shape.clone();
        booleanDatasetBase.data = this.data;
        booleanDatasetBase.odata = this.data;
        booleanDatasetBase.metadata = this.metadata;
        return booleanDatasetBase;
    }

    public boolean getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return false;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return 0.0;
    }

    @Override
    public long getElementLongAbs(int n) {
        return 0L;
    }

    @Override
    public Object getObjectAbs(int n) {
        return this.data[n];
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        boolean[] blArray = (boolean[])object;
        this.data[n] = blArray[n2];
    }

    public void setAbs(boolean bl, int n) {
        this.data[n] = bl;
        this.setDirty();
    }

    public boolean get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        if (n < 0 || n > this.data.length) {
            logger.error("Index given is outside dataset");
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(BooleanDatasetBase.toBoolean(object), n);
    }

    public void setItem(boolean bl, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                try {
                    int[] nArray2 = (int[])this.shape.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] >= nArray2[n]) {
                            nArray2[n] = nArray[n] + 1;
                        }
                        ++n;
                    }
                    this.allocateArray(nArray2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            this.setAbs(bl, this.get1DIndex(nArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Dimensionalities of requested position, {}, and dataset, {}, are incompatible", (Object)nArray.length, (Object)this.shape.length);
            throw new IllegalArgumentException("Dimensionalities of requested position, " + nArray.length + ", and dataset, " + this.shape.length + ", are incompatible");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error("Index out of bounds - need to make dataset extendible");
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(BooleanDatasetBase.toBoolean(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            logger.error("Data buffer in dataset is null");
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = BooleanDatasetBase.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = BooleanDatasetBase.calcSize(this.dataShape);
        boolean[] blArray = BooleanDatasetBase.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = BooleanDatasetBase.calcSize(nArray);
        Arrays.fill(blArray, Boolean.FALSE);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            blArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = blArray;
        this.odata = blArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = BooleanDatasetBase.calcSize(nArray);
        boolean[] blArray = BooleanDatasetBase.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            blArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = blArray;
        this.odata = blArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public Object getObject(int ... nArray) {
        return new Boolean(this.get(nArray));
    }

    @Override
    public double getDouble(int ... nArray) {
        return 0.0;
    }

    @Override
    public float getFloat(int ... nArray) {
        return 0.0f;
    }

    @Override
    public long getLong(int ... nArray) {
        return 0L;
    }

    @Override
    public int getInt(int ... nArray) {
        return 0;
    }

    @Override
    public short getShort(int ... nArray) {
        return 0;
    }

    @Override
    public byte getByte(int ... nArray) {
        return 0;
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return false;
    }

    @Override
    public String getString(int ... nArray) {
        return String.format("%b", this.get(nArray));
    }

    @Override
    public BooleanDatasetBase getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        BooleanDatasetBase booleanDatasetBase = new BooleanDatasetBase(sliceIterator.getSliceShape());
        boolean[] blArray = booleanDatasetBase.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            blArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        return booleanDatasetBase;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        boolean[] blArray = ((BooleanDatasetBase)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            blArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public BooleanDatasetBase setByBoolean(BooleanDataset booleanDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                logger.error("Number of true items in selection does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = abstractDataset.getElementBooleanAbs(indexIterator.index);
            }
        } else {
            boolean bl = BooleanDatasetBase.toBoolean(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = bl;
            }
        }
        return this;
    }

    @Override
    public BooleanDatasetBase setByIndex(IntegerDataset integerDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                logger.error("Number of true items in index dataset does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = abstractDataset.getElementBooleanAbs(indexIterator.index);
            }
        } else {
            boolean bl = BooleanDatasetBase.toBoolean(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = bl;
            }
        }
        return this;
    }

    @Override
    public BooleanDatasetBase setSlice(int[] nArray, int[] nArray2, int[] nArray3, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            int[] nArray4 = BooleanDatasetBase.squeezeShape(sliceIterator.getSliceShape(), false);
            if (nArray4 == null) {
                nArray4 = sliceIterator.getSliceShape();
            }
            if (!Arrays.equals(nArray4, abstractDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = abstractDataset.getElementBooleanAbs(indexIterator.index);
            }
        } else {
            try {
                boolean bl = BooleanDatasetBase.toBoolean(object);
                SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = bl;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (boolean[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = BooleanDatasetBase.squeezeShape(var5_5.getSliceShape(), false);
        if (var6_6 == null) {
            var6_6 = var5_5.getSliceShape();
        }
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= BooleanDatasetBase.calcSize(var6_6)) ** GOTO lbl11
        BooleanDatasetBase.logger.error("destination array is not large enough");
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl11:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl12:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        boolean[] blArray2 = (boolean[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (blArray2.length < BooleanDatasetBase.calcSize(sliceIterator.getSliceShape())) {
            logger.error("destination array is not large enough");
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = blArray2[n];
            ++n;
        }
        this.setDirty();
    }

    protected ArrayList<Integer> findPositions(double d) {
        boolean bl = d != 0.0;
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != bl) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMax());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMin());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public BooleanDatasetBase iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public BooleanDatasetBase isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public BooleanDatasetBase imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public BooleanDatasetBase idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public BooleanDatasetBase ifloor() {
        return this;
    }

    @Override
    public BooleanDatasetBase iremainder(Object object) {
        return this;
    }

    @Override
    public BooleanDatasetBase ipower(Object object) {
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        return d;
    }
}

