/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils;

import gda.analysis.DataSet;
import gda.analysis.utils.Random;
import org.junit.Assert;
import org.junit.Test;

public class RandomTest {
    private static final String msg = "This test is statistical in nature and can fail. Try re-running.";

    @Test
    public void TestRand() {
        Random.seed(103);
        DataSet dataSet = Random.rand(10000);
        Assert.assertEquals((String)msg, (double)0.5, (double)dataSet.mean(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(0.5 / Math.sqrt(3.0)), (double)dataSet.std(), (double)0.04);
    }

    @Test
    public void TestSeed() {
        Random.seed(103);
        DataSet dataSet = Random.rand(100);
        Random.seed(103);
        DataSet dataSet2 = Random.rand(100);
        int n = 0;
        while (n < 100) {
            Assert.assertEquals((double)dataSet.get(n), (double)dataSet2.get(n++), (double)1.0E-6);
        }
    }

    @Test
    public void TestRandn() {
        Random.seed(103);
        DataSet dataSet = Random.randn(10000);
        Assert.assertEquals((String)msg, (double)0.0, (double)dataSet.mean(), (double)0.04);
        Assert.assertEquals((String)msg, (double)1.0, (double)dataSet.std(), (double)0.04);
    }

    @Test
    public void TestRandInt() {
        Random.seed(104);
        DataSet dataSet = Random.random_integers(13, 27, new int[]{10000});
        Assert.assertEquals((String)msg, (double)20.0, (double)dataSet.mean(), (double)0.07);
        Assert.assertEquals((String)msg, (double)Math.sqrt(18.666666666666668), (double)dataSet.std(), (double)0.07);
        Assert.assertEquals((String)msg, (double)13.0, (double)dataSet.min(), (double)0.0);
        Assert.assertEquals((String)msg, (double)27.0, (double)dataSet.max(), (double)0.0);
        dataSet = Random.randint(2, 8, new int[]{10000});
        Assert.assertEquals((String)msg, (double)2.0, (double)dataSet.min(), (double)0.0);
        Assert.assertEquals((String)msg, (double)7.0, (double)dataSet.max(), (double)0.0);
    }

    @Test
    public void TestExp() {
        Random.seed(103);
        DataSet dataSet = Random.exponential(2.3, 10000);
        Assert.assertEquals((String)msg, (double)2.3, (double)dataSet.mean(), (double)0.11499999999999999);
        Assert.assertEquals((String)msg, (double)2.3, (double)dataSet.std(), (double)0.11499999999999999);
    }

    @Test
    public void TestPoi() {
        Random.seed(103);
        DataSet dataSet = Random.poisson(2.3, 10000);
        Assert.assertEquals((String)msg, (double)2.3, (double)dataSet.mean(), (double)0.11499999999999999);
        Assert.assertEquals((String)msg, (double)Math.sqrt(2.3), (double)dataSet.std(), (double)0.11499999999999999);
    }
}

