/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils;

import gda.analysis.DataSet;
import gda.analysis.functions.IFunction;
import gda.analysis.functions.Parameter;
import gda.analysis.utils.IOptimizer;
import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.random.RandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneticAlg
implements IOptimizer {
    private static final RandomGenerator generator = new JDKRandomGenerator();
    private static final RandomDataImpl prng = new RandomDataImpl(generator);
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlg.class);
    private double qualityFactor = 0.0;

    public GeneticAlg(double d) {
        this.qualityFactor = d;
    }

    public GeneticAlg(double d, Long l) {
        this.qualityFactor = d;
        if (l != null) {
            generator.setSeed(l.longValue());
        }
    }

    @Override
    public void Optimize(DataSet[] dataSetArray, DataSet dataSet, IFunction iFunction) {
        int n = iFunction.getNoOfParameters();
        int n2 = n * 20;
        int n3 = iFunction.getNoOfFunctions();
        double[][] dArray = new double[n2][n + 1];
        double[][] dArray2 = new double[n2][n + 1];
        int n4 = 0;
        while (n4 < n) {
            dArray[0][n4] = iFunction.getParameter(n4).getValue();
            ++n4;
        }
        n4 = 1;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                Parameter parameter = iFunction.getParameter(n5);
                dArray[n4][n5] = prng.nextUniform(parameter.getLowerLimit(), parameter.getUpperLimit());
                ++n5;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            iFunction.setParameterValues(dArray[n4]);
            dArray[n4][n] = iFunction.residual(true, dataSet, dataSetArray);
            if (Double.valueOf(dArray[n4][n]).isNaN()) {
                dArray[n4][n] = Double.MAX_VALUE;
            }
            ++n4;
        }
        double d = Double.MAX_VALUE;
        while (d > this.qualityFactor) {
            int n6;
            double d2 = 0.0;
            double d3 = dArray[0][n];
            int n7 = 0;
            int n8 = 1;
            while (n8 < n2) {
                if (dArray[n8][n] < d3) {
                    d3 = dArray[n8][n];
                    n7 = n8;
                }
                ++n8;
            }
            n8 = 0;
            while (n8 < n) {
                dArray2[0][n8] = dArray[n7][n8];
                ++n8;
            }
            iFunction.setParameterValues(dArray2[0]);
            dArray2[0][n] = iFunction.residual(true, dataSet, dataSetArray);
            n8 = 1;
            while (n8 < n2) {
                n6 = 0;
                int n9 = 0;
                int n10 = prng.nextInt(0, n2 - 1);
                int n11 = prng.nextInt(0, n2 - 1);
                int n12 = prng.nextInt(0, n2 - 1);
                int n13 = prng.nextInt(0, n2 - 1);
                while (Double.valueOf(dArray[n10][n]).isNaN()) {
                    n10 = prng.nextInt(0, n2 - 1);
                }
                while (Double.valueOf(dArray[n11][n]).isNaN()) {
                    n11 = prng.nextInt(0, n2 - 1);
                }
                while (Double.valueOf(dArray[n12][n]).isNaN()) {
                    n12 = prng.nextInt(0, n2 - 1);
                }
                while (Double.valueOf(dArray[n13][n]).isNaN()) {
                    n13 = prng.nextInt(0, n2 - 1);
                }
                n6 = dArray[n10][n] < dArray[n11][n] ? n10 : n11;
                n9 = dArray[n12][n] < dArray[n13][n] ? n12 : n13;
                int n14 = prng.nextInt(0, n3 - 1);
                int n15 = n6;
                int n16 = 0;
                int n17 = 0;
                while (n17 < n3) {
                    if (n17 >= n14) {
                        n15 = n9;
                    }
                    int n18 = iFunction.getFunction(n17).getNoOfParameters();
                    int n19 = 0;
                    while (n19 < n18) {
                        dArray2[n8][n16] = dArray[n15][n16];
                        ++n16;
                        ++n19;
                    }
                    ++n17;
                }
                if (generator.nextDouble() > 0.5) {
                    n10 = prng.nextInt(0, n2 - 1);
                    n11 = prng.nextInt(0, n2 - 1);
                    n17 = 0;
                    while (n17 < n) {
                        dArray2[n8][n17] = dArray2[n8][n17] + (dArray[n10][n17] - dArray[n11][n17]) * 0.5;
                        ++n17;
                    }
                }
                ++n8;
            }
            n8 = 0;
            while (n8 < n2) {
                n6 = 0;
                while (n6 < n) {
                    dArray[n8][n6] = dArray2[n8][n6];
                    Parameter parameter = iFunction.getParameter(n6);
                    if (dArray[n8][n6] > parameter.getUpperLimit()) {
                        dArray[n8][n6] = 2.0 * parameter.getUpperLimit() - dArray[n8][n6];
                    }
                    if (dArray[n8][n6] < parameter.getLowerLimit()) {
                        dArray[n8][n6] = 2.0 * parameter.getLowerLimit() - dArray[n8][n6];
                    }
                    ++n6;
                }
                iFunction.setParameterValues(dArray[n8]);
                dArray[n8][n] = iFunction.residual(true, dataSet, dataSetArray);
                d2 += dArray[n8][n];
                ++n8;
            }
            d2 /= (double)n2;
            d = dArray[0][n];
            n8 = 1;
            while (n8 < n2) {
                if (dArray[n8][n] < d) {
                    d = dArray[0][n];
                }
                ++n8;
            }
            d = Math.abs(d2 - d);
        }
        d = dArray[0][n];
        int n20 = 0;
        int n21 = 1;
        while (n21 < n2) {
            if (dArray[n21][n] < d) {
                d = dArray[0][n];
                n20 = n21;
            }
            ++n21;
        }
        iFunction.setParameterValues(dArray[n20]);
    }
}

