/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io;

import gda.analysis.DataSet;
import gda.analysis.io.RawBinaryLoader;
import gda.analysis.io.RawBinarySaver;
import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class RawBinaryTest {
    static String testScratchDirectoryName = null;
    static String testpath = null;
    static double testValue;
    DataSet data;
    int sizex = 2400;
    int sizey = 2400;
    int range = this.sizex * this.sizey;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)RawBinaryTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void test2DSaveFile() throws ScanFileHolderException {
        String string = "test2DSaveFile.raw";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, this.range, this.range);
        this.data.reshape(this.sizex, this.sizey);
        testValue = this.data.get(10, 10);
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawBinarySaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
        try {
            dataHolder = new RawBinaryLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
            DataSet dataSet = dataHolder.getDataSet(0);
            Assert.assertEquals((long)dataSet.getSize(), (long)this.range);
            Assert.assertEquals((long)dataSet.getDimensions().length, (long)2L);
            Assert.assertEquals((long)dataSet.getDimensions()[0], (long)this.sizey);
            Assert.assertEquals((long)dataSet.getDimensions()[1], (long)this.sizex);
            Assert.assertEquals((double)dataSet.get(this.sizex), (double)2400.0, (double)0.01);
            Assert.assertEquals((double)dataSet.get(10, 10), (double)testValue, (double)0.01);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
    }

    @Test
    public void test1DSaveFile() throws ScanFileHolderException {
        String string = "test1DSaveFile.raw";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, this.range, this.range);
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawBinarySaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
        try {
            dataHolder = new RawBinaryLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
            DataSet dataSet = dataHolder.getDataSet(0);
            Assert.assertEquals((long)dataSet.getSize(), (long)this.range);
            Assert.assertEquals((long)dataSet.getDimensions().length, (long)1L);
            Assert.assertEquals((long)dataSet.getDimensions()[0], (long)this.range);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        String string = "testLoaderFactory.raw";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, this.range, this.range);
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawBinarySaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
        dataHolder = LoaderFactory.getData(String.valueOf(testScratchDirectoryName) + string, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        DataSet dataSet = dataHolder.getDataSet(0);
        Assert.assertEquals((long)dataSet.getSize(), (long)this.range);
        Assert.assertEquals((long)dataSet.getDimensions().length, (long)1L);
        Assert.assertEquals((long)dataSet.getDimensions()[0], (long)this.range);
    }
}

