/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io;

import gda.analysis.io.MARLoader;
import gda.util.TestUtils;
import java.text.DecimalFormat;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class MARImageTest {
    static String TestFileFolder;
    static String testfile1;
    static String testfile2;
    static String testfile3;
    static String testfile4;

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        TestFileFolder = String.valueOf(TestFileFolder) + "MARImageTest/";
        testfile1 = String.valueOf(TestFileFolder) + "in1187_sample1.mccd";
        testfile2 = String.valueOf(TestFileFolder) + "mar225_001.mccd";
        testfile3 = String.valueOf(TestFileFolder) + "mar165_001.mccd";
        testfile4 = String.valueOf(TestFileFolder) + "ins2-foc_MS_2_001.mccd";
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData(testfile1, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        dataHolder = LoaderFactory.getData(testfile2, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        dataHolder = LoaderFactory.getData(testfile3, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        dataHolder = LoaderFactory.getData(testfile4, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void testLoadFile() throws Exception {
        new MARLoader(testfile1).loadFile();
    }

    @Test
    public void testLoadFile2() throws Exception {
        new MARLoader(testfile2).loadFile();
    }

    @Test
    public void testLoadFile3() throws Exception {
        new MARLoader(testfile3).loadFile();
    }

    @Test
    public void testLoadFile4() throws Exception {
        new MARLoader(testfile4).loadFile();
    }

    public void testManyImages() {
        int n = 1;
        DecimalFormat decimalFormat = new DecimalFormat("000");
        String string = String.valueOf(TestFileFolder) + "testa_1_" + decimalFormat.format(n) + ".mccd";
        int n2 = 0;
        while (n2 < 1000) {
            try {
                new MARLoader(string).loadFile();
                System.out.println(n2);
            }
            catch (Exception exception) {
                System.out.print("fell over at " + n2);
                n2 = 100000;
            }
            ++n2;
        }
    }
}

