/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io;

import gda.analysis.DataSet;
import gda.analysis.io.JPEGLoader;
import gda.analysis.io.JPEGSaver;
import gda.analysis.io.JPEGScaledSaver;
import gda.analysis.io.ScanFileHolderException;
import gda.analysis.utils.DatasetMaths;
import gda.util.TestUtils;
import java.io.FileNotFoundException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class JPEGTest {
    static String testScratchDirectoryName = null;
    DataSet data;
    DataHolder dh = new DataHolder();
    DataHolder dhLoad = new DataHolder();
    int sizex = 500;
    int sizey = 500;
    int range = this.sizex * this.sizey;
    double abserr = 2.0;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)JPEGTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    public JPEGTest() {
        this.data = DataSet.arange(this.range);
        this.data.reshape(this.sizex, this.sizey);
        this.dh.addDataset("testing data", this.data);
    }

    @Test
    public void testSaveFile() throws Exception {
        String string = "testSaveFile.jpg";
        DataHolder dataHolder = new DataHolder();
        DataSet dataSet = DataSet.linspace(0.0, 255.0, this.range);
        dataSet.reshape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", dataSet);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        DataSet dataSet2 = dataHolder2.getDataSet(0);
        double[] dArray = dataSet.doubleArray();
        double[] dArray2 = dataSet2.doubleArray();
        Assert.assertEquals((long)dArray.length, (long)dArray2.length);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertEquals((String)("" + n), (double)dArray[n], (double)dArray2[n], (double)2.0);
            ++n;
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        String string = "testLoaderFactory.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, 250000.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = LoaderFactory.getData(String.valueOf(testScratchDirectoryName) + string, null);
        if (dataHolder2 == null || dataHolder2.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void manyImages() throws ScanFileHolderException {
        String string = "manyImages.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, 255.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
    }

    @Test
    public void manyImagesScaled() throws ScanFileHolderException {
        String string = "manyImagesScaled.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, 250000.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
    }

    @Test
    public void compareDataset() throws ScanFileHolderException {
        String string = "compareDataset.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, 255.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        double[] dArray = dataHolder.getDataSet(0).getBuffer();
        double[] dArray2 = dataHolder2.getDataSet(0).getBuffer();
        int[] nArray = dataHolder.getDataSet(0).getShape();
        int n = nArray[0];
        int n2 = nArray[1];
        int[] nArray2 = dataHolder2.getDataSet(0).getShape();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        Assert.assertEquals((long)n, (long)n3);
        Assert.assertEquals((long)n2, (long)n4);
        int n5 = 0;
        while (n5 < n * n2) {
            Assert.assertEquals((double)dArray[n5], (double)dArray2[n5], (double)this.abserr);
            ++n5;
        }
    }

    @Test
    public void compareScaledDataset() throws ScanFileHolderException {
        String string = "compareScaledDataset.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, 250000.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        DataSet dataSet = DatasetMaths.norm(this.data);
        dataSet.imultiply(255);
        double[] dArray = dataSet.getBuffer();
        double[] dArray2 = dataHolder2.getDataSet(0).getBuffer();
        int[] nArray = dataHolder.getDataSet(0).getShape();
        int n = nArray[0];
        int n2 = nArray[1];
        int[] nArray2 = dataHolder2.getDataSet(0).getShape();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        Assert.assertEquals((long)n, (long)n3);
        Assert.assertEquals((long)n2, (long)n4);
        int n5 = 0;
        while (n5 < n * n2) {
            Assert.assertEquals((double)Math.floor(dArray[n5]), (double)dArray2[n5], (double)this.abserr);
            ++n5;
        }
    }

    @Test
    public void noEnding() throws Exception {
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, 250000.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding.jpg").saveFile(dataHolder);
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + "noEnding").loadFile();
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding1").saveFile(this.dh);
    }

    @Test
    public void incorrectEnding() throws Exception {
        String string = "incorrectEnding.txt";
        String string2 = "incorrectEnding1.txt";
        this.data = DataSet.linspace(0.0, 255.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + string2).saveFile(dataHolder);
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string2).loadFile();
    }

    @Test
    public void testNoFile() throws ScanFileHolderException {
        block2: {
            try {
                this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + "NoFile.jpeg").loadFile();
            }
            catch (ScanFileHolderException scanFileHolderException) {
                if (scanFileHolderException.getCause() instanceof FileNotFoundException) break block2;
                throw scanFileHolderException;
            }
        }
    }
}

