/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io;

import gda.analysis.io.CBFLoader;
import gda.util.TestUtils;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class CBFLoaderTest {
    static String testpath = null;
    static String TestFileFolder;
    static String testfile1;

    static {
        testfile1 = null;
    }

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        if ((testpath = (TestFileFolder = String.valueOf(TestFileFolder) + "CBFLoaderTest/")).matches("^/[a-zA-Z]:.*")) {
            testpath = testpath.substring(1);
        }
    }

    @Test
    public void testExistingFile() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001.cbf").loadFile();
    }

    @Test
    public void testExampleFile1() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "adscconverted_flat_orig.cbf").loadFile();
    }

    @Test
    public void testExampleFile2() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "converted_flat_orig.cbf").loadFile();
    }

    @Test
    public void testExampleFile3() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "mb_LP_1_001_orig.cbf").loadFile();
    }

    @Test
    public void testExampleFile4() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_xReverse.cbf").loadFile();
    }

    @Test
    public void testExampleFile5() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_yReverse.cbf").loadFile();
    }

    @Test
    public void testExampleFile6() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_bothReverse.cbf").loadFile();
    }

    @Test
    public void testExampleFile7() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_transpose.cbf").loadFile();
    }

    @Test
    public void testExampleFile8() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "xtal5e_1_0010.cbf").loadFile();
    }

    @Test
    public void testExampleFile9() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "insulin_pilatus6mconverted_orig.cbf").loadFile();
    }

    @Test
    public void testLoaderFactory() throws Exception {
        if (LoaderFactory.getData(String.valueOf(testpath) + "F6_1_001_bothReverse.cbf", null) == null) {
            throw new Exception();
        }
        if (LoaderFactory.getData(String.valueOf(testpath) + "xtal5e_1_0010.cbf", null) == null) {
            throw new Exception();
        }
        if (LoaderFactory.getData(String.valueOf(testpath) + "insulin_pilatus6mconverted_orig.cbf", null) == null) {
            throw new Exception();
        }
    }
}

