/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import java.util.ArrayList;
import java.util.List;

public class Integrate2D
implements IDataSetFunction {
    int sx;
    int sy;
    int ex;
    int ey;
    boolean full = false;

    public Integrate2D() {
        this.full = true;
    }

    public Integrate2D(int n, int n2, int n3, int n4) {
        this.sx = n;
        this.sy = n2;
        this.ex = n3;
        this.ey = n4;
    }

    @Override
    public List<DataSet> execute(DataSet dataSet) {
        int[] nArray = dataSet.getDimensions();
        if (nArray.length != 2) {
            return null;
        }
        if (this.full) {
            this.sx = 0;
            this.sy = 0;
            this.ex = nArray[1] - 1;
            this.ey = nArray[0] - 1;
        }
        if (this.sx < 0) {
            this.sx = 0;
        }
        if (this.sx >= nArray[1]) {
            this.sx = nArray[1] - 1;
        }
        if (this.ex < 0) {
            this.ex = 0;
        }
        if (this.ex >= nArray[1]) {
            this.ex = nArray[1] - 1;
        }
        if (this.sy < 0) {
            this.sy = 0;
        }
        if (this.sy >= nArray[0]) {
            this.sy = nArray[0] - 1;
        }
        if (this.ey < 0) {
            this.ey = 0;
        }
        if (this.ey >= nArray[0]) {
            this.ey = nArray[0] - 1;
        }
        int n = this.ex - this.sx + 1;
        int n2 = this.ey - this.sy + 1;
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        DataSet dataSet2 = new DataSet(n);
        DataSet dataSet3 = new DataSet(n2);
        double[] dArray = dataSet2.getBuffer();
        double[] dArray2 = dataSet3.getBuffer();
        int n3 = 0;
        while (n3 < n2) {
            double d = 0.0;
            int n4 = 0;
            while (n4 < n) {
                double d2 = dataSet.get(n3 + this.sy, n4 + this.sx);
                d += d2;
                int n5 = n4++;
                dArray[n5] = dArray[n5] + d2;
            }
            dArray2[n3] = d;
            ++n3;
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        arrayList.add(dataSet3);
        arrayList.add(dataSet2);
        return arrayList;
    }
}

