/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class Histogram
implements IDataSetFunction {
    private int numBuckets;
    private boolean overwriteMinMax = false;
    private boolean ignoreOutliers = true;
    private double min;
    private double max;

    public Histogram(int n) {
        this.numBuckets = n;
        this.overwriteMinMax = false;
        this.ignoreOutliers = true;
    }

    public Histogram(int n, double d, double d2) {
        this(n);
        this.overwriteMinMax = true;
        this.min = d;
        this.max = d2;
    }

    public Histogram(int n, double d, double d2, boolean bl) {
        this(n, d, d2);
        this.ignoreOutliers = bl;
    }

    @Override
    public List<DataSet> execute(DataSet dataSet) {
        DataSet dataSet2 = DataSet.zeros(this.numBuckets);
        double[] dArray = dataSet2.getData();
        double d = dataSet.max();
        double d2 = dataSet.min();
        if (this.overwriteMinMax) {
            d = this.max;
            d2 = this.min;
        }
        double d3 = (d - d2) / (double)(this.numBuckets - 1);
        IndexIterator indexIterator = dataSet.getIterator();
        while (indexIterator.hasNext()) {
            int n;
            boolean bl = true;
            double d4 = dataSet.getAbs(indexIterator.index);
            if (d4 < d2 || d4 > d) {
                if (!this.ignoreOutliers) {
                    d4 = Math.min(d4, d);
                    d4 = Math.max(d4, d2);
                } else {
                    bl = false;
                }
            }
            if (!bl) continue;
            int n2 = n = (int)((d4 - d2) / d3);
            dArray[n2] = dArray[n2] + 1.0;
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        arrayList.add(dataSet2);
        return arrayList;
    }

    public void setMin(double d) {
        this.min = d;
    }

    public void setMax(double d) {
        this.max = d;
    }

    public void setOverwriteMinMax(boolean bl) {
        this.overwriteMinMax = bl;
    }

    public void setIgnoreOutliers(boolean bl) {
        this.ignoreOutliers = bl;
    }
}

