/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.TerminalPrinter;
import gda.analysis.functions.AFunction;
import gda.analysis.functions.Parameter;

public class StraightLine
extends AFunction {
    private static String cname = "Linear";
    double a;
    double b;

    public StraightLine() {
        super(2);
        this.name = cname;
    }

    public StraightLine(Parameter[] parameterArray) {
        super(parameterArray);
        this.name = cname;
    }

    public StraightLine(double d, double d2, double d3, double d4) {
        super(2);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(0).setValue((d + d2) / 2.0);
        this.getParameter(1).setLowerLimit(d3);
        this.getParameter(1).setUpperLimit(d4);
        this.getParameter(1).setValue((d3 + d4) / 2.0);
        this.name = cname;
    }

    private void calcCachedParameters() {
        this.a = this.getParameterValue(0);
        this.b = this.getParameterValue(1);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        return this.a * d + this.b;
    }

    @Override
    public void disp() {
        String string = String.format("M Has Value %f within the bounds [%f,%f]", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("C Has Value %f within the bounds [%f,%f]", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit());
        TerminalPrinter.print(string);
    }

    @Override
    public double partialDeriv(int n, double ... dArray) {
        switch (n) {
            case 0: {
                return dArray[0];
            }
            case 1: {
                return 1.0;
            }
        }
        throw new IndexOutOfBoundsException("Parameter index is out of bounds");
    }
}

