/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis;

import gda.analysis.DataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class IndexIteratorTest {
    static final double max = 1000.0;

    @Test
    public void testIterations() {
        int n = 1024;
        DataSet dataSet = DataSet.arange(n);
        System.out.println("Size: " + n);
        this.testDataSet(dataSet);
        dataSet = DataSet.arange(n);
        dataSet.reshape(16, n / 16);
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testDataSet(dataSet);
        dataSet = DataSet.arange(n);
        dataSet.reshape(n / 32, 32);
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testDataSet(dataSet);
        dataSet = DataSet.arange(n);
        dataSet.reshape(16, 8, n / 128);
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testDataSet(dataSet);
        dataSet = DataSet.arange(n);
        dataSet.reshape(n / 128, 16, 8);
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testDataSet(dataSet);
    }

    private void testDataSet(DataSet dataSet) {
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)dArray[indexIterator.index], (double)(1.0E-5 * (double)n));
            ++n;
        }
    }

    private void testExpandedDataSet(DataSet dataSet, int n, int n2) {
        IndexIterator indexIterator = dataSet.getIterator(true);
        double[] dArray = dataSet.getBuffer();
        int[] nArray = indexIterator.getPos();
        int n3 = 0;
        while (indexIterator.hasNext()) {
            if (nArray[n] == n2) {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray)), (double)0.0, (double)dArray[indexIterator.index], (double)0.0);
                --n3;
            } else {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray)), (double)n3, (double)dArray[indexIterator.index], (double)(1.0E-5 * (double)n3));
            }
            ++n3;
        }
    }

    @Test
    public void testExpandedIterations() {
        int n;
        int n2;
        int n3 = 1024;
        System.out.println("Size: " + n3);
        DataSet dataSet = DataSet.arange(n3);
        dataSet.set(0, n3);
        System.out.println(" New size: " + dataSet.getSize());
        this.testExpandedDataSet(dataSet, 0, n3);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(16, n3 / 16);
        int n4 = 0;
        int n5 = dataSet.getDimensions()[1];
        while (n4 < n5) {
            dataSet.set(0, 16, n4++);
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testExpandedDataSet(dataSet, 0, 16);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(n3 / 32, 32);
        n4 = 0;
        n5 = dataSet.getDimensions()[0];
        while (n4 < n5) {
            dataSet.set(0, n4++, 32);
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testExpandedDataSet(dataSet, 1, 32);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(16, 8, n3 / 128);
        n4 = 0;
        n5 = dataSet.getDimensions()[1];
        while (n4 < n5) {
            n2 = 0;
            n = dataSet.getDimensions()[2];
            while (n2 < n) {
                dataSet.set(0, 16, n4, n2++);
            }
            ++n4;
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testExpandedDataSet(dataSet, 0, 16);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(n3 / 128, 16, 8);
        n4 = 0;
        n5 = dataSet.getDimensions()[0];
        while (n4 < n5) {
            n2 = 0;
            n = dataSet.getDimensions()[1];
            while (n2 < n) {
                dataSet.set(0, n4, n2++, 8);
            }
            ++n4;
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testExpandedDataSet(dataSet, 2, 8);
    }

    private DataSet oldSlice(DataSet dataSet, SliceIterator sliceIterator) {
        int[] nArray = sliceIterator.getSliceShape();
        int n = nArray.length;
        int[] nArray2 = sliceIterator.getStart();
        int[] nArray3 = sliceIterator.getStep();
        DataSet dataSet2 = DataSet.zeros(nArray);
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray4[n2] = nArray2[n2];
            nArray5[n2] = 0;
            ++n2;
        }
        block1: do {
            dataSet2.set(dataSet.get(nArray4), nArray5);
            n2 = n - 1;
            while (n2 >= 0) {
                int n3 = n2;
                nArray4[n3] = nArray4[n3] + nArray3[n2];
                int n4 = n2;
                nArray5[n4] = nArray5[n4] + 1;
                if (nArray5[n2] < nArray[n2]) continue block1;
                nArray4[n2] = nArray2[n2];
                nArray5[n2] = 0;
                --n2;
            }
        } while (n2 != -1);
        return dataSet2;
    }

    private void testSlicedDataSet(DataSet dataSet, int n, int n2, int n3, int n4) {
        long l;
        int n5 = dataSet.getRank();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        Arrays.fill(nArray, 1);
        while (n4 > n5) {
            n4 -= n5;
        }
        if (n4 < 0) {
            n4 += n5;
        }
        nArray[n4] = n3;
        while (n2 > n5) {
            n2 -= n5;
        }
        if (n2 < 0) {
            n2 += n5;
        }
        nArray2[n2] = n;
        int n6 = 7;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        DataSet dataSet2 = null;
        SliceIterator sliceIterator = (SliceIterator)dataSet.getSliceIterator(nArray2, null, nArray);
        arrayList.clear();
        int n7 = 0;
        while (n7 < n6) {
            l = System.nanoTime();
            dataSet2 = this.oldSlice(dataSet, sliceIterator);
            arrayList.add(System.nanoTime() - l);
            ++n7;
        }
        Collections.sort(arrayList);
        System.out.println("  Sliced shape: " + Arrays.toString(dataSet2.getDimensions()));
        System.out.println(String.format("    old  %5.2fus", (double)((Long)arrayList.get(0)).longValue() * 0.001));
        double[] dArray = dataSet2.getBuffer();
        DataSet dataSet3 = null;
        arrayList.clear();
        int n8 = 0;
        while (n8 < n6) {
            l = System.nanoTime();
            dataSet3 = dataSet.getSlice(nArray2, null, nArray);
            arrayList.add(System.nanoTime() - l);
            ++n8;
        }
        Collections.sort(arrayList);
        System.out.println(String.format("    iter %5.2fus", (double)((Long)arrayList.get(0)).longValue() * 0.001));
        double[] dArray2 = dataSet3.getBuffer();
        int n9 = 0;
        while (n9 < dArray.length) {
            Assert.assertEquals((double)dArray[n9], (double)dArray2[n9], (double)(1.0E-5 * dArray[n9]));
            ++n9;
        }
    }

    @Test
    public void testSliceIteration() {
        int n = 60;
        System.out.println(" Size: " + n);
        DataSet dataSet = DataSet.arange(n);
        this.testSlicedDataSet(dataSet, 0, 0, 3, 0);
        this.testSlicedDataSet(dataSet, 0, 0, 62, 0);
        this.testSlicedDataSet(dataSet, 23, 0, 3, 0);
        this.testSlicedDataSet(dataSet, 23, 0, 62, 0);
        dataSet = DataSet.arange(n);
        dataSet.reshape(n / 15, 15);
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testSlicedDataSet(dataSet, 0, 0, 3, 0);
        this.testSlicedDataSet(dataSet, 0, 0, 3, 1);
        this.testSlicedDataSet(dataSet, 2, 0, 3, 0);
        this.testSlicedDataSet(dataSet, 2, 0, 3, 1);
        this.testSlicedDataSet(dataSet, 3, 1, 3, 0);
        this.testSlicedDataSet(dataSet, 3, 1, 3, 1);
        this.testSlicedDataSet(dataSet, 0, 0, 4, 0);
        this.testSlicedDataSet(dataSet, 0, 0, 4, 1);
        this.testSlicedDataSet(dataSet, 2, 0, 4, 0);
        this.testSlicedDataSet(dataSet, 2, 0, 4, 1);
        this.testSlicedDataSet(dataSet, 3, 1, 4, 0);
        this.testSlicedDataSet(dataSet, 3, 1, 4, 1);
        this.testSlicedDataSet(dataSet, 0, 0, -1, 0);
        this.testSlicedDataSet(dataSet, 0, 0, -1, 1);
        this.testSlicedDataSet(dataSet, 2, 0, -1, 0);
        this.testSlicedDataSet(dataSet, 2, 0, -1, 1);
        this.testSlicedDataSet(dataSet, 3, 1, -1, 0);
        this.testSlicedDataSet(dataSet, 3, 1, -1, 1);
        this.testSlicedDataSet(dataSet, 0, 0, -2, 0);
        this.testSlicedDataSet(dataSet, 0, 0, -2, 1);
        this.testSlicedDataSet(dataSet, 2, 0, -2, 0);
        this.testSlicedDataSet(dataSet, 2, 0, -2, 1);
        this.testSlicedDataSet(dataSet, 3, 1, -2, 0);
        this.testSlicedDataSet(dataSet, 3, 1, -2, 1);
        this.testSlicedDataSet(dataSet, 0, 0, -3, 0);
        this.testSlicedDataSet(dataSet, 0, 0, -3, 1);
        this.testSlicedDataSet(dataSet, 2, 0, -3, 0);
        this.testSlicedDataSet(dataSet, 2, 0, -3, 1);
        this.testSlicedDataSet(dataSet, 3, 1, -3, 0);
        this.testSlicedDataSet(dataSet, 3, 1, -3, 1);
        dataSet = DataSet.arange(n);
        dataSet.reshape(n / 10, 2, 5);
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testSlicedDataSet(dataSet, 0, 0, 3, 0);
        this.testSlicedDataSet(dataSet, 0, 0, 3, 1);
        this.testSlicedDataSet(dataSet, 0, 0, 3, 2);
        this.testSlicedDataSet(dataSet, 3, 0, 3, 0);
        this.testSlicedDataSet(dataSet, 3, 0, 3, 1);
        this.testSlicedDataSet(dataSet, 3, 0, 3, 2);
        this.testSlicedDataSet(dataSet, 1, 1, 3, 0);
        this.testSlicedDataSet(dataSet, 1, 1, 3, 1);
        this.testSlicedDataSet(dataSet, 1, 1, 3, 2);
        this.testSlicedDataSet(dataSet, 2, 2, 3, 0);
        this.testSlicedDataSet(dataSet, 2, 2, 3, 1);
        this.testSlicedDataSet(dataSet, 2, 2, 3, 2);
        this.testSlicedDataSet(dataSet, 0, 0, 4, 0);
        this.testSlicedDataSet(dataSet, 0, 0, 4, 1);
        this.testSlicedDataSet(dataSet, 0, 0, 4, 2);
        this.testSlicedDataSet(dataSet, 3, 0, 4, 0);
        this.testSlicedDataSet(dataSet, 3, 0, 4, 1);
        this.testSlicedDataSet(dataSet, 3, 0, 4, 2);
        this.testSlicedDataSet(dataSet, 1, 1, 4, 0);
        this.testSlicedDataSet(dataSet, 1, 1, 4, 1);
        this.testSlicedDataSet(dataSet, 1, 1, 4, 2);
        this.testSlicedDataSet(dataSet, 2, 2, 4, 0);
        this.testSlicedDataSet(dataSet, 2, 2, 4, 1);
        this.testSlicedDataSet(dataSet, 2, 2, 4, 2);
        this.testSlicedDataSet(dataSet, 0, 0, -1, 0);
        this.testSlicedDataSet(dataSet, 0, 0, -1, 1);
        this.testSlicedDataSet(dataSet, 0, 0, -1, 2);
        this.testSlicedDataSet(dataSet, 3, 0, -1, 0);
        this.testSlicedDataSet(dataSet, 3, 0, -1, 1);
        this.testSlicedDataSet(dataSet, 3, 0, -1, 2);
        this.testSlicedDataSet(dataSet, 1, 1, -1, 0);
        this.testSlicedDataSet(dataSet, 1, 1, -1, 1);
        this.testSlicedDataSet(dataSet, 1, 1, -1, 2);
        this.testSlicedDataSet(dataSet, 2, 2, -1, 0);
        this.testSlicedDataSet(dataSet, 2, 2, -1, 1);
        this.testSlicedDataSet(dataSet, 2, 2, -1, 2);
        this.testSlicedDataSet(dataSet, 0, 0, -2, 0);
        this.testSlicedDataSet(dataSet, 0, 0, -2, 1);
        this.testSlicedDataSet(dataSet, 0, 0, -2, 2);
        this.testSlicedDataSet(dataSet, 3, 0, -2, 0);
        this.testSlicedDataSet(dataSet, 3, 0, -2, 1);
        this.testSlicedDataSet(dataSet, 3, 0, -2, 2);
        this.testSlicedDataSet(dataSet, 1, 1, -2, 0);
        this.testSlicedDataSet(dataSet, 1, 1, -2, 1);
        this.testSlicedDataSet(dataSet, 1, 1, -2, 2);
        this.testSlicedDataSet(dataSet, 2, 2, -2, 0);
        this.testSlicedDataSet(dataSet, 2, 2, -2, 1);
        this.testSlicedDataSet(dataSet, 2, 2, -2, 2);
        this.testSlicedDataSet(dataSet, 0, 0, -3, 0);
        this.testSlicedDataSet(dataSet, 0, 0, -3, 1);
        this.testSlicedDataSet(dataSet, 0, 0, -3, 2);
        this.testSlicedDataSet(dataSet, 3, 0, -3, 0);
        this.testSlicedDataSet(dataSet, 3, 0, -3, 1);
        this.testSlicedDataSet(dataSet, 3, 0, -3, 2);
        this.testSlicedDataSet(dataSet, 1, 1, -3, 0);
        this.testSlicedDataSet(dataSet, 1, 1, -3, 1);
        this.testSlicedDataSet(dataSet, 1, 1, -3, 2);
        this.testSlicedDataSet(dataSet, 2, 2, -3, 0);
        this.testSlicedDataSet(dataSet, 2, 2, -3, 1);
        this.testSlicedDataSet(dataSet, 2, 2, -3, 2);
    }

    private int get1DIndex(int[] nArray, int[] nArray2) {
        int n = nArray2.length;
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < n) {
            n2 = n2 * nArray2[n3] + nArray[n3];
            ++n3;
        }
        return n2;
    }

    public int[] getNDPosition(int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = n;
        int n4 = n2 - 1;
        while (n4 > 0) {
            nArray2[n4] = n3 % nArray[n4];
            n3 /= nArray[n4];
            --n4;
        }
        nArray2[0] = n3;
        return nArray2;
    }

    private void testSlicedExpandedDataSet(DataSet dataSet, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = dataSet.getRank();
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n7];
        Arrays.fill(nArray2, 1);
        while (n6 > n7) {
            n6 -= n7;
        }
        if (n6 < 0) {
            n6 += n7;
        }
        nArray2[n6] = n5;
        while (n4 > n7) {
            n4 -= n7;
        }
        if (n4 < 0) {
            n4 += n7;
        }
        nArray3[n4] = n3;
        SliceIterator sliceIterator = (SliceIterator)dataSet.getSliceIterator((int[])nArray3.clone(), null, nArray2);
        int[] nArray4 = sliceIterator.getPos();
        int[] nArray5 = sliceIterator.getSliceShape();
        nArray5 = this.getSliceShape(nArray, nArray3, nArray2);
        double[] dArray = dataSet.getBuffer();
        int n8 = 0;
        while (sliceIterator.hasNext()) {
            if (nArray4[n] == n2) {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray4)), (double)0.0, (double)dArray[sliceIterator.index], (double)0.0);
                --n8;
            } else {
                int[] nArray6 = this.getNDPosition(n8, nArray5);
                int n9 = n6;
                nArray6[n9] = nArray6[n9] * n5;
                if (nArray6[n6] >= nArray[n6]) {
                    nArray6[n6] = 0;
                    if (n6 > 0) {
                        int n10 = n6 - 1;
                        nArray6[n10] = nArray6[n10] + 1;
                    }
                }
                int n11 = n4;
                nArray6[n11] = nArray6[n11] + n3;
                int n12 = n4;
                int n13 = nArray6[n12] - nArray[n12];
                while (n13 >= 0 && n12 > 0) {
                    nArray6[n12] = n13;
                    if (n12 == n4) {
                        int n14 = n12;
                        nArray6[n14] = nArray6[n14] + n3;
                    }
                    if (n12 - 1 == n6) {
                        int n15 = n12 - 1;
                        nArray6[n15] = nArray6[n15] + n5;
                    } else {
                        int n16 = n12 - 1;
                        nArray6[n16] = nArray6[n16] + 1;
                    }
                    n13 = nArray6[--n12] - nArray[n12];
                }
                int n17 = this.get1DIndex(nArray6, nArray);
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray4)), (double)n17, (double)dArray[sliceIterator.index], (double)(1.0E-5 * (double)n8));
            }
            ++n8;
        }
    }

    private int[] getSliceShape(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            if (nArray2[n2] < 0) {
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + nArray[n2];
            }
            if (nArray2[n2] < 0) {
                int n4 = nArray2[n2] = nArray3[n2] > 0 ? 0 : -1;
            }
            if (nArray2[n2] > nArray[n2]) {
                nArray2[n2] = nArray3[n2] > 0 ? nArray[n2] : nArray[n2] - 1;
            }
            int n5 = nArray3[n2] > 0 ? nArray[n2] : -1;
            nArray4[n2] = nArray3[n2] > 0 ? (n5 - nArray2[n2] - 1) / nArray3[n2] + 1 : (n5 - nArray2[n2] + 1) / nArray3[n2] + 1;
            ++n2;
        }
        return nArray4;
    }

    @Test
    public void testExpandedSliceIterations() {
        int n;
        int n2;
        int n3 = 1024;
        System.out.println("Size: " + n3);
        DataSet dataSet = DataSet.arange(n3);
        int[] nArray = (int[])dataSet.getShape().clone();
        dataSet.set(0, n3);
        System.out.println(" New size: " + dataSet.getSize());
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, n3, 0, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, n3, 0, 0, n3 + 1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, n3, 23, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, n3, 23, 0, n3 + 1, 0);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(16, n3 / 16);
        nArray = (int[])dataSet.getShape().clone();
        int n4 = 0;
        int n5 = dataSet.getDimensions()[1];
        while (n4 < n5) {
            dataSet.set(0, 16, n4++);
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 1, -3, 1);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(n3 / 32, 32);
        nArray = (int[])dataSet.getShape().clone();
        n4 = 0;
        n5 = dataSet.getDimensions()[0];
        while (n4 < n5) {
            dataSet.set(0, n4++, 32);
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 0, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 2, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 1, 32, 3, 1, -3, 1);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(16, 8, n3 / 128);
        nArray = (int[])dataSet.getShape().clone();
        n4 = 0;
        n5 = dataSet.getDimensions()[1];
        while (n4 < n5) {
            n2 = 0;
            n = dataSet.getDimensions()[2];
            while (n2 < n) {
                dataSet.set(0, 16, n4, n2++);
            }
            ++n4;
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 0, 0, -3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 3, 0, -3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 1, 1, -3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 0, 16, 2, 2, -3, 2);
        dataSet = DataSet.arange(n3);
        dataSet.reshape(n3 / 128, 16, 8);
        nArray = (int[])dataSet.getShape().clone();
        n4 = 0;
        n5 = dataSet.getDimensions()[0];
        while (n4 < n5) {
            n2 = 0;
            n = dataSet.getDimensions()[1];
            while (n2 < n) {
                dataSet.set(0, n4, n2++, 8);
            }
            ++n4;
        }
        System.out.println(" New size: " + dataSet.getSize());
        System.out.println(" Shape: " + Arrays.toString(dataSet.getDimensions()));
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, 3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, 3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, 3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, 4, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, 4, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, 4, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -1, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -1, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -1, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -2, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -2, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -2, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 0, 0, -3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 3, 0, -3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 1, 1, -3, 2);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -3, 0);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -3, 1);
        this.testSlicedExpandedDataSet(dataSet, nArray, 2, 8, 2, 2, -3, 2);
    }
}

