/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis;

import gda.analysis.DataSet;
import gda.analysis.functions.APeak;
import gda.analysis.functions.CompositeFunction;
import gda.analysis.functions.FittedPeak;
import gda.analysis.functions.IdentifiedPeak;
import gda.analysis.functions.Offset;
import gda.analysis.utils.DatasetMaths;
import gda.analysis.utils.GeneticAlg;
import gda.analysis.utils.IOptimizer;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;

public class Generic1DFitter
implements Serializable {
    public static int defaultSmoothing = 3;
    public static double defaultAccuracy = 1.0E-4;
    public static IOptimizer defaultOptimiser = new GeneticAlg(defaultAccuracy);
    private static double epslion = 1.0E-5;
    protected static final transient Logger logger = LoggerFactory.getLogger(Generic1DFitter.class);

    public static List<FittedPeak> fitPeaks(AbstractDataset abstractDataset, APeak aPeak, int n) {
        DoubleDataset doubleDataset = DoubleDataset.arange(abstractDataset.getSize());
        return Generic1DFitter.fitPeaks(doubleDataset, abstractDataset, aPeak, n);
    }

    public static List<FittedPeak> fitPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, APeak aPeak, int n) {
        int n2 = (int)((double)abstractDataset.getSize() * 0.01);
        int n3 = n2 > defaultSmoothing ? n2 : defaultSmoothing;
        return Generic1DFitter.fitPeaks(abstractDataset, abstractDataset2, aPeak, defaultOptimiser, n3, n);
    }

    public static List<FittedPeak> fitPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, APeak aPeak, IOptimizer iOptimizer, int n, int n2) {
        List<IdentifiedPeak> list = Generic1DFitter.parseDataDerivative(abstractDataset, abstractDataset2, n);
        if (list == null || list.size() <= 0) {
            logger.error("No peaks found");
        }
        List<APeak> list2 = Generic1DFitter.fitFunction(list, aPeak, abstractDataset, abstractDataset2, iOptimizer, n2);
        ArrayList<FittedPeak> arrayList = new ArrayList<FittedPeak>();
        int n3 = 0;
        while (n3 < list2.size()) {
            arrayList.add(new FittedPeak(list2.get(n3), list.get(n3)));
            ++n3;
        }
        return arrayList;
    }

    public static List<IdentifiedPeak> findPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int n) {
        return Generic1DFitter.parseDataDerivative(abstractDataset, abstractDataset2, n);
    }

    private static List<APeak> fitFunction(List<IdentifiedPeak> list, APeak aPeak, AbstractDataset abstractDataset, AbstractDataset abstractDataset2, IOptimizer iOptimizer, int n) {
        ArrayList<APeak> arrayList = new ArrayList<APeak>();
        Constructor<?>[] constructorArray = aPeak.getClass().getConstructors();
        if (n == 0) {
            n = list.size();
        }
        int n2 = 0;
        block6: for (IdentifiedPeak identifiedPeak : list) {
            if (n2++ >= n) break;
            int[] nArray = new int[]{identifiedPeak.getIndexOfDataSetAtMinPos()};
            int[] nArray2 = new int[]{identifiedPeak.getIndexOfDataSetAtMaxPos() + 1};
            int[] nArray3 = new int[]{1};
            DataSet dataSet = AbstractDataset.toDataSet(abstractDataset2.getSlice(nArray, nArray2, nArray3));
            DataSet dataSet2 = AbstractDataset.toDataSet(abstractDataset.getSlice(nArray, nArray2, nArray3));
            double[] dArray = dataSet.doubleArray();
            Arrays.sort(dArray);
            double d = dataSet.get((int)Math.floor(dArray.length / 2));
            Offset offset = new Offset(0.0, d * 0.5);
            int n3 = 0;
            while (n3 < constructorArray.length) {
                try {
                    APeak aPeak2 = (APeak)constructorArray[n3].newInstance(identifiedPeak);
                    CompositeFunction compositeFunction = new CompositeFunction();
                    compositeFunction.addFunction(aPeak2);
                    compositeFunction.addFunction(offset);
                    iOptimizer.Optimize(new DataSet[]{dataSet2}, dataSet, compositeFunction);
                    arrayList.add(aPeak2);
                    continue block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (n3 >= constructorArray.length) {
                        throw new IllegalArgumentException("A constructor for the given function could not be found", illegalArgumentException);
                    }
                }
                catch (InstantiationException instantiationException) {
                    logger.error("The function could not be created for fitting");
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                    invocationTargetException.getCause();
                    invocationTargetException.getTargetException();
                }
                catch (Exception exception) {
                    logger.error("There was a problem creating the optimizer.");
                }
                ++n3;
            }
        }
        return arrayList;
    }

    private static List<IdentifiedPeak> parseDataDerivative(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int n) {
        boolean bl = false;
        ArrayList<IdentifiedPeak> arrayList = new ArrayList<IdentifiedPeak>();
        AbstractDataset abstractDataset3 = Maths.derivative(abstractDataset, abstractDataset2, n);
        int n2 = 0;
        while (n2 < abstractDataset3.getSize() - 1) {
            if (abstractDataset3.getElementDoubleAbs(n2) >= 0.0 && abstractDataset3.getElementDoubleAbs(n2 + 1) < 0.0) {
                int n3 = n2;
                double d = 0.0;
                int n4 = 0;
                while (n3 > 0) {
                    if (!(abstractDataset3.getElementDoubleAbs(n3) >= 0.0)) break;
                    ++n4;
                    d += abstractDataset3.getElementDoubleAbs(n3);
                    --n3;
                }
                int n5 = n2 + 1;
                double d2 = 0.0;
                int n6 = 0;
                while (n5 < abstractDataset3.getSize() - 1) {
                    if (!(abstractDataset3.getElementDoubleAbs(n5) <= 0.0)) break;
                    ++n6;
                    d2 -= abstractDataset3.getElementDoubleAbs(n5);
                    ++n5;
                }
                if (Math.min(d, d2) > epslion) {
                    int[] nArray = new int[]{n3};
                    int[] nArray2 = new int[]{n5};
                    int[] nArray3 = new int[]{1};
                    AbstractDataset abstractDataset4 = abstractDataset.getSlice(nArray, nArray2, nArray3);
                    AbstractDataset abstractDataset5 = abstractDataset2.getSlice(nArray, nArray2, nArray3);
                    List<Double> list = DatasetMaths.crossings(AbstractDataset.toDataSet(abstractDataset4), AbstractDataset.toDataSet(abstractDataset5), abstractDataset5.max().doubleValue() / 2.0);
                    if (list.size() <= 0) {
                        list.add(Double.valueOf(n3));
                        list.add(Double.valueOf(n5));
                    }
                    IdentifiedPeak identifiedPeak = new IdentifiedPeak(abstractDataset.getElementDoubleAbs(n2), abstractDataset.getElementDoubleAbs(n3), abstractDataset.getElementDoubleAbs(n5), Math.min(d, d2), abstractDataset5.max().doubleValue(), n3, n5, list);
                    if (bl) {
                        System.out.println("Back Position = " + abstractDataset.getElementDoubleAbs(n3) + " Peak Pos = " + abstractDataset.getElementDoubleAbs(n2) + " Forward Position = " + abstractDataset.getElementDoubleAbs(n5) + ". Y value at back pos = " + abstractDataset2.getElementDoubleAbs(n3) + " Y value at forward pos = " + abstractDataset2.getElementDoubleAbs(n5) + " height " + abstractDataset5.max() + " Area " + Math.min(d, d2) + " sum of area variables " + (d + d2));
                    }
                    arrayList.add(identifiedPeak);
                }
            }
            ++n2;
        }
        Collections.sort(arrayList, new Compare());
        if (bl && arrayList.size() <= 0) {
            System.err.println("No Peaks Found!!");
        }
        return arrayList;
    }

    private static class Compare
    implements Comparator<IdentifiedPeak> {
        private Compare() {
        }

        @Override
        public int compare(IdentifiedPeak identifiedPeak, IdentifiedPeak identifiedPeak2) {
            if (identifiedPeak.getArea() < identifiedPeak2.getArea()) {
                return 1;
            }
            if (identifiedPeak.getArea() > identifiedPeak2.getArea()) {
                return -1;
            }
            return 0;
        }
    }
}

