/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis;

import gda.analysis.DataSet;
import gda.analysis.functions.AFunction;
import gda.analysis.functions.CompositeFunction;
import gda.analysis.functions.FunctionOutput;
import gda.analysis.functions.Gaussian;
import gda.analysis.functions.GaussianND;
import gda.analysis.functions.IFunction;
import gda.analysis.functions.Offset;
import gda.analysis.functions.Parameter;
import gda.analysis.utils.GeneticAlg;
import gda.analysis.utils.NelderMead;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.python.modules.math;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaussianFitter
implements Serializable {
    protected static final transient Logger logger = LoggerFactory.getLogger(GaussianFitter.class);

    public static List<Double> fitGaussian1D(DataSet dataSet, int n, int n2) {
        List<FunctionOutput> list = GaussianFitter.fitGaussianTo1DDataset(dataSet, n, n2);
        return GaussianFitter.removeDuplicateGaussian(list, dataSet.getSize());
    }

    public static List<FunctionOutput> fitGaussianTo1DDataset(DataSet dataSet, int n, int n2) {
        Object object;
        if (dataSet.getRank() != 1) {
            return null;
        }
        ArrayList<FunctionOutput> arrayList = new ArrayList<FunctionOutput>();
        FunctionOutput functionOutput = null;
        double d = (double)dataSet.getSize() * dataSet.range();
        int n3 = 0;
        while (n3 + n2 < dataSet.getSize()) {
            int n4 = n3 + n > dataSet.getSize() ? dataSet.getSize() : n3 + n;
            DataSet dataSet2 = dataSet.getSlice(n3, n4);
            object = DataSet.arange(n3, n4);
            double d2 = ((DataSet)object).get(dataSet2.maxPos()[0]);
            double d3 = ((DataSet)object).range() / 4.0;
            double d4 = d3 * dataSet2.range();
            try {
                double[] dArray = dataSet.doubleArray();
                Arrays.sort(dArray);
                double d5 = dArray[(int)math.floor((double)(dArray.length / 2))];
                functionOutput = GaussianFitter.nelderMeadFit(new DataSet[]{object}, dataSet2, 1.0E-4, new Gaussian(d2, d3, d4), new Offset(d5 * 0.95, d5));
                double d6 = functionOutput.getParameterValue(0);
                double d7 = functionOutput.getParameterValue(1);
                double d8 = functionOutput.getParameterValue(2);
                if (d6 > (double)n3 && d6 < (double)n4 && d7 < 1.5 * (double)n && d8 < d) {
                    arrayList.add(functionOutput);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            n3 += n2;
        }
        n3 = 0;
        while (n3 < arrayList.size()) {
            object = ((FunctionOutput)arrayList.get(n3)).getFunction().getParameters();
            logger.info("Peak {} as {} with width {} and ampl {}", new Object[]{n3, object[0].getValue() / 2.0, ((Parameter)object[1]).getValue(), ((Parameter)object[2]).getValue()});
            ++n3;
        }
        return arrayList;
    }

    private static List<Double> removeDuplicateGaussian(List<FunctionOutput> list, double d) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < list.size()) {
            IFunction iFunction = list.get(n).getFunction();
            double d2 = iFunction.getParameterValue(0);
            double d3 = iFunction.getParameterValue(1);
            if (!(d3 > d)) {
                int n2 = n + 1;
                while (n2 < list.size()) {
                    IFunction iFunction2 = list.get(n2).getFunction();
                    double d4 = iFunction2.getParameterValue(0);
                    double d5 = iFunction2.getParameterValue(1);
                    double d6 = Math.min(d3, d5) / 2.0;
                    if (Math.abs(d2 - d4) < d6) {
                        logger.info("Peaks {} and {} are paired", (Object)n, (Object)n2);
                        arrayList.add((d2 + d4) / 2.0);
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                if (n2 == list.size()) {
                    logger.info("Solo peak {}", (Object)n);
                    arrayList.add(d2);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private static FunctionOutput nelderMeadFit(DataSet[] dataSetArray, DataSet dataSet, double d, AFunction ... aFunctionArray) throws Exception {
        CompositeFunction compositeFunction = new CompositeFunction();
        NelderMead nelderMead = new NelderMead(d);
        int n = 0;
        while (n < aFunctionArray.length) {
            compositeFunction.addFunction(aFunctionArray[n]);
            ++n;
        }
        nelderMead.Optimize(dataSetArray, dataSet, compositeFunction);
        FunctionOutput functionOutput = new FunctionOutput(compositeFunction);
        functionOutput.setChiSquared(compositeFunction.residual(true, dataSet, dataSetArray));
        functionOutput.setAreaUnderFit(compositeFunction.makeDataSet(dataSetArray).sum() * ((dataSetArray[0].max() - dataSetArray[0].min()) / (double)dataSetArray[0].getSize()));
        return functionOutput;
    }

    private static FunctionOutput geneticAlgorithmFit(DataSet[] dataSetArray, DataSet dataSet, double d, AFunction ... aFunctionArray) throws Exception {
        CompositeFunction compositeFunction = new CompositeFunction();
        GeneticAlg geneticAlg = new GeneticAlg(d);
        int n = 0;
        while (n < aFunctionArray.length) {
            compositeFunction.addFunction(aFunctionArray[n]);
            ++n;
        }
        geneticAlg.Optimize(dataSetArray, dataSet, compositeFunction);
        FunctionOutput functionOutput = new FunctionOutput(compositeFunction);
        functionOutput.setChiSquared(compositeFunction.residual(true, dataSet, dataSetArray));
        functionOutput.setAreaUnderFit(compositeFunction.makeDataSet(dataSetArray).sum() * ((dataSetArray[0].max() - dataSetArray[0].min()) / (double)dataSetArray[0].getSize()));
        return functionOutput;
    }

    public static List<Double> fitGaussian2D(DataSet dataSet, double d, double d2, double[] dArray) {
        List<FunctionOutput> list = GaussianFitter.fitGaussianTo2DDataset(dataSet, d, d2, dArray);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (list.size() > 0) {
            FunctionOutput functionOutput = list.get(0);
            arrayList.add(functionOutput.getParameterValue(0));
            arrayList.add(functionOutput.getParameterValue(1));
        }
        return arrayList;
    }

    public static List<FunctionOutput> fitGaussianTo2DDataset(DataSet dataSet, double d, double d2, double[] dArray) {
        if (dataSet.getRank() != 2) {
            return null;
        }
        ArrayList<FunctionOutput> arrayList = new ArrayList<FunctionOutput>();
        FunctionOutput functionOutput = null;
        int[] nArray = dataSet.getShape();
        DataSet dataSet2 = DataSet.arange(nArray[0]);
        DataSet dataSet3 = DataSet.arange(nArray[1]);
        try {
            double[] dArray2 = dataSet.doubleArray();
            Arrays.sort(dArray2);
            double d3 = dArray2[(int)math.floor((double)(dArray2.length / 2))];
            double d4 = 2.0 * d2 * 25.0 * d * d;
            GaussianND gaussianND = new GaussianND(d4, new double[]{0.0, 0.0}, new double[]{nArray[0], nArray[1]}, 5.0 * d);
            logger.info("Starting peak value {}", (Object)gaussianND.getPeakValue());
            if (dArray != null) {
                gaussianND.setPeakPosition(dArray);
            } else {
                double[] dArray3 = new double[]{(double)nArray[0] / 2.0, (double)nArray[1] / 2.0};
                gaussianND.setPeakPosition(dArray3);
            }
            try {
                functionOutput = GaussianFitter.geneticAlgorithmFit(new DataSet[]{dataSet2, dataSet3}, dataSet, 0.1, gaussianND, new Offset(d3 / 100.0, d3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Problem with fitting!!!");
                return arrayList;
            }
            logger.info("Fitted peak value {}", (Object)gaussianND.getPeakValue());
            double d5 = functionOutput.getParameterValue(0);
            double d6 = functionOutput.getParameterValue(1);
            double d7 = Math.sqrt(functionOutput.getParameterValue(3));
            double d8 = Math.sqrt(functionOutput.getParameterValue(4));
            if (d5 < (double)nArray[0] && d6 < (double)nArray[1] && d7 < 1.5 * d && d8 < 1.5 * d) {
                arrayList.add(functionOutput);
            } else {
                logger.info("Ignoring peak at {}, {} with width {}, {} and vol {}", new Object[]{d5, d6, d7, d8, functionOutput.getParameterValue(2)});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        while (n < arrayList.size()) {
            Parameter[] parameterArray = ((FunctionOutput)arrayList.get(n)).getFunction().getParameters();
            logger.info("Peak {} as {}, {} with width {}, {} and vol {}", new Object[]{n, parameterArray[0].getValue(), parameterArray[1].getValue(), Math.sqrt(parameterArray[3].getValue()), Math.sqrt(parameterArray[4].getValue()), parameterArray[2].getValue()});
            ++n;
        }
        return arrayList;
    }
}

