/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.sequence;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public final class ArrayToSequenceConverter
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(ArrayToSequenceConverter.class);

    public ArrayToSequenceConverter(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry - message :" + managedMessage);
        }
        try {
            Object object = managedMessage.getBodyContent();
            try {
                Object[] objectArray = (Object[])object;
                Long l = MessageFactory.getInstance().createSequenceID();
                int n = 0;
                while (n < objectArray.length) {
                    ManagedMessage managedMessage2 = MessageFactory.getInstance().createMessageInSequence(l, new Long(n), n >= objectArray.length - 1, this.getStandardMessageHeaders());
                    managedMessage2.addCauseID(managedMessage.getID());
                    managedMessage2.setBodyContent(objectArray[n], "application/java");
                    this.sendOutputMsg(this.output, managedMessage2);
                    ++n;
                }
            }
            catch (ClassCastException classCastException) {
                this.sendOutputMsg(this.output, managedMessage);
            }
        }
        catch (MessageException messageException) {
            throw new ProcessingException("", (Object)managedMessage, (Throwable)messageException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    protected String getExtendedInfo() {
        return "";
    }
}

