/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.io;

import com.isencia.message.ChannelException;
import com.isencia.message.ISenderChannel;
import com.isencia.message.generator.IMessageGenerator;
import com.isencia.message.generator.MessageTextLineGenerator;
import com.isencia.message.io.FileSenderChannel;
import com.isencia.passerelle.actor.ChannelSink;
import com.isencia.passerelle.util.EnvironmentUtils;
import com.isencia.util.StringConvertor;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class FileWriter
extends ChannelSink {
    private static Logger logger = LoggerFactory.getLogger(FileWriter.class);
    public static final String PATH_PARAM = "Path";
    public static final String APPEND_PARAM = "Append";
    public static final String ENCODING_PARAM = "Encoding";
    public FileParameter destinationPathParam = new FileParameter((NamedObj)this, "Path");
    private String destinationPath = null;
    private boolean appendMode = true;
    public Parameter appendModeParam;
    public Parameter fileEncodingParam = null;
    private String fileEncoding = null;

    public FileWriter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        try {
            URI uRI = new URI("file://" + StringConvertor.convertPathDelimiters((String)EnvironmentUtils.getApplicationRootFolder()));
            this.destinationPathParam.setBaseDirectory(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.registerConfigurableParameter((Parameter)this.destinationPathParam);
        this.fileEncodingParam = new StringParameter((NamedObj)this, ENCODING_PARAM);
        this.registerConfigurableParameter(this.fileEncodingParam);
        this.appendModeParam = new Parameter((NamedObj)this, APPEND_PARAM, (Token)new BooleanToken(true));
        this.appendModeParam.setTypeEquals((Type)BaseType.BOOLEAN);
        this.registerConfigurableParameter(this.appendModeParam);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.fileEncodingParam) {
            try {
                this.setFileEncoding(this.fileEncodingParam.getExpression());
                logger.debug("fileEncoding changed to : " + this.getFileEncoding());
            }
            catch (NullPointerException nullPointerException) {}
        } else if (attribute == this.destinationPathParam) {
            try {
                this.setDestinationPath(this.destinationPathParam.asFile().getPath());
                logger.debug("Destination Path changed to : " + this.getDestinationPath());
            }
            catch (NullPointerException nullPointerException) {}
        } else if (attribute == this.appendModeParam) {
            BooleanToken booleanToken = (BooleanToken)this.appendModeParam.getToken();
            if (booleanToken != null) {
                this.setAppendMode(booleanToken.booleanValue());
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return this.getDestinationPath();
    }

    protected String getFileEncoding() {
        return this.fileEncoding;
    }

    protected void setFileEncoding(String string) {
        this.fileEncoding = string;
    }

    protected ISenderChannel createChannel() {
        if (this.getFileEncoding() != null && this.getFileEncoding().length() > 0) {
            return new FileSenderChannel(new File(this.getDestinationPath()), this.getFileEncoding(), (IMessageGenerator)new MessageTextLineGenerator());
        }
        return new FileSenderChannel(new File(this.getDestinationPath()), (IMessageGenerator)new MessageTextLineGenerator());
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String string) {
        this.destinationPath = string;
    }

    public boolean isAppendMode() {
        return this.appendMode;
    }

    public void setAppendMode(boolean bl) {
        this.appendMode = bl;
    }

    protected void openChannel(ISenderChannel iSenderChannel) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + iSenderChannel);
        }
        if (iSenderChannel != null) {
            ((FileSenderChannel)iSenderChannel).open(this.isAppendMode());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }
}

