/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.ftp;

import com.isencia.message.ChannelException;
import com.isencia.message.ReaderReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpReceiverChannel
extends ReaderReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(FtpReceiverChannel.class);
    private String server;
    private String username;
    private String password;
    private boolean binaryTransfer = false;
    private boolean passiveMode = true;
    private File remote;
    private FTPClient ftp;

    public FtpReceiverChannel(File file, String string, String string2, String string3, boolean bl, boolean bl2, IMessageExtractor iMessageExtractor) {
        super(iMessageExtractor);
        this.remote = file;
        this.server = string;
        this.username = string2;
        this.password = string3;
        this.binaryTransfer = bl;
        this.passiveMode = bl2;
        this.ftp = new FTPClient();
    }

    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (this.server == null) {
            throw new ChannelException("Server is not specified");
        }
        if (this.username == null) {
            throw new ChannelException("Username is not specified");
        }
        if (this.password == null) {
            throw new ChannelException("Password is not specified");
        }
        if (this.remote == null) {
            throw new ChannelException("File is not specified");
        }
        try {
            this.ftp.connect(this.server);
            logger.debug("Connected to " + this.server + ".");
            int n = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                this.ftp.disconnect();
                logger.error("FTP server refused connection");
                throw new ChannelException("FTP server refused connection");
            }
        }
        catch (IOException iOException) {
            if (this.ftp.isConnected()) {
                try {
                    this.ftp.disconnect();
                }
                catch (IOException iOException2) {}
            }
            logger.error("Could not connect to server");
            throw new ChannelException("Could not connect to server");
        }
        try {
            if (!this.ftp.login(this.username, this.password)) {
                this.ftp.logout();
                throw new ChannelException("Can't login with username " + this.username + " and password " + this.password);
            }
            logger.debug("Remote system is " + this.ftp.getSystemName());
            if (this.binaryTransfer) {
                this.ftp.setFileType(2);
            }
            if (this.passiveMode) {
                this.ftp.enterLocalPassiveMode();
            }
        }
        catch (ChannelException channelException) {
            throw new ChannelException(channelException.getMessage());
        }
        catch (IOException iOException) {
            throw new ChannelException(String.valueOf(iOException.getMessage()) + " (IOException)");
        }
        try {
            this.setReader(new InputStreamReader(this.ftp.retrieveFileStream(this.remote.getPath()), "UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ChannelException("Error opening source file " + this.remote.getAbsolutePath() + " (file not found): " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new ChannelException("Error opening source file " + this.remote.getAbsolutePath() + " : " + iOException.getMessage());
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("exit");
        }
    }

    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (this.isOpen()) {
            super.close();
        }
        try {
            try {
                this.ftp.logout();
            }
            catch (FTPConnectionClosedException fTPConnectionClosedException) {
                throw new ChannelException("Server closed connection.");
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (this.ftp.isConnected()) {
                try {
                    this.ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (IOException iOException) {}
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit");
        }
    }
}

