/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.ftp;

import com.isencia.message.IReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import com.isencia.message.extractor.TextLineMessageExtractor;
import com.isencia.passerelle.actor.TriggeredChannelSource;
import com.isencia.passerelle.actor.ftp.FtpReceiverChannel;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class FtpReader
extends TriggeredChannelSource {
    private static Logger logger = LoggerFactory.getLogger(FtpReader.class);
    public Parameter serverParam = new Parameter((NamedObj)this, "Server", (Token)new StringToken(""));
    private String server = null;
    private static final String SERVER_PARAM = "Server";
    public Parameter userParam = null;
    private String user = null;
    private static final String USER_PARAM = "User";
    public Parameter passwordParam = null;
    private String password = null;
    private static final String PASSWORD_PARAM = "Password";
    public Parameter isBinaryTransferParam = null;
    private boolean isBinaryTransfer = false;
    private static final String IS_BINARY_TRANSFER_PARAM = "Binary";
    public Parameter isPassiveModeParam = null;
    private boolean isPassiveMode = true;
    private static final String IS_PASSIVE_MODE_PARAM = "Passive Mode";
    public Parameter fileParam = null;
    private String file = null;
    private static final String FILE_PARAM = "File to read";

    public FtpReader(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.serverParam.setTypeEquals((Type)BaseType.STRING);
        this.userParam = new Parameter((NamedObj)this, USER_PARAM, (Token)new StringToken(""));
        this.userParam.setTypeEquals((Type)BaseType.STRING);
        this.passwordParam = new Parameter((NamedObj)this, PASSWORD_PARAM, (Token)new StringToken(""));
        this.passwordParam.setTypeEquals((Type)BaseType.STRING);
        this.isPassiveModeParam = new Parameter((NamedObj)this, IS_PASSIVE_MODE_PARAM, (Token)new BooleanToken(this.isPassiveMode));
        this.isPassiveModeParam.setTypeEquals((Type)BaseType.BOOLEAN);
        this.isBinaryTransferParam = new Parameter((NamedObj)this, IS_BINARY_TRANSFER_PARAM, (Token)new BooleanToken(this.isBinaryTransfer));
        this.isBinaryTransferParam.setTypeEquals((Type)BaseType.BOOLEAN);
        this.registerConfigurableParameter(this.isBinaryTransferParam);
        this.fileParam = new Parameter((NamedObj)this, FILE_PARAM, (Token)new StringToken(""));
        this.fileParam.setTypeEquals((Type)BaseType.STRING);
        this.registerConfigurableParameter(this.fileParam);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"-2\" cy=\"-7\" r=\"4\"style=\"fill:black\"/>\n<line x1=\"-15\" y1=\"-5\" x2=\"15\" y2=\"-5\" style=\"stroke-width:2.0\"/>\n<line x1=\"0\" y1=\"-5\" x2=\"15\" y2=\"-15\" style=\"stroke-width:2.0\"/>\n<line x1=\"0\" y1=\"-5\" x2=\"15\" y2=\"5\" style=\"stroke-width:2.0\"/>\n<line x1=\"-15\" y1=\"10\" x2=\"0\" y2=\"10\" style=\"stroke-width:1.0;stroke:gray\"/>\n<line x1=\"0\" y1=\"10\" x2=\"0\" y2=\"-5\" style=\"stroke-width:1.0;stroke:gray\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.serverParam) {
            StringToken stringToken = (StringToken)this.serverParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.server = stringToken.stringValue();
                logger.debug("Server changed to : " + this.server);
            }
        } else if (attribute == this.userParam) {
            StringToken stringToken = (StringToken)this.userParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.user = stringToken.stringValue();
                logger.debug("User changed to : " + this.user);
            }
        } else if (attribute == this.passwordParam) {
            StringToken stringToken = (StringToken)this.passwordParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.password = stringToken.stringValue();
                logger.debug("Password changed to : " + this.password);
            }
        } else if (attribute == this.isBinaryTransferParam) {
            BooleanToken booleanToken = (BooleanToken)this.isBinaryTransferParam.getToken();
            if (booleanToken != null) {
                this.isBinaryTransfer = booleanToken.booleanValue();
                logger.debug("Binary transfer changed to : " + this.isBinaryTransfer);
            }
        } else if (attribute == this.isPassiveModeParam) {
            BooleanToken booleanToken = (BooleanToken)this.isPassiveModeParam.getToken();
            if (booleanToken != null) {
                this.isPassiveMode = booleanToken.booleanValue();
                logger.debug("Passive mode changed to : " + this.isPassiveMode);
            }
        } else if (attribute == this.fileParam) {
            StringToken stringToken = (StringToken)this.fileParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.file = stringToken.stringValue();
                logger.debug("File changed to : " + this.file);
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return this.server;
    }

    protected IReceiverChannel createChannel() {
        FtpReceiverChannel ftpReceiverChannel = null;
        ftpReceiverChannel = new FtpReceiverChannel(new File(this.file), this.server, this.user, this.password, this.isBinaryTransfer, this.isPassiveMode, (IMessageExtractor)new TextLineMessageExtractor());
        return ftpReceiverChannel;
    }
}

