/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.flow;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class LoopController
extends Actor {
    private static Logger logger = LoggerFactory.getLogger(LoopController.class);
    public Port countPort;
    public Port inputPort;
    public Port handledPort;
    private boolean countPortExhausted = false;
    private boolean inputPortExhausted = false;
    private boolean handledPortExhausted = false;
    public Port outputPort;
    public Parameter maxCountParam;
    private int maxCount;
    private int loopCount = this.maxCount = 100;
    private int currentLoopIndex = 0;

    public LoopController(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.countPort = PortFactory.getInstance().createInputPort((Actor)this, "count", Integer.class);
        this.inputPort = PortFactory.getInstance().createInputPort((Actor)this, "input", null);
        this.handledPort = PortFactory.getInstance().createInputPort((Actor)this, "handled", null);
        this.outputPort = PortFactory.getInstance().createOutputPort((Actor)this, "output");
        this.maxCountParam = new Parameter((NamedObj)this, "Max Count", (Token)new IntToken(this.maxCount));
        this.maxCountParam.setTypeEquals((Type)BaseType.INT);
        this.registerConfigurableParameter(this.maxCountParam);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"10\"style=\"fill:white;stroke-width:2.0\"/>\n<line x1=\"10\" y1=\"0\" x2=\"7\" y2=\"-3\" style=\"stroke-width:2.0\"/>\n<line x1=\"10\" y1=\"0\" x2=\"13\" y2=\"-3\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    protected String getExtendedInfo() {
        return "" + this.maxCount;
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - doInitialize() - entry");
        }
        super.doInitialize();
        this.countPortExhausted = this.countPort.getWidth() <= 0;
        this.inputPortExhausted = false;
        this.handledPortExhausted = this.handledPort.getWidth() <= 0;
        this.currentLoopIndex = 0;
        try {
            this.loopCount = this.maxCount = ((IntToken)this.maxCountParam.getToken()).intValue();
        }
        catch (IllegalActionException illegalActionException) {
            throw new InitializationException("Error reading maxCount", (Object)this.maxCountParam, (Throwable)illegalActionException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - doInitialize() - exit");
        }
    }

    protected void doFire() throws ProcessingException {
        Object object;
        Long l;
        ManagedMessage managedMessage;
        block30: {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.getInfo()) + " - doFire() - entry");
            }
            ManagedMessage managedMessage2 = null;
            managedMessage = null;
            l = null;
            if (!this.countPortExhausted) {
                try {
                    managedMessage2 = MessageHelper.getMessage((IOPort)this.countPort);
                    if (managedMessage2 != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.valueOf(this.getInfo()) + " doFire() - received msg on port " + this.countPort.getName() + " msg :" + managedMessage2);
                        }
                        if ((object = managedMessage2.getBodyContent()) instanceof Number) {
                            this.loopCount = ((Number)object).intValue();
                        } else {
                            try {
                                this.loopCount = Integer.parseInt(object.toString());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        this.loopCount = this.loopCount > this.maxCount ? this.maxCount : this.loopCount;
                        break block30;
                    }
                    this.countPortExhausted = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(this.getInfo()) + " doFire() - found exhausted port " + this.countPort.getName());
                    }
                }
                catch (MessageException messageException) {
                    throw new ProcessingException("Error reading msg content", (Object)managedMessage2, (Throwable)messageException);
                }
                catch (PasserelleException passerelleException) {
                    throw new ProcessingException("Error reading from port", (Object)this.countPort, (Throwable)passerelleException);
                }
            }
        }
        if (!this.inputPortExhausted) {
            try {
                managedMessage = MessageHelper.getMessage((IOPort)this.inputPort);
                if (managedMessage != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(this.getInfo()) + " doFire() - received msg on port " + this.inputPort.getName() + " msg :" + managedMessage);
                    }
                    l = MessageFactory.getInstance().createSequenceID();
                } else {
                    this.inputPortExhausted = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(this.getInfo()) + " doFire() - found exhausted port " + this.inputPort.getName());
                    }
                }
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException("Error reading from port", (Object)this.inputPort, (Throwable)passerelleException);
            }
        }
        if (managedMessage != null) {
            this.sendLoopData(managedMessage, null, l, 0, this.loopCount <= 0);
            this.currentLoopIndex = 1;
            while (this.currentLoopIndex < this.loopCount) {
                try {
                    object = null;
                    if (!this.handledPortExhausted) {
                        object = MessageHelper.getMessage((IOPort)this.handledPort);
                        if (object != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.valueOf(this.getInfo()) + " doFire() - received msg on port " + this.handledPort.getName());
                            }
                        } else {
                            this.handledPortExhausted = true;
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.valueOf(this.getInfo()) + " doFire() - found exhausted port " + this.handledPort.getName());
                            }
                        }
                    }
                    this.sendLoopData(managedMessage, (ManagedMessage)object, l, this.currentLoopIndex, this.currentLoopIndex >= this.loopCount - 1);
                }
                catch (PasserelleException passerelleException) {
                    throw new ProcessingException("Error reading from port", (Object)this.inputPort, (Throwable)passerelleException);
                }
                ++this.currentLoopIndex;
            }
        }
        if (this.areAllInputsFinished()) {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - doFire() - exit");
        }
    }

    private void sendLoopData(ManagedMessage managedMessage, ManagedMessage managedMessage2, Long l, int n, boolean bl) throws ProcessingException {
        ManagedMessage managedMessage3 = null;
        try {
            managedMessage3 = MessageFactory.getInstance().createMessageCopyInSequence(managedMessage, l, new Long(n), bl);
            if (managedMessage2 != null) {
                managedMessage3.addCauseID(managedMessage2.getID());
            }
        }
        catch (MessageException messageException) {
            throw new ProcessingException("Error creating msg copy", (Object)managedMessage, (Throwable)messageException);
        }
        try {
            this.sendOutputMsg(this.outputPort, managedMessage3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException("Error sending msg", (Object)managedMessage, (Throwable)illegalArgumentException);
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) {
        return null;
    }

    private boolean areAllInputsFinished() {
        return this.countPortExhausted && this.inputPortExhausted;
    }

    public int getLoopCount() {
        return this.currentLoopIndex;
    }
}

