/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.filter;

import com.isencia.passerelle.actor.Filter;
import com.isencia.passerelle.actor.FilterException;
import com.isencia.passerelle.message.ManagedMessage;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class HeaderFilter
extends Filter {
    private static Logger logger = LoggerFactory.getLogger(HeaderFilter.class);
    private static final String STARTS_WITH = "StartsWith";
    private static final String ENDS_WITH = "EndsWith";
    private static final String CONTAINS = "Contains";
    private static final String EXISTS = "Exists";
    private static final String ABSENT = "Absent";
    private static final String REGEXP = "RegularExpression";
    public Parameter filterParam;
    public Parameter propertyParam = new StringParameter((NamedObj)this, "Header");
    public Parameter filterTypeParam;
    private String filter = "";
    private String filterType = null;
    private String property = "";

    public HeaderFilter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.propertyParam.setExpression("");
        this.filterTypeParam = new StringParameter((NamedObj)this, "FilterType");
        this.filterTypeParam.addChoice(STARTS_WITH);
        this.filterTypeParam.addChoice(CONTAINS);
        this.filterTypeParam.addChoice(REGEXP);
        this.filterTypeParam.addChoice(ENDS_WITH);
        this.filterTypeParam.addChoice(EXISTS);
        this.filterTypeParam.addChoice(ABSENT);
        this.filterParam = new StringParameter((NamedObj)this, "Filter");
        this.filterParam.setExpression("");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.propertyParam) {
            this.property = ((StringToken)this.propertyParam.getToken()).stringValue();
            logger.debug("Header set to : " + this.property);
        } else if (attribute == this.filterParam) {
            this.filter = ((StringToken)this.filterParam.getToken()).stringValue();
            logger.debug("Filter set to : " + this.filter);
        } else if (attribute == this.filterTypeParam) {
            this.filterType = this.filterTypeParam.getExpression();
            logger.debug("FilterType set to : " + this.filterType);
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.property) + ":" + this.filterType + ":" + this.filter;
    }

    protected boolean isMatchingFilter(Object object) throws FilterException {
        boolean bl = false;
        if (object instanceof ManagedMessage) {
            ManagedMessage managedMessage = (ManagedMessage)object;
            try {
                if (this.property == null || this.property.length() == 0 || this.filter == null || this.filter.length() == 0) {
                    bl = true;
                } else if (!managedMessage.hasBodyHeader(this.property)) {
                    bl = this.filterType.equals(ABSENT);
                } else {
                    bl = this.filterType.equals(EXISTS);
                    if (!bl) {
                        String[] stringArray = managedMessage.getBodyHeader(this.property);
                        bl = this.matchesFilter(stringArray);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                throw new FilterException(String.valueOf(this.getInfo()) + " exception in isMatchingFilter() :" + exception, object, (Throwable)exception);
            }
        }
        return bl;
    }

    protected boolean matchesFilter(String[] stringArray) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + stringArray);
        }
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length && !bl) {
                String string = stringArray[n];
                bl = this.filterType.equals(STARTS_WITH) && string.startsWith(this.filter) || this.filterType.equals(ENDS_WITH) && string.endsWith(this.filter) || this.filterType.equals(CONTAINS) && string.indexOf(this.filter) >= 0 || this.filterType.equals(REGEXP) && this.matchesRegExp(string, this.filter);
                ++n;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit :" + bl);
        }
        return bl;
    }

    protected boolean matchesRegExp(String string, String string2) {
        try {
            RE rE = new RE(string2);
            return rE.match(string);
        }
        catch (RESyntaxException rESyntaxException) {
            logger.error("Syntax error in regular expression " + string2, (Throwable)rESyntaxException);
            return false;
        }
    }
}

