/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.MessageHelper;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class XPathConverter
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(XPathConverter.class);
    public Parameter xpathSelectorParam = null;
    public Parameter valueParam = null;
    private String xpathSelector = "";
    private String value = null;

    public XPathConverter(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.output.setMultiport(true);
        this.input.setExpectedMessageContentType(String.class);
        this.xpathSelectorParam = new StringParameter((NamedObj)this, "XPath selector");
        this.xpathSelectorParam.setExpression("");
        this.valueParam = new StringParameter((NamedObj)this, "Value");
        this.valueParam.setExpression("");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.valueParam) {
            this.value = ((StringToken)this.valueParam.getToken()).stringValue();
        } else if (attribute == this.xpathSelectorParam) {
            this.xpathSelector = ((StringToken)this.xpathSelectorParam.getToken()).stringValue();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - message :" + managedMessage);
        }
        if (managedMessage != null && MessageHelper.hasTextContent((ManagedMessage)managedMessage)) {
            try {
                managedMessage = MessageFactory.getInstance().copyMessage(managedMessage);
                String string = managedMessage.getBodyContentAsString();
                if (string instanceof String) {
                    Object object;
                    Object object2;
                    InputSource inputSource;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(inputSource = new InputSource(new StringReader(managedMessage.getBodyContentAsString())));
                    NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)this.xpathSelector);
                    if (nodeList != null && nodeList.getLength() > 0) {
                        int n = 0;
                        while (n < nodeList.getLength()) {
                            object2 = nodeList.item(n);
                            if (object2.getNodeType() == 3) {
                                object2.setNodeValue(this.value);
                            } else {
                                object = object2.getChildNodes();
                                if (object != null && object.getLength() > 0) {
                                    int n2 = 0;
                                    while (n2 < object.getLength()) {
                                        Node node = object.item(n2);
                                        if (node.getNodeType() == 3) {
                                            node.setNodeValue(this.value);
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                    OutputFormat outputFormat = new OutputFormat(document);
                    outputFormat.setStandalone(false);
                    object2 = new StringWriter();
                    object = new XMLSerializer((Writer)object2, outputFormat);
                    object.serialize(document);
                    managedMessage.setBodyContent((Object)((StringWriter)object2).toString(), "text/xml");
                }
            }
            catch (Exception exception) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + "doFire() - Exception while applying Xpath " + this.xpathSelector, (Object)managedMessage, (Throwable)exception);
            }
        }
        try {
            this.sendOutputMsg(this.output, managedMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.xpathSelector) + " = " + this.value;
    }
}

