/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.actor.convert.Distributor;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class Collector
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(Distributor.class);
    private List inputLines = new ArrayList();

    public Collector(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.input.setExpectedMessageContentType(String.class);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"10\" y1=\"-15\" x2=\"10\" y2=\"-8\" style=\"stroke-width:3.0\"/>\n<line x1=\"10\" y1=\"8\" x2=\"10\" y2=\"15\" style=\"stroke-width:3.0\"/>\n<line x1=\"-10\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"-10\" y1=\"-10\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"-13\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"-7\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-10\" y1=\"10\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"7\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"13\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n</svg>\n");
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        this.inputLines.clear();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        String string;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            string = managedMessage.getBodyContentAsString();
        }
        catch (MessageException messageException) {
            throw new ProcessingException(messageException.getSeverity(), messageException.getMessage(), messageException.getContext(), (Throwable)messageException);
        }
        this.inputLines.add(string);
    }

    protected String getExtendedInfo() {
        return "";
    }

    protected void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.inputLines) {
                stringBuffer.append(string);
                stringBuffer.append(System.getProperty("line.separator"));
            }
            try {
                ManagedMessage managedMessage = this.createMessage(stringBuffer.toString(), "text/plain");
                this.sendOutputMsg(this.output, managedMessage);
                if (Collector.getAuditLogger().isInfoEnabled()) {
                    Collector.getAuditLogger().info("Sent collected message with " + this.inputLines.size() + " entries");
                }
            }
            catch (Exception exception) {
                throw new TerminationException(PasserelleException.Severity.FATAL, String.valueOf(this.getInfo()) + " - Exception while trying to send collected data", (Object)this, (Throwable)exception);
            }
        }
        finally {
            super.doWrapUp();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) {
        return null;
    }
}

