/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.impl.store.raw.data.RecordId;

public final class StoredRecordHeader {
    private static final byte RECORD_DELETED = 1;
    private static final byte RECORD_OVERFLOW = 2;
    private static final byte RECORD_HAS_FIRST_FIELD = 4;
    private static final byte RECORD_VALID_MASK = 15;
    protected int id;
    private byte status;
    protected int numberFields;
    protected RecordHandle handle;
    private OverflowInfo overflow;

    public StoredRecordHeader() {
    }

    public StoredRecordHeader(int n, int n2) {
        this.setId(n);
        this.setNumberFields(n2);
    }

    public StoredRecordHeader(byte[] byArray, int n) {
        this.read(byArray, n);
    }

    public StoredRecordHeader(StoredRecordHeader storedRecordHeader) {
        this.status = storedRecordHeader.status;
        this.id = storedRecordHeader.id;
        this.numberFields = storedRecordHeader.numberFields;
        this.handle = null;
        if (storedRecordHeader.overflow != null) {
            this.overflow = new OverflowInfo(storedRecordHeader.overflow);
        }
    }

    protected RecordHandle getHandle(PageKey pageKey, int n) {
        if (this.handle == null) {
            this.handle = new RecordId(pageKey, this.id, n);
        }
        return this.handle;
    }

    public final int getId() {
        return this.id;
    }

    public int getNumberFields() {
        return this.numberFields;
    }

    public long getOverflowPage() {
        return this.overflow == null ? 0L : this.overflow.overflowPage;
    }

    public int getOverflowId() {
        return this.overflow == null ? 0 : this.overflow.overflowId;
    }

    public int getFirstField() {
        return this.overflow == null ? 0 : this.overflow.firstField;
    }

    public final boolean hasOverflow() {
        return (this.status & 2) == 2;
    }

    protected final boolean hasFirstField() {
        return (this.status & 4) == 4;
    }

    public final boolean isDeleted() {
        return (this.status & 1) == 1;
    }

    public int size() {
        int n;
        int n2 = this.id <= 63 ? 2 : (n = this.id <= 16383 ? 3 : 5);
        if ((this.status & 6) == 0) {
            n += this.numberFields <= 63 ? 1 : (this.numberFields <= 16383 ? 2 : 4);
        } else if ((this.status & 2) == 0) {
            n += CompressedNumber.sizeInt(this.numberFields);
            n += CompressedNumber.sizeInt(this.overflow.firstField);
        } else {
            n += CompressedNumber.sizeLong(this.overflow.overflowPage);
            n += CompressedNumber.sizeInt(this.overflow.overflowId);
            if (this.hasFirstField()) {
                n += CompressedNumber.sizeInt(this.overflow.firstField);
                n += CompressedNumber.sizeInt(this.numberFields);
            }
        }
        return n;
    }

    public int setDeleted(boolean bl) {
        int n = 0;
        if (bl) {
            if (!this.isDeleted()) {
                n = 1;
                this.status = (byte)(this.status | 1);
            }
        } else if (this.isDeleted()) {
            n = -1;
            this.status = (byte)(this.status & 0xFFFFFFFE);
        }
        return n;
    }

    public void setFirstField(int n) {
        if (this.overflow == null) {
            this.overflow = new OverflowInfo();
        }
        this.overflow.firstField = n;
        this.status = (byte)(this.status | 4);
    }

    public final void setId(int n) {
        this.id = n;
    }

    public void setOverflowDetails(RecordHandle recordHandle) {
        if (this.overflow == null) {
            this.overflow = new OverflowInfo();
        }
        this.overflow.overflowPage = recordHandle.getPageNumber();
        this.overflow.overflowId = recordHandle.getId();
    }

    public void setOverflowFields(StoredRecordHeader storedRecordHeader) {
        if (this.overflow == null) {
            this.overflow = new OverflowInfo();
        }
        this.status = (byte)(storedRecordHeader.status | 2);
        this.id = storedRecordHeader.id;
        this.numberFields = storedRecordHeader.numberFields;
        this.overflow.firstField = storedRecordHeader.overflow.firstField;
        this.handle = null;
    }

    public final void setNumberFields(int n) {
        this.numberFields = n;
    }

    public int write(OutputStream outputStream) throws IOException {
        int n = 1;
        outputStream.write(this.status);
        n += CompressedNumber.writeInt(outputStream, this.id);
        if (this.hasOverflow()) {
            n += CompressedNumber.writeLong(outputStream, this.overflow.overflowPage);
            n += CompressedNumber.writeInt(outputStream, this.overflow.overflowId);
        }
        if (this.hasFirstField()) {
            n += CompressedNumber.writeInt(outputStream, this.overflow.firstField);
        }
        if (!this.hasOverflow() || this.hasFirstField()) {
            n += CompressedNumber.writeInt(outputStream, this.numberFields);
        }
        return n;
    }

    public void read(ObjectInput objectInput) throws IOException {
        int n = objectInput.read();
        if (n < 0) {
            throw new EOFException();
        }
        this.status = (byte)n;
        this.id = CompressedNumber.readInt(objectInput);
        this.overflow = this.hasOverflow() || this.hasFirstField() ? new OverflowInfo() : null;
        if (this.hasOverflow()) {
            this.overflow.overflowPage = CompressedNumber.readLong(objectInput);
            this.overflow.overflowId = CompressedNumber.readInt(objectInput);
        }
        if (this.hasFirstField()) {
            this.overflow.firstField = CompressedNumber.readInt(objectInput);
        }
        this.numberFields = !this.hasOverflow() || this.hasFirstField() ? CompressedNumber.readInt(objectInput) : 0;
        this.handle = null;
    }

    private int readOverFlowPage(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            this.overflow.overflowPage = by << 8 | byArray[n] & 0xFF;
            return 2;
        }
        if ((by & 0x80) == 0) {
            this.overflow.overflowPage = (by & 0x3F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
            return 4;
        }
        this.overflow.overflowPage = (long)(by & 0x7F) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n] & 0xFF);
        return 8;
    }

    private int readOverFlowId(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            this.overflow.overflowId = by;
            return 1;
        }
        if ((by & 0x80) == 0) {
            this.overflow.overflowId = (by & 0x3F) << 8 | byArray[n] & 0xFF;
            return 2;
        }
        this.overflow.overflowId = (by & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return 4;
    }

    private int readFirstField(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            this.overflow.firstField = by;
            return 1;
        }
        if ((by & 0x80) == 0) {
            this.overflow.firstField = (by & 0x3F) << 8 | byArray[n] & 0xFF;
            return 2;
        }
        this.overflow.firstField = (by & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return 4;
    }

    private void readNumberFields(byte[] byArray, int n) {
        int n2;
        this.numberFields = ((n2 = byArray[n++]) & 0xFFFFFFC0) == 0 ? n2 : ((n2 & 0x80) == 0 ? (n2 & 0x3F) << 8 | byArray[n] & 0xFF : (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
    }

    private void read(byte[] byArray, int n) {
        int n2;
        this.status = byArray[n++];
        this.id = ((n2 = byArray[n++]) & 0xFFFFFFC0) == 0 ? n2 : ((n2 & 0x80) == 0 ? (n2 & 0x3F) << 8 | byArray[n++] & 0xFF : (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        if ((this.status & 6) == 0) {
            this.overflow = null;
            this.readNumberFields(byArray, n);
        } else if ((this.status & 2) == 0) {
            this.overflow = new OverflowInfo();
            n += this.readFirstField(byArray, n);
            this.readNumberFields(byArray, n);
        } else {
            this.overflow = new OverflowInfo();
            n += this.readOverFlowPage(byArray, n);
            n += this.readOverFlowId(byArray, n);
            if (this.hasFirstField()) {
                n += this.readFirstField(byArray, n);
                this.readNumberFields(byArray, n);
            } else {
                this.numberFields = 0;
            }
        }
        this.handle = null;
    }

    public String toString() {
        return null;
    }

    private static class OverflowInfo {
        private int overflowId;
        private long overflowPage;
        private int firstField;

        private OverflowInfo() {
        }

        private OverflowInfo(OverflowInfo overflowInfo) {
            this.overflowId = overflowInfo.overflowId;
            this.overflowPage = overflowInfo.overflowPage;
            this.firstField = overflowInfo.firstField;
        }
    }
}

